/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSource;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSourceBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSourceFluentImpl;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSpec;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSpecFluent;
import java.util.Objects;

public class VolumeSnapshotContentSpecFluentImpl<A extends VolumeSnapshotContentSpecFluent<A>>
extends BaseFluent<A>
implements VolumeSnapshotContentSpecFluent<A> {
    private String deletionPolicy;
    private String driver;
    private VolumeSnapshotContentSourceBuilder source;
    private String volumeSnapshotClassName;
    private ObjectReferenceBuilder volumeSnapshotRef;

    public VolumeSnapshotContentSpecFluentImpl() {
    }

    public VolumeSnapshotContentSpecFluentImpl(VolumeSnapshotContentSpec instance) {
        this.withDeletionPolicy(instance.getDeletionPolicy());
        this.withDriver(instance.getDriver());
        this.withSource(instance.getSource());
        this.withVolumeSnapshotClassName(instance.getVolumeSnapshotClassName());
        this.withVolumeSnapshotRef(instance.getVolumeSnapshotRef());
    }

    @Override
    public String getDeletionPolicy() {
        return this.deletionPolicy;
    }

    @Override
    public A withDeletionPolicy(String deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionPolicy() {
        return this.deletionPolicy != null;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    @Deprecated
    public VolumeSnapshotContentSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public VolumeSnapshotContentSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(VolumeSnapshotContentSource source) {
        this._visitables.get((Object)"source").remove(this.source);
        if (source != null) {
            this.source = new VolumeSnapshotContentSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public A withNewSource(String snapshotHandle, String volumeHandle) {
        return this.withSource(new VolumeSnapshotContentSource(snapshotHandle, volumeHandle));
    }

    @Override
    public VolumeSnapshotContentSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public VolumeSnapshotContentSpecFluent.SourceNested<A> withNewSourceLike(VolumeSnapshotContentSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public VolumeSnapshotContentSpecFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public VolumeSnapshotContentSpecFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new VolumeSnapshotContentSourceBuilder().build());
    }

    @Override
    public VolumeSnapshotContentSpecFluent.SourceNested<A> editOrNewSourceLike(VolumeSnapshotContentSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public String getVolumeSnapshotClassName() {
        return this.volumeSnapshotClassName;
    }

    @Override
    public A withVolumeSnapshotClassName(String volumeSnapshotClassName) {
        this.volumeSnapshotClassName = volumeSnapshotClassName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeSnapshotClassName() {
        return this.volumeSnapshotClassName != null;
    }

    @Override
    @Deprecated
    public ObjectReference getVolumeSnapshotRef() {
        return this.volumeSnapshotRef != null ? this.volumeSnapshotRef.build() : null;
    }

    @Override
    public ObjectReference buildVolumeSnapshotRef() {
        return this.volumeSnapshotRef != null ? this.volumeSnapshotRef.build() : null;
    }

    @Override
    public A withVolumeSnapshotRef(ObjectReference volumeSnapshotRef) {
        this._visitables.get((Object)"volumeSnapshotRef").remove(this.volumeSnapshotRef);
        if (volumeSnapshotRef != null) {
            this.volumeSnapshotRef = new ObjectReferenceBuilder(volumeSnapshotRef);
            this._visitables.get((Object)"volumeSnapshotRef").add(this.volumeSnapshotRef);
        } else {
            this.volumeSnapshotRef = null;
            this._visitables.get((Object)"volumeSnapshotRef").remove(this.volumeSnapshotRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeSnapshotRef() {
        return this.volumeSnapshotRef != null;
    }

    @Override
    public VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<A> withNewVolumeSnapshotRef() {
        return new VolumeSnapshotRefNestedImpl();
    }

    @Override
    public VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<A> withNewVolumeSnapshotRefLike(ObjectReference item) {
        return new VolumeSnapshotRefNestedImpl(item);
    }

    @Override
    public VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<A> editVolumeSnapshotRef() {
        return this.withNewVolumeSnapshotRefLike(this.getVolumeSnapshotRef());
    }

    @Override
    public VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<A> editOrNewVolumeSnapshotRef() {
        return this.withNewVolumeSnapshotRefLike(this.getVolumeSnapshotRef() != null ? this.getVolumeSnapshotRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<A> editOrNewVolumeSnapshotRefLike(ObjectReference item) {
        return this.withNewVolumeSnapshotRefLike(this.getVolumeSnapshotRef() != null ? this.getVolumeSnapshotRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeSnapshotContentSpecFluentImpl that = (VolumeSnapshotContentSpecFluentImpl)o;
        if (this.deletionPolicy != null ? !this.deletionPolicy.equals(that.deletionPolicy) : that.deletionPolicy != null) {
            return false;
        }
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.volumeSnapshotClassName != null ? !this.volumeSnapshotClassName.equals(that.volumeSnapshotClassName) : that.volumeSnapshotClassName != null) {
            return false;
        }
        return !(this.volumeSnapshotRef != null ? !this.volumeSnapshotRef.equals((Object)that.volumeSnapshotRef) : that.volumeSnapshotRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.deletionPolicy, this.driver, this.source, this.volumeSnapshotClassName, this.volumeSnapshotRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deletionPolicy != null) {
            sb.append("deletionPolicy:");
            sb.append(this.deletionPolicy + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.volumeSnapshotClassName != null) {
            sb.append("volumeSnapshotClassName:");
            sb.append(this.volumeSnapshotClassName + ",");
        }
        if (this.volumeSnapshotRef != null) {
            sb.append("volumeSnapshotRef:");
            sb.append(this.volumeSnapshotRef);
        }
        sb.append("}");
        return sb.toString();
    }

    class VolumeSnapshotRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<N>>
    implements VolumeSnapshotContentSpecFluent.VolumeSnapshotRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        VolumeSnapshotRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        VolumeSnapshotRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentSpecFluentImpl.this.withVolumeSnapshotRef(this.builder.build());
        }

        @Override
        public N endVolumeSnapshotRef() {
            return this.and();
        }
    }

    class SourceNestedImpl<N>
    extends VolumeSnapshotContentSourceFluentImpl<VolumeSnapshotContentSpecFluent.SourceNested<N>>
    implements VolumeSnapshotContentSpecFluent.SourceNested<N>,
    Nested<N> {
        VolumeSnapshotContentSourceBuilder builder;

        SourceNestedImpl(VolumeSnapshotContentSource item) {
            this.builder = new VolumeSnapshotContentSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new VolumeSnapshotContentSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

