/*
 * Decompiled with CFR 0.152.
 */
package io.fares.bind.xjc.plugins.substitution;

import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import io.fares.bind.xjc.plugins.substitution.SubstitutionProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionCandidate {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CClassInfo classInfo;
    private final List<SubstitutionProperty> properties = new LinkedList<SubstitutionProperty>();

    public SubstitutionCandidate(CClassInfo classInfo, List<SubstitutionProperty> properties) {
        this.classInfo = classInfo;
        this.properties.addAll(properties);
    }

    public List<SubstitutionProperty> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void modifyStage1() {
        for (SubstitutionProperty property : this.properties) {
            property.modifyStage1();
        }
    }

    public void modifyStage2(Outline outline) {
        ClassOutline classOutline = outline.getClazz(this.classInfo);
        this.logger.info("");
        this.logger.info(String.format("inspecting %s", classOutline.implClass.fullName()));
        Map classFields = classOutline.ref.fields();
        for (SubstitutionProperty property : this.properties) {
            JFieldVar field = (JFieldVar)classFields.get(property.getFieldName());
            if (field == null) {
                property.ignoreStage2(" field was not generated");
                continue;
            }
            property.modifyStage2(outline, field);
        }
    }
}

