/*
 * Decompiled with CFR 0.152.
 */
package io.fares.bind.xjc.plugins.substitution;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import io.fares.bind.xjc.plugins.substitution.SubstitutionCandidate;
import io.fares.bind.xjc.plugins.substitution.SubstitutionPropertyVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.xml.sax.ErrorHandler;

public class SubstitutionPlugin
extends AbstractParameterizablePlugin {
    public static final String NS = "http://jaxb2-commons.dev.java.net/basic/substitution";
    public static final String SUBSTITUTION_HEAD = "head";
    public static final QName SUBSTITUTION_HEAD_NAME = new QName("http://jaxb2-commons.dev.java.net/basic/substitution", "head");
    public static final String SUBSTITUTION_HEAD_REF = "head-ref";
    public static final QName SUBSTITUTION_HEAD_REF_NAME = new QName("http://jaxb2-commons.dev.java.net/basic/substitution", "head-ref");
    private final Map<CClassInfo, SubstitutionCandidate> candidates = new LinkedHashMap<CClassInfo, SubstitutionCandidate>();
    private boolean firstModelPostProcessCall = true;

    public String getOptionName() {
        return "Xsubstitution";
    }

    public String getUsage() {
        return "  -Xsubstitution          : enable substitution group replacement";
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(SUBSTITUTION_HEAD_NAME, SUBSTITUTION_HEAD_REF_NAME);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.firstModelPostProcessCall) {
            this.firstModelPostProcessCall = false;
            this.logger.info((Object)"");
            this.logger.info((Object)"------------  Stage 1 - rewriting substitution type definitions ------------");
        }
        for (CClassInfo classInfo : model.beans().values()) {
            if (!classInfo.hasProperties()) continue;
            this.adjustClassProperties(classInfo);
        }
    }

    private void adjustClassProperties(CClassInfo classInfo) {
        this.logger.info((Object)"");
        this.logger.info((Object)String.format("inspecting %s", classInfo.fullName()));
        SubstitutionPropertyVisitor visitor = new SubstitutionPropertyVisitor(classInfo);
        for (CPropertyInfo property : classInfo.getProperties()) {
            property.accept((CPropertyVisitor)visitor);
        }
        SubstitutionCandidate candidate = new SubstitutionCandidate(classInfo, visitor.getProperties());
        if (visitor.hasSubstitutedProperties()) {
            candidate.modifyStage1();
            this.candidates.put(classInfo, candidate);
        }
    }

    public boolean run(Outline outline, Options opt) {
        this.logger.info((Object)"");
        this.logger.info((Object)"------------  Stage 2 - rewriting annotations ------------");
        for (SubstitutionCandidate candidate : this.candidates.values()) {
            candidate.modifyStage2(outline);
        }
        this.logger.info((Object)"");
        this.logger.info((Object)String.format("Fixed %d class substitutions", this.candidates.size()));
        this.logger.info((Object)"");
        return true;
    }
}

