/*
 * Decompiled with CFR 0.152.
 */
package io.fares.bind.xjc.plugins.substitution;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.Outline;
import io.fares.bind.xjc.plugins.substitution.PostProcessingException;
import io.fares.bind.xjc.plugins.substitution.SubstitutionProperty;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubstitutionPropertyBase<P extends CPropertyInfo, T extends CElement>
implements SubstitutionProperty<P, T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final CClassInfo classInfo;
    protected final P property;
    protected final T typeReference;

    public SubstitutionPropertyBase(CClassInfo classInfo, P property, T typeReference) {
        this.classInfo = classInfo;
        this.property = property;
        this.typeReference = typeReference;
    }

    @Override
    public P getProperty() {
        return this.property;
    }

    @Override
    public T getTypeReference() {
        return this.typeReference;
    }

    @Override
    public Class<P> getType() {
        return this.property.getClass();
    }

    @Override
    public String getFieldName() {
        return this.property.getName(false);
    }

    @Override
    public void ignoreStage2(String reason) {
        this.logger.info(String.format("  %-23s: %s", this.getFieldName(), reason));
    }

    void swapProperty(CPropertyInfo elementPropertyInfo) {
        int index = this.classInfo.getProperties().indexOf(this.property);
        this.classInfo.addProperty(elementPropertyInfo);
        this.classInfo.getProperties().remove(elementPropertyInfo);
        this.classInfo.getProperties().add(index, elementPropertyInfo);
        this.classInfo.getProperties().remove(this.property);
    }

    void replaceXmlElementWithRef(Outline outline, JFieldVar field) {
        JAnnotationUse xmlElementAnnotation = null;
        for (JAnnotationUse annotation : field.annotations()) {
            if (!XmlElement.class.getName().equals(annotation.getAnnotationClass().fullName())) continue;
            xmlElementAnnotation = annotation;
            break;
        }
        if (xmlElementAnnotation == null) {
            this.logger.warn("no XmlElement annotation found");
            return;
        }
        JClass refAnnotation = outline.getCodeModel().ref(XmlElementRef.class);
        try {
            this.logger.info(String.format("  %-23s: swap XmlElement for XmlElementRef", field.name()));
            FieldUtils.writeField((Object)xmlElementAnnotation, (String)"clazz", (Object)refAnnotation, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new PostProcessingException("The substitution plugin is prevented from modifying an inaccessible field in the XJC model (generation time only). Please ensure your security manager is configured correctly.", e);
        }
        catch (IllegalArgumentException e) {
            throw new PostProcessingException("The substitution plugin encountered an internal error extracting the generated field details.", e);
        }
    }
}

