/*
 * Decompiled with CFR 0.152.
 */
package io.fares.bind.xjc.plugins.substitution;

import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPropertyVisitor;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.CTypeRef;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.xml.bind.v2.model.core.MaybeElement;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSParticle;
import io.fares.bind.xjc.plugins.substitution.ChoicePropertyElement;
import io.fares.bind.xjc.plugins.substitution.SubstitutionProperty;
import io.fares.bind.xjc.plugins.substitution.SubstitutionPropertyElement;
import io.fares.bind.xjc.plugins.substitution.SubstitutionPropertyReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionPropertyVisitor
implements CPropertyVisitor<Void> {
    private static final Logger logger = LoggerFactory.getLogger(SubstitutionPropertyVisitor.class);
    private static final String PROP_FORMAT_INFO = "  %-23s: %-70s | %s";
    private static final String PROP_FORMAT_MSG = "  %-23s: %s";
    private static final String PROP_FORMAT_MSG_TYPE = "  %-23s: not substitutable as type %s";
    private final CClassInfo classInfo;
    private final List<SubstitutionProperty> properties = new LinkedList<SubstitutionProperty>();

    boolean hasSubstitutedProperties() {
        return !this.properties.isEmpty();
    }

    List<SubstitutionProperty> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public SubstitutionPropertyVisitor(CClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    private void handleElementChoice(CElementPropertyInfo property, XSParticle particle) {
        logger.info(String.format(PROP_FORMAT_MSG, property.getName(false), "try to collapse multi-typed choice"));
        logger.info(String.format("    %d choice members", property.ref().size()));
        HashMap<CClassInfo, CClassInfo> baseTypes = new HashMap<CClassInfo, CClassInfo>(property.ref().size());
        int m = 1;
        for (CTypeRef typeRef : property.getTypes()) {
            if (typeRef.getTarget() instanceof CClassInfo) {
                CClassInfo targetType = (CClassInfo)typeRef.getTarget();
                logger.info(String.format("      %d -> %s", m++, targetType.fullName()));
                if (baseTypes.containsKey(targetType.getBaseClass())) continue;
                baseTypes.put(targetType.getBaseClass(), targetType);
                continue;
            }
            logger.info(String.format("      %d -> %s", m++, typeRef.getTypeName()));
        }
        if (baseTypes.size() == 1) {
            this.properties.add(new ChoicePropertyElement(this.classInfo, property, (CClassInfo)baseTypes.keySet().stream().findFirst().get(), particle));
        }
    }

    public Void onElement(CElementPropertyInfo property) {
        if (property.ref().size() == 0) {
            logger.info(String.format(PROP_FORMAT_MSG, property.getName(false), "may be wildcard"));
            return null;
        }
        if (property.ref().size() > 1) {
            XSParticle xsp;
            XSComponent xsc = property.getSchemaComponent();
            if (xsc instanceof XSParticle && (xsp = (XSParticle)xsc).getTerm().isModelGroup() && "choice".equals(xsp.getTerm().asModelGroup().getCompositor().toString())) {
                this.handleElementChoice(property, xsp);
            }
            return null;
        }
        CNonElement elementDef = (CNonElement)property.ref().get(0);
        if (elementDef instanceof CClassInfo) {
            CClassInfo targetClassInfo = (CClassInfo)elementDef;
            if (targetClassInfo.isAbstract() && targetClassInfo.hasSubClasses()) {
                this.properties.add(new SubstitutionPropertyElement(this.classInfo, property, (CElement)targetClassInfo));
                logger.info(String.format(PROP_FORMAT_INFO, property.getName(false), targetClassInfo.getType().fullName(), this.toFixedString(targetClassInfo.getTypeName())));
            }
        } else if (elementDef instanceof MaybeElement) {
            MaybeElement e = (MaybeElement)elementDef;
            logger.info(String.format(PROP_FORMAT_MSG_TYPE, property.getName(false), this.toFixedString(e.getTypeName())));
        } else {
            logger.info(String.format(PROP_FORMAT_MSG_TYPE, property.getName(false), ((NType)elementDef.getType()).fullName()));
        }
        return null;
    }

    public Void onReference(CReferencePropertyInfo property) {
        if (property.getElements().size() > 1) {
            logger.warn(String.format(PROP_FORMAT_MSG, property.getName(false), "is not single typed"));
            return null;
        }
        if (property.getElements().size() == 0) {
            if (property.getWildcard() != null) {
                logger.info(String.format(PROP_FORMAT_MSG, property.getName(false), "is wildcard"));
            } else {
                logger.warn(String.format(PROP_FORMAT_MSG, property.getName(false), "is non-typed, please raise a defect for this scenario"));
            }
            return null;
        }
        CElement elementDef = property.getElements().stream().findFirst().orElse(null);
        if (!(elementDef instanceof CElementInfo)) {
            logger.warn(String.format("  %-23s: element ref definition is not CElementInfo but %s", property.getName(false), elementDef.getClass().getSimpleName()));
            return null;
        }
        logger.info(String.format(PROP_FORMAT_INFO, property.getName(false), ((NType)elementDef.getType()).fullName(), elementDef.getElementName()));
        CElementInfo elementInfo = (CElementInfo)elementDef;
        if (elementInfo.getSubstitutionMembers().size() > 0) {
            logger.info(String.format("    %d substitution members", elementInfo.getSubstitutionMembers().size()));
            int m = 1;
            for (CElementInfo sub : elementInfo.getSubstitutionMembers()) {
                logger.info(String.format("      %d -> %s", m++, sub.fullName()));
            }
        }
        if (((NType)elementDef.getType()).fullName().startsWith("javax.xml.bind.JAXBElement")) {
            this.properties.add(new SubstitutionPropertyReference(this.classInfo, property, elementInfo));
        }
        return null;
    }

    private String toFixedString(QName name) {
        if (name == null) {
            return null;
        }
        if ("\u0000".equals(name.getLocalPart())) {
            return new QName(name.getNamespaceURI(), "gregorianCalendar").toString();
        }
        return name.toString();
    }

    public Void onAttribute(CAttributePropertyInfo property) {
        logger.info(String.format(PROP_FORMAT_MSG, property.getName(false), "not substitutable as attribute"));
        return null;
    }

    public Void onValue(CValuePropertyInfo property) {
        logger.info(String.format(PROP_FORMAT_MSG, property.getName(false), "not substitutable as value"));
        return null;
    }
}

