/*
 * Decompiled with CFR 0.152.
 */
package org.boon.logging;

import org.boon.logging.LogLevel;
import org.boon.logging.LoggerDelegate;
import org.boon.primitive.CharBuf;

public class InMemoryLogger
implements LoggerDelegate {
    private LogLevel level = LogLevel.DEBUG;
    private CharBuf buf = CharBuf.create(100);

    @Override
    public boolean infoOn() {
        switch (this.level) {
            case INFO: 
            case ERROR: 
            case FATAL: 
            case WARN: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean debugOn() {
        switch (this.level) {
            case INFO: 
            case ERROR: 
            case FATAL: 
            case WARN: 
            case CONFIG: 
            case DEBUG: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean traceOn() {
        switch (this.level) {
            case INFO: 
            case ERROR: 
            case FATAL: 
            case WARN: 
            case CONFIG: 
            case DEBUG: 
            case TRACE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public LoggerDelegate level(LogLevel level) {
        this.level = level;
        return this;
    }

    @Override
    public LoggerDelegate turnOff() {
        this.level = LogLevel.OFF;
        return this;
    }

    @Override
    public void fatal(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.FATAL.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.FATAL, messages});
        }
    }

    @Override
    public void fatal(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.FATAL.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.FATAL, t, messages});
        }
    }

    @Override
    public void error(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.ERROR.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.ERROR, messages});
        }
    }

    @Override
    public void error(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.ERROR.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.ERROR, t, messages});
        }
    }

    @Override
    public void warn(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.WARN.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.WARN, messages});
        }
    }

    @Override
    public void warn(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.WARN.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.WARN, t, messages});
        }
    }

    @Override
    public void info(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.INFO.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.INFO, messages});
        }
    }

    @Override
    public void info(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.INFO.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.INFO, t, messages});
        }
    }

    @Override
    public void config(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.CONFIG.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.CONFIG, messages});
        }
    }

    @Override
    public void config(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.CONFIG.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.CONFIG, t, messages});
        }
    }

    @Override
    public void debug(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.DEBUG.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.DEBUG, messages});
        }
    }

    @Override
    public void debug(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.DEBUG.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.DEBUG, t, messages});
        }
    }

    @Override
    public void trace(Object ... messages) {
        if (this.level.ordinal() <= LogLevel.TRACE.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.TRACE, messages});
        }
    }

    @Override
    public void trace(Throwable t, Object ... messages) {
        if (this.level.ordinal() <= LogLevel.TRACE.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.TRACE, t, messages});
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.level.ordinal() <= LogLevel.FATAL.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.FATAL, message});
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.level.ordinal() <= LogLevel.FATAL.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.FATAL, t, message});
        }
    }

    @Override
    public void error(Object message) {
        if (this.level.ordinal() <= LogLevel.ERROR.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.ERROR, message});
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.level.ordinal() <= LogLevel.ERROR.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.ERROR, t, message});
        }
    }

    @Override
    public void warn(Object message) {
        if (this.level.ordinal() <= LogLevel.WARN.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.WARN, message});
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.level.ordinal() <= LogLevel.WARN.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.WARN, t, message});
        }
    }

    @Override
    public void info(Object message) {
        if (this.level.ordinal() <= LogLevel.INFO.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.INFO, message});
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.level.ordinal() <= LogLevel.INFO.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.INFO, t, message});
        }
    }

    @Override
    public void debug(Object message) {
        if (this.level.ordinal() <= LogLevel.DEBUG.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.DEBUG, message});
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.level.ordinal() <= LogLevel.DEBUG.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.DEBUG, t, message});
        }
    }

    @Override
    public void trace(Object message) {
        if (this.level.ordinal() <= LogLevel.TRACE.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.TRACE, message});
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.level.ordinal() <= LogLevel.TRACE.ordinal()) {
            this.buf.puts(new Object[]{LogLevel.TRACE, t, message});
        }
    }

    public CharBuf getBuf() {
        return this.buf;
    }
}

