/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.StringScanner;
import org.boon.Universal;
import org.boon.collections.IntList;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.Invoker;
import org.boon.core.reflection.fields.FieldAccess;

public class Int {
    public static int[] grow(int[] array, int size) {
        int[] newArray = new int[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] grow(int[] array) {
        Exceptions.requireNonNull(array);
        int[] newArray = new int[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] shrink(int[] array, int size) {
        int[] newArray = new int[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static int[] compact(int[] array) {
        Exceptions.requireNonNull(array);
        int nullCount = 0;
        for (int ch : array) {
            if (ch != 0) continue;
            ++nullCount;
        }
        int[] newArray = new int[array.length - nullCount];
        int j = 0;
        for (int ch : array) {
            if (ch == 0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static int[] arrayOfInt(int size) {
        return new int[size];
    }

    @Universal
    public static int[] array(int ... array) {
        Exceptions.requireNonNull(array);
        return array;
    }

    @Universal
    public static int lengthOf(int[] array) {
        return Int.len(array);
    }

    @Universal
    public static int len(int[] array) {
        return array.length;
    }

    @Universal
    public static int idx(int[] array, int index) {
        int i = Int.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static int atIndex(int[] array, int index) {
        int i = Int.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(int[] array, int index, int value) {
        int i = Int.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static void atIndex(int[] array, int index, int value) {
        int i = Int.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static int[] slc(int[] array, int startIndex, int endIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int end = Int.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] sliceOf(int[] array, int startIndex, int endIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int end = Int.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] slc(int[] array, int startIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] sliceOf(int[] array, int startIndex) {
        int start = Int.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] slcEnd(int[] array, int endIndex) {
        int end = Int.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static int[] endSliceOf(int[] array, int endIndex) {
        int end = Int.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        int[] newArray = new int[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(int value, int[] array) {
        for (int currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static int[] copy(int[] array) {
        int[] newArray = new int[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static int[] add(int[] array, int v) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static int[] add(int[] array, int[] array2) {
        int[] newArray = new int[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static int[] insert(int[] array, int idx, int v) {
        if (idx >= array.length) {
            return Int.add(array, v);
        }
        int index = Int.calculateIndex(array, idx);
        int[] newArray = new int[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static int[] insert(int[] array, int fromIndex, int[] values) {
        if (fromIndex >= array.length) {
            return Int.add(array, values);
        }
        int index = Int.calculateIndex(array, fromIndex);
        int[] newArray = new int[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(int[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private static int calculateEndIndex(int[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static long reduceBy(int[] array, ReduceBy reduceBy) {
        long sum = 0L;
        for (int v : array) {
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static long reduceBy(int[] array, int start, int length, ReduceBy reduceBy) {
        long sum = 0L;
        for (int index = start; index < length; ++index) {
            int v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static long reduceBy(int[] array, int length, ReduceBy reduceBy) {
        long sum = 0L;
        for (int index = 0; index < length; ++index) {
            int v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static <T> long reduceBy(int[] array, T object) {
        if (object.getClass().isAnonymousClass()) {
            return Int.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Int.reduceByR(array, object);
        }
    }

    public static <T> long reduceBy(int[] array, T object, String methodName) {
        if (object.getClass().isAnonymousClass()) {
            return Int.reduceByR(array, object, methodName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object, methodName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Int.reduceByR(array, object, methodName);
        }
    }

    private static <T> long reduceByR(int[] array, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            long sum = 0L;
            for (int v : array) {
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    private static <T> long reduceByR(int[] array, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            long sum = 0L;
            for (int v : array) {
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    private static <T> long reduceByR(int[] array, int length, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            long sum = 0L;
            for (int index = 0; index < length; ++index) {
                int v = array[index];
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    private static <T> long reduceByR(int[] array, int length, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            long sum = 0L;
            for (int index = 0; index < length; ++index) {
                int v = array[index];
                sum = (Long)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
        }
    }

    public static long reduceBy(int[] array, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Int.reduceByR(array, length, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int index = 0; index < length; ++index) {
                    int v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Int.reduceByR(array, length, object);
        }
    }

    public static long reduceBy(int[] array, int length, Object function, String functionName) {
        if (function.getClass().isAnonymousClass()) {
            return Int.reduceByR(array, length, function, functionName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(function, functionName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int index = 0; index < length; ++index) {
                    int v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Int.reduceByR(array, length, function, functionName);
        }
    }

    public static long reduceBy(int[] array, int start, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Int.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                long sum = 0L;
                for (int index = start; index < length; ++index) {
                    int v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy");
            }
        }
        catch (Exception ex) {
            return Int.reduceByR(array, object);
        }
    }

    public static boolean equalsOrDie(int expected, int got) {
        if (expected != got) {
            return Exceptions.die(Boolean.class, "Expected was", expected, "but we got ", got);
        }
        return true;
    }

    public static boolean equalsOrDie(int[] expected, int[] got) {
        if (expected.length != got.length) {
            Exceptions.die("Lengths did not match, expected length", expected.length, "but got", got.length);
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            Exceptions.die("value at index did not match index", index, "expected value", expected[index], "but got", got[index]);
        }
        return true;
    }

    public static boolean equals(int expected, int got) {
        return expected == got;
    }

    public static boolean equals(int[] expected, int[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static int sum(int[] values) {
        return Int.sum(values, 0, values.length);
    }

    public static int sum(int[] values, int length) {
        return Int.sum(values, 0, length);
    }

    public static int sum(int[] values, int start, int length) {
        long sum = 0L;
        for (int index = start; index < length; ++index) {
            sum += (long)values[index];
        }
        if (sum < Integer.MIN_VALUE) {
            Exceptions.die("overflow the sum is too small", sum);
        }
        if (sum > Integer.MAX_VALUE) {
            Exceptions.die("overflow the sum is too big", sum);
        }
        return (int)sum;
    }

    public static long bigSum(int[] values) {
        return Int.bigSum(values, 0, values.length);
    }

    public static long bigSum(int[] values, int length) {
        return Int.bigSum(values, 0, length);
    }

    public static long bigSum(int[] values, int start, int length) {
        long sum = 0L;
        for (int index = start; index < length; ++index) {
            sum += (long)values[index];
        }
        return sum;
    }

    public static int max(int[] values, int start, int length) {
        int max = Integer.MIN_VALUE;
        for (int index = start; index < length; ++index) {
            if (values[index] <= max) continue;
            max = values[index];
        }
        return max;
    }

    public static int max(int[] values) {
        return Int.max(values, 0, values.length);
    }

    public static int max(int[] values, int length) {
        return Int.max(values, 0, length);
    }

    public static int min(int[] values, int start, int length) {
        int min = Integer.MAX_VALUE;
        for (int index = start; index < length; ++index) {
            if (values[index] >= min) continue;
            min = values[index];
        }
        return min;
    }

    public static int min(int[] values) {
        return Int.min(values, 0, values.length);
    }

    public static int min(int[] values, int length) {
        return Int.min(values, 0, length);
    }

    public static int mean(int[] values, int start, int length) {
        return (int)Math.round(Int.meanDouble(values, start, length));
    }

    public static int mean(int[] values, int length) {
        return (int)Math.round(Int.meanDouble(values, 0, length));
    }

    public static int mean(int[] values) {
        return (int)Math.round(Int.meanDouble(values, 0, values.length));
    }

    public static int variance(int[] values, int start, int length) {
        return (int)Math.round(Int.varianceDouble(values, start, length));
    }

    private static double meanDouble(int[] values, int start, int length) {
        double mean = (double)Int.bigSum(values, start, length) / (double)length;
        return mean;
    }

    public static double varianceDouble(int[] values, int start, int length) {
        double mean = Int.meanDouble(values, start, length);
        double temp = 0.0;
        for (int index = start; index < length; ++index) {
            double a = values[index];
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)length;
    }

    public static int variance(int[] values, int length) {
        return (int)Math.round(Int.varianceDouble(values, 0, length));
    }

    public static int variance(int[] values) {
        return (int)Math.round(Int.varianceDouble(values, 0, values.length));
    }

    public static int standardDeviation(int[] values, int start, int length) {
        double variance = Int.varianceDouble(values, start, length);
        return (int)Math.round(Math.sqrt(variance));
    }

    public static int standardDeviation(int[] values, int length) {
        double variance = Int.varianceDouble(values, 0, length);
        return (int)Math.round(Math.sqrt(variance));
    }

    public static int standardDeviation(int[] values) {
        double variance = Int.varianceDouble(values, 0, values.length);
        return (int)Math.round(Math.sqrt(variance));
    }

    public static int median(int[] values, int start, int length) {
        int[] sorted = new int[length];
        System.arraycopy(values, start, sorted, 0, length);
        Arrays.sort(sorted);
        if (length % 2 == 0) {
            int middle = sorted.length / 2;
            double median = (double)(sorted[middle - 1] + sorted[middle]) / 2.0;
            return (int)Math.round(median);
        }
        return sorted[sorted.length / 2];
    }

    public static int median(int[] values, int length) {
        return Int.median(values, 0, length);
    }

    public static int median(int[] values) {
        return Int.median(values, 0, values.length);
    }

    public static boolean equals(int start, int end, int[] expected, int[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = start; index < end; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int element : array) {
            result = 31 * result + element;
        }
        return result;
    }

    public static int hashCode(int start, int end, int[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = start; index < end; ++index) {
            result = 31 * result + array[index];
        }
        return result;
    }

    public static long sum(Collection<?> inputList, String propertyPath) {
        if (inputList.size() == 0) {
            return 0L;
        }
        long sum = 0L;
        if (propertyPath.contains(".") || propertyPath.contains("[")) {
            String[] properties = StringScanner.splitByDelimiters(propertyPath, ".[]");
            for (Object o : inputList) {
                sum += (long)BeanUtils.getPropertyInt(o, properties);
            }
        } else {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(inputList.iterator().next());
            FieldAccess fieldAccess = fields.get(propertyPath);
            for (Object o : inputList) {
                sum += (long)fieldAccess.getInt(o);
            }
        }
        return sum;
    }

    private static double mean(Collection<?> inputList, String propertyPath) {
        double mean = Int.sum(inputList, propertyPath) / (long)inputList.size();
        return Math.round(mean);
    }

    public static double variance(Collection<?> inputList, String propertyPath) {
        double mean = Int.mean(inputList, propertyPath);
        double temp = 0.0;
        if (propertyPath.contains(".") || propertyPath.contains("[")) {
            String[] properties = StringScanner.splitByDelimiters(propertyPath, ".[]");
            for (Object o : inputList) {
                double a = BeanUtils.getPropertyInt(o, properties);
                temp += (mean - a) * (mean - a);
            }
        } else {
            Map<String, FieldAccess> fields = BeanUtils.getFieldsFromObject(inputList.iterator().next());
            FieldAccess fieldAccess = fields.get(propertyPath);
            for (Object o : inputList) {
                double a = fieldAccess.getInt(o);
                temp += (mean - a) * (mean - a);
            }
        }
        return Math.round(temp / (double)inputList.size());
    }

    public static double standardDeviation(Collection<?> inputList, String propertyPath) {
        double variance = Int.variance(inputList, propertyPath);
        return Math.round(Math.sqrt(variance));
    }

    public static int median(Collection<?> inputList, String propertyPath) {
        return IntList.toIntList(inputList, propertyPath).median();
    }

    public static int roundUpToPowerOf2(int number) {
        int rounded;
        rounded = number >= 1000 ? 1000 : ((rounded = Integer.highestOneBit(number)) != 0 ? (Integer.bitCount(number) > 1 ? rounded << 1 : rounded) : 1);
        return rounded;
    }

    public static interface ReduceBy {
        public long reduce(long var1, int var3);
    }
}

