/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.boon.Boon;
import org.boon.IO;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.collections.LazyMap;
import org.boon.core.Conversions;
import org.boon.core.reflection.BeanUtils;
import org.boon.expression.BoonExpressionContext;
import org.boon.expression.ExpressionContext;
import org.boon.primitive.CharBuf;
import org.boon.template.BoonCommandArgumentParser;
import org.boon.template.BoonCoreTemplateParser;
import org.boon.template.BoonModernTemplateParser;
import org.boon.template.Template;
import org.boon.template.TemplateParser;
import org.boon.template.support.LoopTagStatus;
import org.boon.template.support.Token;
import org.boon.template.support.TokenTypes;

public class BoonTemplate
implements Template {
    private CharBuf _buf = CharBuf.create(16);
    private BoonTemplate parentTemplate;
    private TemplateParser parser;
    private String template;
    private final ExpressionContext _context;
    private BoonCommandArgumentParser commandArgumentParser = new BoonCommandArgumentParser();

    private void output(Object object) {
        this._buf.add(object);
    }

    private void output(Token token) {
        this._buf.add(this.template, token.start(), token.stop());
    }

    public BoonTemplate() {
        this.parser = new BoonCoreTemplateParser();
        this._context = new BoonExpressionContext(new Object[0]);
    }

    public BoonTemplate(TemplateParser templateParser) {
        this.parser = templateParser;
        this._context = new BoonExpressionContext(new Object[0]);
    }

    public BoonTemplate(ExpressionContext context, TemplateParser templateParser) {
        this.parser = templateParser;
        this._context = context;
    }

    @Override
    public String replace(String template, Object ... context) {
        this.initContext(context);
        this.template = template;
        this.parser.parse(template);
        this._buf.readForRecycle();
        Iterator<Token> tokens = this.parser.getTokenList().iterator();
        while (tokens.hasNext()) {
            Token token = tokens.next();
            this.processToken(tokens, token);
        }
        return this._buf.toString();
    }

    private String include(String template) {
        this.template = template;
        this.parser.parse(template);
        this._buf.readForRecycle();
        Iterator<Token> tokens = this.parser.getTokenList().iterator();
        while (tokens.hasNext()) {
            Token token = tokens.next();
            this.processToken(tokens, token);
        }
        return this._buf.toString();
    }

    @Override
    public String replaceFromResource(String resource, Object ... context) {
        String template = Boon.resource(resource);
        return this.replace(template, context);
    }

    @Override
    public String replaceFromFile(String resource, Object ... context) {
        String template = IO.read(resource);
        return this.replace(template, context);
    }

    @Override
    public String replaceFromURI(String resource, Object ... context) {
        String template = IO.readResource(resource);
        return this.replace(template, context);
    }

    public String inlcudeFromURI(String resource) {
        String template = IO.readResource(resource);
        return this.include(template);
    }

    private String textFromToken(Token token) {
        return this.template.substring(token.start(), token.stop());
    }

    protected void initContext(Object ... root) {
        this._context.initContext(root);
    }

    private Token handleCommand(String template, Token commandToken, Iterator<Token> tokens) {
        this.template = template;
        String commandText = this.textFromToken(commandToken);
        int index = StringScanner.findWhiteSpace(commandText);
        String command = Str.endSliceOf(commandText, index);
        String args = Str.sliceOf(commandText, index);
        Map<String, Object> params = this.commandArgumentParser.parseArguments(args);
        Token bodyToken = tokens.next();
        int bodyTokenStop = bodyToken.type() == TokenTypes.COMMAND_BODY ? bodyToken.stop() : -1;
        ArrayList<Token> commandTokens = new ArrayList<Token>();
        if (bodyToken.start() != bodyToken.stop()) {
            while (tokens.hasNext()) {
                Token next = tokens.next();
                commandTokens.add(next);
                if (next.stop() != bodyTokenStop) continue;
                break;
            }
        }
        this.dispatchCommand(command, params, commandTokens);
        return null;
    }

    private void dispatchCommand(String command, Map<String, Object> params, List<Token> commandTokens) {
        switch (command) {
            case "if": {
                this.handleIf(params, commandTokens, true);
                break;
            }
            case "unless": {
                this.handleIf(params, commandTokens, false);
                break;
            }
            case "set": 
            case "let": 
            case "var": 
            case "define": 
            case "def": 
            case "assign": {
                this.handleSet(params, commandTokens);
                break;
            }
            case "insert": 
            case "include": 
            case "import": 
            case "template": {
                this.handleInclude(params, commandTokens);
            }
            case "list": 
            case "for": 
            case "forEach": 
            case "foreach": 
            case "loop": 
            case "each": {
                this.handleLoop(params, commandTokens);
            }
        }
    }

    private void processCommandBodyTokens(List<Token> commandTokens) {
        Iterator<Token> commandTokenIterators = commandTokens.iterator();
        while (commandTokenIterators.hasNext()) {
            Token token = commandTokenIterators.next();
            this.processToken(commandTokenIterators, token);
        }
    }

    private void processToken(Iterator<Token> tokens, Token token) {
        switch (token.type()) {
            case TEXT: {
                this.output(token);
                break;
            }
            case EXPRESSION: {
                String path = this.textFromToken(token);
                this.output(this._context.lookup(path));
                break;
            }
            case COMMAND: {
                this.handleCommand(this.template, token, tokens);
            }
        }
    }

    private String getStringParam(String param, Map<String, Object> params, String defaultValue) {
        String value = Str.toString(params.get(param));
        if (Str.isEmpty(value)) {
            return defaultValue;
        }
        if (value.startsWith("$")) {
            return Conversions.toString(this._context.lookupWithDefault(value, defaultValue));
        }
        return value;
    }

    private int getIntParam(String param, Map<String, Object> params, int defaultValue) {
        Object value = params.get(param);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof CharSequence && value.toString().startsWith("$")) {
            return Conversions.toInt(this._context.lookupWithDefault(value.toString(), defaultValue));
        }
        return Conversions.toInt(value);
    }

    public void displayTokens() {
        for (Token token : this.parser.getTokenList()) {
            Boon.puts("token", token, this.textFromToken(token));
        }
    }

    private void handleLoop(Map<String, Object> params, List<Token> commandTokens) {
        String itemsName = Str.toString(params.get("items"));
        Object object = null;
        if (!Boon.isEmpty(itemsName)) {
            object = this._context.lookup(itemsName);
        }
        if (Boon.isEmpty(object)) {
            object = params.get("varargs");
        }
        if (Boon.isStringArray(object)) {
            String[] array = (String[])object;
            ArrayList holder = new ArrayList();
            for (int index = 0; index < array.length; ++index) {
                if (Str.isEmpty(array[index])) continue;
                object = this._context.lookup(array[index]);
                holder.addAll(Conversions.toCollection(object));
            }
            object = holder;
        }
        Collection items = Conversions.toCollection(object);
        String var = this.getStringParam("var", params, "item");
        String varStatus = this.getStringParam("varStatus", params, "status");
        int begin = this.getIntParam("begin", params, -1);
        int end = this.getIntParam("end", params, -1);
        int step = this.getIntParam("step", params, -1);
        LoopTagStatus status = new LoopTagStatus();
        status.setCount(items.size());
        if (end != -1) {
            status.setEnd(end);
        } else {
            end = items.size();
        }
        if (begin != -1) {
            status.setBegin(begin);
        } else {
            begin = 0;
        }
        if (step != -1) {
            status.setStep(step);
        } else {
            step = 1;
        }
        LazyMap values = new LazyMap();
        int index = 0;
        this._context.pushContext(values);
        for (Object item : items) {
            if (index >= begin && index < end && index % step == 0) {
                values.put(var, item);
                values.put(varStatus, status);
                status.setIndex(index);
                values.put("@first", status.isFirst());
                values.put("@last", status.isLast());
                values.put("index", index);
                values.put("@index", index);
                if (item instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)item;
                    values.put("@key", entry.getKey());
                    values.put("@value", entry.getValue());
                    values.put("this", entry.getValue());
                } else {
                    values.put("this", item);
                }
                this.processCommandBodyTokens(commandTokens);
            }
            ++index;
        }
        this._context.removeLastContext();
    }

    private void handleSet(Map<String, Object> params, List<Token> commandTokens) {
        String var = this.getStringParam("var", params, "");
        String propertyPath = this.getStringParam("property", params, "");
        String valueExpression = Str.toString(params.get("value"));
        String targetExpression = Str.toString(params.get("target"));
        Object value = this._context.lookup(valueExpression);
        Object bean = this._context.lookup(targetExpression);
        if (!Str.isEmpty(propertyPath) && bean != null) {
            BeanUtils.idx(bean, propertyPath, value);
        }
        if (!Str.isEmpty(var)) {
            this._context.put(var, value);
        }
    }

    private void handleInclude(Map<String, Object> params, List<Token> commandTokens) {
        TemplateParser includeParser;
        LazyMap newContext = new LazyMap(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            newContext.put(entry.getKey(), this._context.lookupWithDefault(entry.getValue().toString(), entry.getValue()));
        }
        Object otype = params.get("type");
        String type = !Boon.isEmpty(otype) ? otype.toString() : "";
        switch (type) {
            case "": {
                try {
                    includeParser = (TemplateParser)this.parser.getClass().newInstance();
                }
                catch (Exception e) {
                    includeParser = new BoonCoreTemplateParser();
                }
                break;
            }
            case "boon": 
            case "jsp": 
            case "jstl": {
                includeParser = new BoonCoreTemplateParser();
                break;
            }
            case "modern": 
            case "mustache": 
            case "handlebar": 
            case "handlebars": {
                includeParser = new BoonModernTemplateParser();
                break;
            }
            default: {
                includeParser = new BoonCoreTemplateParser();
            }
        }
        BoonTemplate template = new BoonTemplate(this._context, includeParser);
        template.parentTemplate = this;
        this._context.pushContext(newContext);
        String resource = (String)params.get("resource");
        if (resource.contains(":")) {
            this.output(template.inlcudeFromURI(resource));
        } else {
            this.output(template.includeFromResource(resource));
        }
        this._context.removeLastContext();
    }

    private String includeFromResource(String resource) {
        String template = Boon.resource(resource);
        return this.include(template);
    }

    private void handleIf(Map<String, Object> params, List<Token> commandTokens, boolean normal) {
        boolean display = false;
        String var = this.getStringParam("var", params, "__none");
        if (params.containsKey("test")) {
            String test = Str.toString(params.get("test"));
            if (!Str.isEmpty(test)) {
                if ("true".equals(test)) {
                    display = true;
                } else {
                    Object o = this._context.lookupWithDefault(test, "");
                    display = Conversions.toBoolean(o);
                }
            }
        } else {
            Object varargsObject = params.get("varargs");
            if (Boon.isStringArray(varargsObject)) {
                String[] array = (String[])varargsObject;
                if (array.length > 0) {
                    display = true;
                }
                for (int index = 0; index < array.length; ++index) {
                    Object o;
                    if (Str.isEmpty(array[index]) || Conversions.toBoolean(o = this._context.lookup(array[index]))) continue;
                    display = false;
                    break;
                }
            } else if (varargsObject instanceof Collection) {
                Collection varargs = (Collection)varargsObject;
                if (varargs.size() > 0) {
                    display = true;
                }
                for (Object arg : varargs) {
                    Object value = this._context.lookup(arg.toString());
                    if (Conversions.toBoolean(value)) continue;
                    display = false;
                    break;
                }
            }
        }
        boolean bl = display = display && normal;
        if (!var.equals("__none")) {
            this._context.put(var, display);
        }
        if (display) {
            this.processCommandBodyTokens(commandTokens);
        }
    }

    public static Template template() {
        return new BoonTemplate(new BoonModernTemplateParser());
    }

    public static Template jstl() {
        return new BoonTemplate(new BoonCoreTemplateParser());
    }

    @Override
    public void addFunctions(Class<?> functions) {
        this._context.addFunctions(functions);
    }

    @Override
    public void addFunctions(String prefix, Class<?> functions) {
        this._context.addFunctions(prefix, functions);
    }
}

