/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import graphql.language.AstPrinter;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import io.fria.lilo.GraphQLQuery;
import io.fria.lilo.GraphQLRequest;
import io.fria.lilo.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class QueryTransformer {
    private QueryTransformer() {
    }

    @NotNull
    static GraphQLQuery extractQuery(@NotNull DataFetchingEnvironment environment) {
        GraphQLQuery.GraphQLQueryBuilder queryBuilder = GraphQLQuery.builder();
        QueryTransformer.transformDocument(environment, queryBuilder);
        return queryBuilder.build();
    }

    private static void findUsedItems(@NotNull Node<?> node, @NotNull Set<String> usedReferenceNames, @NotNull Set<String> usedFragmentNames) {
        if (node instanceof FragmentSpread) {
            usedFragmentNames.add(((FragmentSpread)node).getName());
            QueryTransformer.findUsedItemsInChildren(node, usedReferenceNames, usedFragmentNames);
        } else if (node instanceof VariableReference) {
            usedReferenceNames.add(((VariableReference)node).getName());
        } else {
            QueryTransformer.findUsedItemsInChildren(node, usedReferenceNames, usedFragmentNames);
        }
    }

    private static void findUsedItemsInChildren(@NotNull Node<?> node, @NotNull Set<String> usedReferenceNames, @NotNull Set<String> usedFragmentNames) {
        node.getChildren().forEach(n -> QueryTransformer.findUsedItems(n, usedReferenceNames, usedFragmentNames));
    }

    @NotNull
    private static FragmentDefinition removeAlias(@NotNull FragmentDefinition fragment) {
        SelectionSet selectionSet = fragment.getSelectionSet();
        if (selectionSet == null) {
            return fragment;
        }
        List newSelections = selectionSet.getSelections().stream().map(s -> {
            if (s instanceof Field) {
                return QueryTransformer.removeAlias((Field)s);
            }
            return s;
        }).collect(Collectors.toList());
        return fragment.transform(builder -> builder.selectionSet(SelectionSet.newSelectionSet((Collection)newSelections).build()).build());
    }

    @NotNull
    private static Field removeAlias(@NotNull Field field) {
        List<Selection> newSelections = QueryTransformer.removeAliasInChildren(field);
        return field.transform(builder -> {
            if (newSelections != null) {
                builder.alias(null).selectionSet(SelectionSet.newSelectionSet((Collection)newSelections).build()).build();
            } else {
                builder.alias(null).build();
            }
        });
    }

    @Nullable
    private static List<Selection> removeAliasInChildren(@NotNull Field field) {
        SelectionSet selectionSet = field.getSelectionSet();
        List newSelections = null;
        if (selectionSet != null) {
            newSelections = selectionSet.getSelections().stream().map(s -> {
                if (s instanceof Field) {
                    return QueryTransformer.removeAlias((Field)s);
                }
                return s;
            }).collect(Collectors.toList());
        }
        return newSelections;
    }

    @NotNull
    private static List<Definition> transformDefinitions(@NotNull DataFetchingEnvironment environment, @NotNull List<Definition> originalDefinitions, @NotNull GraphQLRequest.GraphQLRequestBuilder requestBuilder, @NotNull GraphQLQuery.GraphQLQueryBuilder queryBuilder) {
        Optional<Definition> operationDefinitionOptional = originalDefinitions.stream().filter(d -> d instanceof OperationDefinition).findFirst();
        if (operationDefinitionOptional.isEmpty()) {
            throw new IllegalArgumentException("GraphQL query should contain either query or mutation");
        }
        OperationDefinition operationDefinition = (OperationDefinition)operationDefinitionOptional.get();
        queryBuilder.operationType(operationDefinition.getOperation());
        requestBuilder.operationName(operationDefinition.getName());
        Field queryNode = environment.getField();
        HashSet<String> usedReferenceNames = new HashSet<String>();
        HashSet<String> usedFragmentNames = new HashSet<String>();
        QueryTransformer.findUsedItems(queryNode, usedReferenceNames, usedFragmentNames);
        List<FragmentDefinition> usedRootFragmentDefinitions = originalDefinitions.stream().filter(d -> d instanceof FragmentDefinition).map(d -> (FragmentDefinition)d).filter(fd -> usedFragmentNames.contains(fd.getName())).collect(Collectors.toList());
        usedRootFragmentDefinitions.forEach(fd -> QueryTransformer.findUsedItemsInChildren(fd, usedReferenceNames, usedFragmentNames));
        ArrayList<Definition> newDefinitions = new ArrayList<Definition>();
        newDefinitions.add(QueryTransformer.transformOperationDefinition(operationDefinition, usedReferenceNames, queryNode, queryBuilder));
        newDefinitions.addAll(QueryTransformer.transformFragmentDefinitions(originalDefinitions, usedFragmentNames));
        HashMap<String, Object> filteredVariables = new HashMap<String, Object>();
        environment.getVariables().entrySet().stream().filter(e -> usedReferenceNames.contains(e.getKey())).forEach(e -> filteredVariables.put((String)e.getKey(), e.getValue()));
        requestBuilder.variables(filteredVariables);
        queryBuilder.variables(filteredVariables);
        return newDefinitions;
    }

    @NotNull
    private static Document transformDocument(@NotNull DataFetchingEnvironment environment, @NotNull GraphQLQuery.GraphQLQueryBuilder queryBuilder) {
        Document originalDocument = environment.getDocument();
        List definitions = originalDocument.getDefinitions();
        if (definitions.isEmpty()) {
            throw new IllegalArgumentException("query is not in appropriate format");
        }
        GraphQLRequest.GraphQLRequestBuilder requestBuilder = GraphQLRequest.builder();
        List<Definition> newDefinitions = QueryTransformer.transformDefinitions(environment, definitions, requestBuilder, queryBuilder);
        Document newDocument = originalDocument.transform(builder -> builder.definitions(newDefinitions));
        String queryText = AstPrinter.printAst((Node)newDocument);
        String request = JsonUtils.toStr(requestBuilder.query(queryText).build());
        queryBuilder.query(request).arguments(environment.getArguments());
        return newDocument;
    }

    @NotNull
    private static List<Definition<?>> transformFragmentDefinitions(@NotNull List<Definition> originalDefinitions, @NotNull Set<String> usedFragmentNames) {
        return originalDefinitions.stream().filter(d -> d instanceof FragmentDefinition).map(d -> (FragmentDefinition)d).filter(fd -> usedFragmentNames.contains(fd.getName())).map(QueryTransformer::removeAlias).collect(Collectors.toList());
    }

    @NotNull
    private static Definition<?> transformOperationDefinition(@NotNull OperationDefinition operationDefinition, @NotNull Set<String> usedReferenceNames, @NotNull Field queryNode, @NotNull GraphQLQuery.GraphQLQueryBuilder queryBuilder) {
        List newVariables = operationDefinition.getVariableDefinitions().stream().filter(v -> usedReferenceNames.contains(v.getName())).collect(Collectors.toList());
        Field newQueryNode = QueryTransformer.removeAlias(queryNode);
        queryBuilder.queryNode(newQueryNode);
        return operationDefinition.transform(builder -> builder.selectionSet(new SelectionSet(List.of(newQueryNode))).variableDefinitions(newVariables));
    }
}

