/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileReader;
import io.gatling.commons.stats.GeneralStatsSource;
import io.gatling.commons.stats.assertion.AssertionResult;
import io.gatling.commons.stats.assertion.AssertionValidator$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4QAC\u0006\u0001\u0017EA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\u0006E\u0001!\ta\t\u0005\b;\u0001\u0011\r\u0011b\u0003(\u0011\u0019A\u0003\u0001)A\u00055!)\u0011\u0006\u0001C\u0001U!)a\u0007\u0001C\u0005o!)A\t\u0001C\u0005\u000b\")\u0011\n\u0001C\u0005\u0015\")1\f\u0001C\u00059\n\u0011\"+\u001e8SKN,H\u000e\u001e)s_\u000e,7o]8s\u0015\taQ\"A\u0002baBT!AD\b\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0001#\u0001\u0002j_N\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0007\u0001\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\r\r|gNZ5h\u0015\tyR\"\u0001\u0003d_J,\u0017BA\u0011\u001d\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"A\u0006\t\u000ba\u0011\u0001\u0019\u0001\u000e\u0016\u0003i\tqaY8oM&<\u0007%\u0001\tqe>\u001cWm]:Sk:\u0014Vm];miR\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]-\t1a\u00197j\u0013\t\u0001TF\u0001\u0006Ti\u0006$Xo]\"pI\u0016DQAM\u0003A\u0002M\n\u0011B];o%\u0016\u001cX\u000f\u001c;\u0011\u0005\u0015\"\u0014BA\u001b\f\u0005%\u0011VO\u001c*fgVdG/A\tj]&$Hj\\4GS2,'+Z1eKJ$\"\u0001O\"\u0011\u0007MI4(\u0003\u0002;)\t1q\n\u001d;j_:\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bM$\u0018\r^:\u000b\u0005\u0001k\u0011AB2iCJ$8/\u0003\u0002C{\tiAj\\4GS2,'+Z1eKJDQA\r\u0004A\u0002M\n\u0001D]3q_J$8oR3oKJ\fG/[8o\u000b:\f'\r\\3e+\u00051\u0005CA\nH\u0013\tAECA\u0004C_>dW-\u00198\u0002\u001f\u001d,g.\u001a:bi\u0016\u0014V\r]8siN$2a\u0013(W!\t\u0019B*\u0003\u0002N)\t!QK\\5u\u0011\u0015y\u0005\u00021\u0001Q\u0003]\u0011X\r]8siN<UM\\3sCRLwN\\%oaV$8\u000f\u0005\u0002R)6\t!K\u0003\u0002T\u007f\u00051!/\u001a9peRL!!\u0016*\u0003/I+\u0007o\u001c:ug\u001e+g.\u001a:bi&|g.\u00138qkR\u001c\b\"B,\t\u0001\u0004A\u0016!B:uCJ$\bCA\nZ\u0013\tQFC\u0001\u0003M_:<\u0017!\u0003:v]N#\u0018\r^;t)\tYS\fC\u0003_\u0013\u0001\u0007q,\u0001\tbgN,'\u000f^5p]J+7/\u001e7ugB\u0019\u0001\r[6\u000f\u0005\u00054gB\u00012f\u001b\u0005\u0019'B\u00013\u001a\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002h)\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005\u0011a\u0015n\u001d;\u000b\u0005\u001d$\u0002C\u00017s\u001b\u0005i'B\u00018p\u0003%\t7o]3si&|gN\u0003\u0002?a*\u0011\u0011/D\u0001\bG>lWn\u001c8t\u0013\t\u0019XNA\bBgN,'\u000f^5p]J+7/\u001e7u\u0001")
public class RunResultProcessor {
    private final GatlingConfiguration configuration;
    private final GatlingConfiguration config;

    private GatlingConfiguration config() {
        return this.config;
    }

    public StatusCode processRunResult(RunResult runResult) {
        StatusCode statusCode;
        long start = System.currentTimeMillis();
        Option<LogFileReader> option = this.initLogFileReader(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileReader reader = (LogFileReader)some.value();
            List assertionResults = AssertionValidator$.MODULE$.validateAssertions((GeneralStatsSource)reader);
            if (this.reportsGenerationEnabled()) {
                ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runResult.runId(), reader, assertionResults);
                this.generateReports(reportsGenerationInputs, start);
            }
            statusCode = this.runStatus((List<AssertionResult>)assertionResults);
        } else {
            statusCode = StatusCode$Success$.MODULE$;
        }
        return statusCode;
    }

    private Option<LogFileReader> initLogFileReader(RunResult runResult) {
        return this.reportsGenerationEnabled() || runResult.hasAssertions() ? new Some((Object)new LogFileReader(runResult.runId(), this.config())) : None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.charting().noReports();
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs, long start) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        Path indexFile = new ReportsGenerator(this.config()).generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Reports generated in ").append((System.currentTimeMillis() - start) / 1000L).append("s.").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Please open the following file: ").append(indexFile.toFile()).toString());
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        return consolidatedAssertionResult ? StatusCode$Success$.MODULE$ : StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(assertionResult.message()).append(" : ").append(assertionResult.result()).toString());
        return isValid && assertionResult.result();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
        this.config = configuration;
    }
}

