/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.jodd;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class FixedLazyMap
extends AbstractMap {
    private LinkedHashMap map;
    private int size;
    private Object[] keys = new Object[5];
    private Object[] values = new Object[5];

    @Override
    public Object put(Object object, Object object2) {
        if (this.map == null) {
            this.keys[this.size] = object;
            this.values[this.size] = object2;
            ++this.size;
            if (this.size == this.keys.length) {
                this.keys = FixedLazyMap.grow(this.keys);
                this.values = FixedLazyMap.grow(this.values);
            }
            return null;
        }
        return this.map.put(object, object2);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.buildIfNeeded();
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map == null ? this.size : this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map == null ? this.size == 0 : this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        if (this.map == null && this.size < 5) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.values[i].equals(object)) continue;
                return true;
            }
            return false;
        }
        this.buildIfNeeded();
        return this.map.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.map == null && this.size < 5) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.keys[i].equals(object)) continue;
                return true;
            }
            return false;
        }
        this.buildIfNeeded();
        return this.map.containsKey(object);
    }

    @Override
    public Object get(Object object) {
        this.buildIfNeeded();
        return this.map.get(object);
    }

    private void buildIfNeeded() {
        if (this.map == null) {
            this.map = new LinkedHashMap(this.size, 0.01f);
            for (int i = 0; i < this.size; ++i) {
                Object object = this.values[i];
                if (object instanceof Supplier) {
                    object = ((Supplier)object).get();
                }
                this.map.put(this.keys[i], object);
            }
            this.keys = null;
            this.values = null;
        }
    }

    @Override
    public Object remove(Object object) {
        this.buildIfNeeded();
        return this.map.remove(object);
    }

    @Override
    public void putAll(Map map) {
        this.buildIfNeeded();
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.size = 0;
        } else {
            this.map.clear();
        }
    }

    @Override
    public Set keySet() {
        return this.map == null ? FixedLazyMap.set(this.size, this.keys) : this.map.keySet();
    }

    @Override
    public Collection values() {
        return this.map == null ? Arrays.asList(this.values) : this.map.values();
    }

    @Override
    public boolean equals(Object object) {
        this.buildIfNeeded();
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        this.buildIfNeeded();
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        this.buildIfNeeded();
        return this.map.toString();
    }

    @Override
    protected Object clone() {
        return this.map == null ? null : this.map.clone();
    }

    private static <V> Set<V> set(int n, V ... VArray) {
        int n2 = 0;
        HashSet<V> hashSet = new HashSet<V>();
        for (V v : VArray) {
            hashSet.add(v);
            if (++n2 == n) break;
        }
        return hashSet;
    }

    private static <V> V[] grow(V[] VArray) {
        Object object = Array.newInstance(VArray.getClass().getComponentType(), VArray.length * 2);
        System.arraycopy(VArray, 0, object, 0, VArray.length);
        return (Object[])object;
    }

    private static <V> List<V> list(V ... VArray) {
        int n = VArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(Array.get(VArray, i));
        }
        return arrayList;
    }
}

