/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.gatling.commons.util.Hex$;
import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.netty.util.StringBuilderPool;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Json$ {
    public static Json$ MODULE$;
    private final StringBuilderPool stringBuilders;

    static {
        new Json$();
    }

    private StringBuilderPool stringBuilders() {
        return this.stringBuilders;
    }

    public String stringifyNode(JsonNode node, boolean isRootObject) {
        StringBuilder sb = this.stringBuilders().get();
        return Json$.appendStringified$1(node, isRootObject, sb).toString();
    }

    public String stringify(Object value, boolean isRootObject) {
        StringBuilder sb = this.stringBuilders().get();
        return Json$.appendStringified$2(value, isRootObject, sb).toString();
    }

    public Object asScala(JsonNode node2) {
        Object object;
        JsonNodeType jsonNodeType = node2.getNodeType();
        if (JsonNodeType.ARRAY.equals(jsonNodeType)) {
            Nil$ nil$;
            int n = node2.size();
            switch (n) {
                case 0: {
                    nil$ = Nil$.MODULE$;
                    break;
                }
                case 1: {
                    nil$ = Predef$.MODULE$.genericArrayOps(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asScala(node2.get(0))}), ClassTag$.MODULE$.Any())).toSeq();
                    break;
                }
                case 2: {
                    nil$ = Predef$.MODULE$.genericArrayOps(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asScala(node2.get(0)), this.asScala(node2.get(1))}), ClassTag$.MODULE$.Any())).toSeq();
                    break;
                }
                case 3: {
                    nil$ = Predef$.MODULE$.genericArrayOps(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asScala(node2.get(0)), this.asScala(node2.get(1)), this.asScala(node2.get(2))}), ClassTag$.MODULE$.Any())).toSeq();
                    break;
                }
                case 4: {
                    nil$ = Predef$.MODULE$.genericArrayOps(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.asScala(node2.get(0)), this.asScala(node2.get(1)), this.asScala(node2.get(2)), this.asScala(node2.get(3))}), ClassTag$.MODULE$.Any())).toSeq();
                    break;
                }
                default: {
                    nil$ = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node2.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> MODULE$.asScala((JsonNode)node)).toVector();
                    break;
                }
            }
            object = nil$;
        } else if (JsonNodeType.OBJECT.equals(jsonNodeType)) {
            scala.collection.immutable.Map map;
            int n = node2.size();
            switch (n) {
                case 0: {
                    map = Predef$.MODULE$.Map().empty();
                    break;
                }
                case 1: {
                    Map.Entry entry0 = (Map.Entry)node2.fields().next();
                    map = new Map.Map1(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()));
                    break;
                }
                case 2: {
                    java.util.Iterator it = node2.fields();
                    Map.Entry entry0 = (Map.Entry)it.next();
                    Map.Entry entry1 = (Map.Entry)it.next();
                    map = new Map.Map2(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()), entry1.getKey(), this.asScala((JsonNode)entry1.getValue()));
                    break;
                }
                case 3: {
                    java.util.Iterator it = node2.fields();
                    Map.Entry entry0 = (Map.Entry)it.next();
                    Map.Entry entry1 = (Map.Entry)it.next();
                    Map.Entry entry2 = (Map.Entry)it.next();
                    map = new Map.Map3(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()), entry1.getKey(), this.asScala((JsonNode)entry1.getValue()), entry2.getKey(), this.asScala((JsonNode)entry2.getValue()));
                    break;
                }
                case 4: {
                    java.util.Iterator it = node2.fields();
                    Map.Entry entry0 = (Map.Entry)it.next();
                    Map.Entry entry1 = (Map.Entry)it.next();
                    Map.Entry entry2 = (Map.Entry)it.next();
                    Map.Entry entry3 = (Map.Entry)it.next();
                    map = new Map.Map4(entry0.getKey(), this.asScala((JsonNode)entry0.getValue()), entry1.getKey(), this.asScala((JsonNode)entry1.getValue()), entry2.getKey(), this.asScala((JsonNode)entry2.getValue()), entry3.getKey(), this.asScala((JsonNode)entry3.getValue()));
                    break;
                }
                default: {
                    map = Maps.PimpedMap$.MODULE$.forceMapValues$extension(Maps$.MODULE$.PimpedMap(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node2.fields()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), e.getValue())).toMap(Predef$.MODULE$.$conforms())), (Function1 & Serializable & scala.Serializable)node -> MODULE$.asScala((JsonNode)node));
                    break;
                }
            }
            object = map;
        } else if (JsonNodeType.STRING.equals(jsonNodeType)) {
            object = node2.textValue();
        } else if (JsonNodeType.BOOLEAN.equals(jsonNodeType)) {
            object = BoxesRunTime.boxToBoolean((boolean)node2.booleanValue());
        } else if (JsonNodeType.NULL.equals(jsonNodeType)) {
            object = null;
        } else if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            Number number;
            JsonParser.NumberType numberType = node2.numberType();
            if (JsonParser.NumberType.INT.equals(numberType)) {
                number = BoxesRunTime.boxToInteger((int)node2.intValue());
            } else if (JsonParser.NumberType.LONG.equals(numberType)) {
                number = BoxesRunTime.boxToLong((long)node2.longValue());
            } else if (JsonParser.NumberType.FLOAT.equals(numberType)) {
                number = BoxesRunTime.boxToFloat((float)node2.floatValue());
            } else if (JsonParser.NumberType.DOUBLE.equals(numberType)) {
                number = BoxesRunTime.boxToDouble((double)node2.doubleValue());
            } else if (JsonParser.NumberType.BIG_INTEGER.equals(numberType)) {
                number = node2.bigIntegerValue();
            } else if (JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                number = node2.decimalValue();
            } else {
                throw new MatchError((Object)numberType);
            }
            object = number;
        } else {
            object = new IllegalArgumentException(new StringBuilder(22).append("Unsupported node type ").append(node2.getNodeType()).toString());
        }
        return object;
    }

    private static final StringBuilder appendStringified$1(JsonNode node, boolean rootLevel, StringBuilder sb$1) {
        StringBuilder stringBuilder;
        JsonNodeType jsonNodeType = node.getNodeType();
        if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            StringBuilder stringBuilder2;
            JsonParser.NumberType numberType = node.numberType();
            if (JsonParser.NumberType.INT.equals(numberType)) {
                stringBuilder2 = sb$1.append(node.intValue());
            } else if (JsonParser.NumberType.LONG.equals(numberType)) {
                stringBuilder2 = sb$1.append(node.longValue());
            } else if (JsonParser.NumberType.FLOAT.equals(numberType)) {
                stringBuilder2 = sb$1.append(node.floatValue());
            } else if (JsonParser.NumberType.DOUBLE.equals(numberType)) {
                stringBuilder2 = sb$1.append(node.doubleValue());
            } else if (JsonParser.NumberType.BIG_INTEGER.equals(numberType)) {
                stringBuilder2 = sb$1.append(node.bigIntegerValue());
            } else if (JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                stringBuilder2 = sb$1.append(node.decimalValue());
            } else {
                throw new MatchError((Object)numberType);
            }
            stringBuilder = stringBuilder2;
        } else {
            stringBuilder = JsonNodeType.STRING.equals(jsonNodeType) ? Json$.appendString$1(node.asText(), rootLevel, sb$1) : (JsonNodeType.OBJECT.equals(jsonNodeType) ? Json$.appendMap$1(node, sb$1) : (JsonNodeType.ARRAY.equals(jsonNodeType) ? Json$.appendArray$1(node, sb$1) : (JsonNodeType.BOOLEAN.equals(jsonNodeType) ? sb$1.append(node.booleanValue()) : (JsonNodeType.NULL.equals(jsonNodeType) ? sb$1.append("null") : Json$.appendString$1(node.toString(), rootLevel, sb$1)))));
        }
        return stringBuilder;
    }

    private static final StringBuilder appendString$1(String s, boolean rootLevel, StringBuilder sb$1) {
        StringBuilder stringBuilder;
        if (rootLevel) {
            stringBuilder = Json$.appendString0$1(s, sb$1);
        } else {
            sb$1.append('\"');
            stringBuilder = Json$.appendString0$1(s, sb$1).append('\"');
        }
        return stringBuilder;
    }

    private static final StringBuilder appendString0$1(String s, StringBuilder sb$1) {
        block9: for (int index$macro$2 = 0; index$macro$2 < s.length(); ++index$macro$2) {
            int c;
            int n = c = s.charAt(index$macro$2);
            switch (n) {
                case 34: {
                    sb$1.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb$1.append("\\\\");
                    continue block9;
                }
                case 8: {
                    sb$1.append("\\b");
                    continue block9;
                }
                case 12: {
                    sb$1.append("\\f");
                    continue block9;
                }
                case 10: {
                    sb$1.append("\\n");
                    continue block9;
                }
                case 13: {
                    sb$1.append("\\r");
                    continue block9;
                }
                case 9: {
                    sb$1.append("\\t");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl((char)c)) {
                        sb$1.append("\\u");
                        int n2 = c;
                        for (int index$macro$1 = 0; index$macro$1 < 4; ++index$macro$1) {
                            int digit = (n2 & 0xF000) >> 12;
                            sb$1.append(Hex$.MODULE$.toHexChar(digit));
                            n2 <<= 4;
                        }
                        continue block9;
                    }
                    sb$1.append((char)c);
                    continue block9;
                }
            }
        }
        return sb$1;
    }

    private static final StringBuilder appendArray$1(JsonNode node, StringBuilder sb$1) {
        block0: {
            sb$1.append('[');
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.elements()).asScala()).foreach((Function1 & Serializable & scala.Serializable)elem -> Json$.appendStringified$1(elem, false, sb$1).append(','));
            if (node.size() <= 0) break block0;
            sb$1.setLength(sb$1.length() - 1);
        }
        return sb$1.append(']');
    }

    private static final StringBuilder appendMap$1(JsonNode node, StringBuilder sb$1) {
        block0: {
            sb$1.append('{');
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.fields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                sb$1.append('\"').append((String)e.getKey()).append("\":");
                return Json$.appendStringified$1((JsonNode)e.getValue(), false, sb$1).append(',');
            });
            if (node.size() <= 0) break block0;
            sb$1.setLength(sb$1.length() - 1);
        }
        return sb$1.append('}');
    }

    private static final StringBuilder appendStringified$2(Object value, boolean rootLevel, StringBuilder sb$2) {
        StringBuilder stringBuilder;
        Object object = value;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            stringBuilder = sb$2.append(by);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            stringBuilder = sb$2.append(s);
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            stringBuilder = sb$2.append(n);
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            stringBuilder = sb$2.append(l);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            stringBuilder = sb$2.append(f);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            stringBuilder = sb$2.append(d);
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            stringBuilder = sb$2.append(bl);
        } else if (object instanceof String) {
            String string = (String)object;
            stringBuilder = Json$.appendString$2(string, rootLevel, sb$2);
        } else if (object == null) {
            stringBuilder = sb$2.append("null");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            stringBuilder = Json$.appendMap$2(map, sb$2);
        } else if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            stringBuilder = Json$.appendMap$2((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala(), sb$2);
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            stringBuilder = Json$.appendArray$2((Traversable)Predef$.MODULE$.genericWrapArray(object2), sb$2);
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            stringBuilder = Json$.appendArray$2((Traversable)seq, sb$2);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            stringBuilder = Json$.appendArray$2((Traversable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala(), sb$2);
        } else {
            stringBuilder = Json$.appendString$2(value.toString(), rootLevel, sb$2);
        }
        return stringBuilder;
    }

    private static final StringBuilder appendString$2(String s, boolean rootLevel, StringBuilder sb$2) {
        StringBuilder stringBuilder;
        if (rootLevel) {
            stringBuilder = Json$.appendString0$2(s, sb$2);
        } else {
            sb$2.append('\"');
            stringBuilder = Json$.appendString0$2(s, sb$2).append('\"');
        }
        return stringBuilder;
    }

    private static final StringBuilder appendString0$2(String s, StringBuilder sb$2) {
        block9: for (int index$macro$2 = 0; index$macro$2 < s.length(); ++index$macro$2) {
            int c;
            int n = c = s.charAt(index$macro$2);
            switch (n) {
                case 34: {
                    sb$2.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb$2.append("\\\\");
                    continue block9;
                }
                case 8: {
                    sb$2.append("\\b");
                    continue block9;
                }
                case 12: {
                    sb$2.append("\\f");
                    continue block9;
                }
                case 10: {
                    sb$2.append("\\n");
                    continue block9;
                }
                case 13: {
                    sb$2.append("\\r");
                    continue block9;
                }
                case 9: {
                    sb$2.append("\\t");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl((char)c)) {
                        sb$2.append("\\u");
                        int n2 = c;
                        for (int index$macro$1 = 0; index$macro$1 < 4; ++index$macro$1) {
                            int digit = (n2 & 0xF000) >> 12;
                            sb$2.append(Hex$.MODULE$.toHexChar(digit));
                            n2 <<= 4;
                        }
                        continue block9;
                    }
                    sb$2.append((char)c);
                    continue block9;
                }
            }
        }
        return sb$2;
    }

    private static final StringBuilder appendArray$2(Traversable iterable, StringBuilder sb$2) {
        block0: {
            sb$2.append('[');
            iterable.foreach((Function1 & Serializable & scala.Serializable)elem -> Json$.appendStringified$2(elem, false, sb$2).append(','));
            if (!iterable.nonEmpty()) break block0;
            sb$2.setLength(sb$2.length() - 1);
        }
        return sb$2.append(']');
    }

    private static final StringBuilder appendMap$2(Map map, StringBuilder sb$2) {
        block0: {
            sb$2.append('{');
            map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                sb$2.append('\"').append(k).append("\":");
                StringBuilder stringBuilder = Json$.appendStringified$2(v, false, sb$2).append(',');
                return stringBuilder;
            });
            if (!map.nonEmpty()) break block0;
            sb$2.setLength(sb$2.length() - 1);
        }
        return sb$2.append('}');
    }

    private Json$() {
        MODULE$ = this;
        this.stringBuilders = new StringBuilderPool();
    }
}

