/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.ConsoleData;
import io.gatling.core.stats.writer.ConsoleSummary;
import io.gatling.core.stats.writer.ConsoleSummary$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.RequestCounters;
import io.gatling.core.stats.writer.RequestCounters$;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserCounters;
import io.gatling.core.stats.writer.UserEndMessage;
import io.gatling.core.stats.writer.UserStartMessage;
import java.io.Serializable;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\b\u0011\u0001mA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)1\u0007\u0001C\u0001i!9\u0001\b\u0001b\u0001\n\u0013I\u0004B\u0002\"\u0001A\u0003%!\bC\u0003D\u0001\u0011\u0005A\tC\u0003K\u0001\u0011\u00053\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003]\u0001\u0011%Q\fC\u0003e\u0001\u0011%Q\rC\u0003l\u0001\u0011%A\u000eC\u0003t\u0001\u0011%A\u000fC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0016\u0001!\t%a\u0006\u0003#\r{gn]8mK\u0012\u000bG/Y,sSR,'O\u0003\u0002\u0012%\u00051qO]5uKJT!a\u0005\u000b\u0002\u000bM$\u0018\r^:\u000b\u0005U1\u0012\u0001B2pe\u0016T!a\u0006\r\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011$\u0001\u0002j_\u000e\u00011C\u0001\u0001\u001d!\rib\u0004I\u0007\u0002!%\u0011q\u0004\u0005\u0002\u000b\t\u0006$\u0018m\u0016:ji\u0016\u0014\bCA\u000f\"\u0013\t\u0011\u0003CA\u0006D_:\u001cx\u000e\\3ECR\f\u0017!B2m_\u000e\\\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011)H/\u001b7\u000b\u0005%2\u0012aB2p[6|gn]\u0005\u0003W\u0019\u0012Qa\u00117pG.\fQbY8oM&<WO]1uS>t\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0015\u0003\u0019\u0019wN\u001c4jO&\u0011!g\f\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r)dg\u000e\t\u0003;\u0001AQaI\u0002A\u0002\u0011BQ\u0001L\u0002A\u00025\naB\u001a7vg\"$\u0016.\\3s\u001d\u0006lW-F\u0001;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003mC:<'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012aa\u0015;sS:<\u0017a\u00044mkNDG+[7fe:\u000bW.\u001a\u0011\u0002\r=t\u0017J\\5u)\t\u0001S\tC\u0003G\r\u0001\u0007q)\u0001\u0003j]&$\bCA\u000fI\u0013\tI\u0005C\u0001\u0003J]&$\u0018aB8o\r2,8\u000f\u001b\u000b\u0003\u0019J\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013A!\u00168ji\")1k\u0002a\u0001A\u0005!A-\u0019;b\u0003%yg.T3tg\u0006<W\rF\u0002M-nCQa\u0016\u0005A\u0002a\u000bq!\\3tg\u0006<W\r\u0005\u0002\u001e3&\u0011!\f\u0005\u0002\u0011\u0019>\fG-\u0012<f]RlUm]:bO\u0016DQa\u0015\u0005A\u0002\u0001\n!c\u001c8Vg\u0016\u00148\u000b^1si6+7o]1hKR\u0019AJX2\t\u000b}K\u0001\u0019\u00011\u0002\tU\u001cXM\u001d\t\u0003;\u0005L!A\u0019\t\u0003!U\u001bXM]*uCJ$X*Z:tC\u001e,\u0007\"B*\n\u0001\u0004\u0001\u0013\u0001E8o+N,'/\u00128e\u001b\u0016\u001c8/Y4f)\raeM\u001b\u0005\u0006?*\u0001\ra\u001a\t\u0003;!L!!\u001b\t\u0003\u001dU\u001bXM]#oI6+7o]1hK\")1K\u0003a\u0001A\u0005\trN\u001c*fgB|gn]3NKN\u001c\u0018mZ3\u0015\u00071k'\u000fC\u0003o\u0017\u0001\u0007q.\u0001\u0005sKN\u0004xN\\:f!\ti\u0002/\u0003\u0002r!\ty!+Z:q_:\u001cX-T3tg\u0006<W\rC\u0003T\u0017\u0001\u0007\u0001%\u0001\bp]\u0016\u0013(o\u001c:NKN\u001c\u0018mZ3\u0015\u00071+(\u0010C\u0003w\u0019\u0001\u0007q/A\u0003feJ|'\u000f\u0005\u0002\u001eq&\u0011\u0011\u0010\u0005\u0002\r\u000bJ\u0014xN]'fgN\fw-\u001a\u0005\u0006'2\u0001\r\u0001I\u0001\b_:\u001c%/Y:i)\u0011aU0a\u0005\t\u000byl\u0001\u0019A@\u0002\u000b\r\fWo]3\u0011\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tY\u0001E\u0002\u0002\u00069k!!a\u0002\u000b\u0007\u0005%!$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001bq\u0015A\u0002)sK\u0012,g-C\u0002B\u0003#Q1!!\u0004O\u0011\u0015\u0019V\u00021\u0001!\u0003\u0019ygn\u0015;paR\u0019A*!\u0007\t\u000bMs\u0001\u0019\u0001\u0011")
public class ConsoleDataWriter
extends DataWriter<ConsoleData> {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConsoleData onInit(Init init) {
        void var2_2;
        ConsoleData data = new ConsoleData(this.clock.nowMillis());
        init.scenarios().foreach((Function1 & Serializable & scala.Serializable)scenario -> data.usersCounters().put((Object)scenario.name(), (Object)new UserCounters(scenario.totalUserCount())));
        this.startTimerWithFixedDelay(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().console().writePeriod());
        return var2_2;
    }

    @Override
    public void onFlush(ConsoleData data) {
        long runDuration = (this.clock.nowMillis() - data.startUpTime()) / 1000L;
        ConsoleSummary summary = ConsoleSummary$.MODULE$.apply(runDuration, data.usersCounters(), data.globalRequestCounters(), data.requestsCounters(), data.errorsCounters(), this.configuration, new Date());
        data.complete_$eq(summary.complete());
        Predef$.MODULE$.println((Object)summary.text());
    }

    @Override
    public void onMessage(LoadEventMessage message, ConsoleData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserStartMessage) {
            UserStartMessage userStartMessage = (UserStartMessage)loadEventMessage;
            this.onUserStartMessage(userStartMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof UserEndMessage) {
            UserEndMessage userEndMessage = (UserEndMessage)loadEventMessage;
            this.onUserEndMessage(userEndMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            this.onErrorMessage(errorMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void onUserStartMessage(UserStartMessage user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userStart();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.scenario()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void onUserEndMessage(UserEndMessage user, ConsoleData data) {
        Option option = data.usersCounters().get((Object)user.scenario());
        if (option instanceof Some) {
            Some some = (Some)option;
            UserCounters userCounters = (UserCounters)some.value();
            userCounters.userDone();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Internal error, scenario '{}' has not been correctly initialized", new Object[]{user.scenario()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void onResponseMessage(ResponseMessage response, ConsoleData data) {
        String requestPath = ((TraversableOnce)response.groupHierarchy().$colon$plus((Object)response.name(), List$.MODULE$.canBuildFrom())).mkString(" / ");
        RequestCounters requestCounters = (RequestCounters)data.requestsCounters().getOrElseUpdate((Object)requestPath, (Function0 & Serializable & scala.Serializable)() -> RequestCounters$.MODULE$.empty());
        Status status = response.status();
        if (OK$.MODULE$.equals(status)) {
            data.globalRequestCounters().successfulCount_$eq(data.globalRequestCounters().successfulCount() + 1);
            requestCounters.successfulCount_$eq(requestCounters.successfulCount() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status)) {
            data.globalRequestCounters().failedCount_$eq(data.globalRequestCounters().failedCount() + 1);
            requestCounters.failedCount_$eq(requestCounters.failedCount() + 1);
            String errorMessage = (String)response.message().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<no-message>");
            data.errorsCounters().update((Object)errorMessage, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)errorMessage, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status);
        }
    }

    private void onErrorMessage(ErrorMessage error, ConsoleData data) {
        data.errorsCounters().update((Object)error.message(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)data.errorsCounters().getOrElse((Object)error.message(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1)));
    }

    @Override
    public void onCrash(String cause, ConsoleData data) {
    }

    @Override
    public void onStop(ConsoleData data) {
        block0: {
            this.cancelTimer(this.flushTimerName());
            if (data.complete()) break block0;
            this.onFlush(data);
        }
    }

    public ConsoleDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        this.flushTimerName = "flushTimer";
    }
}

