/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.Adaptive$;
import io.gatling.core.feeder.Batch;
import io.gatling.core.feeder.Batch$;
import io.gatling.core.feeder.BatchedSeparatedValuesFeeder$;
import io.gatling.core.feeder.FeederLoadingMode;
import io.gatling.core.feeder.FeederOptions;
import io.gatling.core.feeder.FeederSource;
import io.gatling.core.feeder.InMemoryFeeder$;
import io.gatling.core.feeder.SeparatedValuesParser$;
import io.gatling.core.feeder.ZippedResourceCache$;
import io.gatling.core.util.LineCounter;
import io.gatling.core.util.LineCounter$;
import io.gatling.core.util.Resource;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005y3Q!\u0003\u0006\u0003\u001dIA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011\u00159\u0004\u0001\"\u00019\u0011\u0015Y\u0001\u0001\"\u0011>\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015a\u0006\u0001\"\u0011^\u0005m\u0019V\r]1sCR,GMV1mk\u0016\u001ch)Z3eKJ\u001cv.\u001e:dK*\u00111\u0002D\u0001\u0007M\u0016,G-\u001a:\u000b\u00055q\u0011\u0001B2pe\u0016T!a\u0004\t\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011#\u0001\u0002j_N\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\rQ2$H\u0007\u0002\u0015%\u0011AD\u0003\u0002\r\r\u0016,G-\u001a:T_V\u00148-\u001a\t\u0003=\u0019r!a\b\u0013\u0011\u0005\u0001*R\"A\u0011\u000b\u0005\t\u001a\u0013A\u0002\u001fs_>$hh\u0001\u0001\n\u0005\u0015*\u0012A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!J\u000b\u0002\u0011I,7o\\;sG\u0016,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]1\tA!\u001e;jY&\u0011\u0001'\f\u0002\t%\u0016\u001cx.\u001e:dK\u0006I!/Z:pkJ\u001cW\rI\u0001\ng\u0016\u0004\u0018M]1u_J\u0004\"\u0001\u0006\u001b\n\u0005U*\"\u0001B\"iCJ\f\u0011\"];pi\u0016\u001c\u0005.\u0019:\u0002\rqJg.\u001b;?)\u0011I$h\u000f\u001f\u0011\u0005i\u0001\u0001\"B\u0015\u0006\u0001\u0004Y\u0003\"\u0002\u001a\u0006\u0001\u0004\u0019\u0004\"\u0002\u001c\u0006\u0001\u0004\u0019Dc\u0001 I\u001bB\u0019qHQ#\u000f\u0005i\u0001\u0015BA!\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0011#\u0003\r\u0019+W\rZ3s\u0015\t\t%\u0002\u0005\u0002\u0015\r&\u0011q)\u0006\u0002\u0004\u0003:L\b\"B%\u0007\u0001\u0004Q\u0015aB8qi&|gn\u001d\t\u00045-k\u0012B\u0001'\u000b\u000551U-\u001a3fe>\u0003H/[8og\")aJ\u0002a\u0001\u001f\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001U*\u000e\u0003ES!A\u0015\u0007\u0002\r\r|gNZ5h\u0013\t!\u0016K\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\\\u0001\re\u0016\u001cwN\u001d3t\u0007>,h\u000e\u001e\u000b\u0004/j[\u0006C\u0001\u000bY\u0013\tIVCA\u0002J]RDQ!S\u0004A\u0002)CQAT\u0004A\u0002=\u000bAA\\1nKV\tQ\u0004")
public final class SeparatedValuesFeederSource
implements FeederSource<String> {
    private final Resource resource;
    private final char separator;
    private final char quoteChar;

    public Resource resource() {
        return this.resource;
    }

    @Override
    public Iterator<Map<String, Object>> feeder(FeederOptions<String> options, GatlingConfiguration configuration) {
        Resource uncompressedResource = ZippedResourceCache$.MODULE$.unzipped(this.resource(), options);
        return this.applyBatch$1(uncompressedResource, configuration, options);
    }

    @Override
    public int recordsCount(FeederOptions<String> options, GatlingConfiguration configuration) {
        Resource uncompressedResource = ZippedResourceCache$.MODULE$.unzipped(this.resource(), options);
        LineCounter lineCounter = LineCounter$.MODULE$.apply(configuration.core().charset());
        int linesIncludingHeader = BoxesRunTime.unboxToInt((Object)Using$.MODULE$.resource((Object)uncompressedResource.inputStream(), (Function1 & Serializable)is -> BoxesRunTime.boxToInteger((int)lineCounter.countLines(is)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
        return linesIncludingHeader - 1;
    }

    @Override
    public String name() {
        return new StringBuilder(5).append("csv(").append(this.resource().name()).append(")").toString();
    }

    private final Iterator applyBatch$1(Resource res, GatlingConfiguration configuration$1, FeederOptions options$1) {
        Charset charset = configuration$1.core().charset();
        FeederLoadingMode feederLoadingMode = options$1.loadingMode();
        if (feederLoadingMode instanceof Batch) {
            Batch batch = (Batch)feederLoadingMode;
            int bufferSize = batch.bufferSize();
            return BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), bufferSize, charset);
        }
        if (Adaptive$.MODULE$.equals(feederLoadingMode) && res.file().length() > configuration$1.core().feederAdaptiveLoadModeThreshold()) {
            return BatchedSeparatedValuesFeeder$.MODULE$.apply(res.file(), this.separator, this.quoteChar, options$1.conversion(), options$1.strategy(), Batch$.MODULE$.DefaultBufferLines(), charset);
        }
        Vector records = (Vector)Using$.MODULE$.resource((Object)FileChannel.open(res.file().toPath(), new OpenOption[0]), (Function1 & Serializable)channel -> ((IterableOnceOps)SeparatedValuesParser$.MODULE$.feederFactory($this.separator, $this.quoteChar, charset).apply(channel)).toVector(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        return InMemoryFeeder$.MODULE$.apply(records, options$1.conversion(), options$1.strategy());
    }

    public SeparatedValuesFeederSource(Resource resource, char separator, char quoteChar) {
        this.resource = resource;
        this.separator = separator;
        this.quoteChar = quoteChar;
    }
}

