/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GatlingConstants {
    public static final int JAVA_MAJOR_VERSION;
    public static final List<String> DEFAULT_JVM_OPTIONS_BASE;
    public static final List<String> DEFAULT_JVM_OPTIONS_GATLING;

    private GatlingConstants() {
    }

    static {
        Object object = System.getProperty("java.specification.version").split("\\.");
        JAVA_MAJOR_VERSION = Integer.parseInt(object[0].equals("1") ? object[1] : object[0]);
        object = new ArrayList();
        object.add("-server");
        object.add("-XX:+HeapDumpOnOutOfMemoryError");
        object.add("-XX:MaxInlineLevel=20");
        object.add("-XX:MaxTrivialSize=12");
        if (JAVA_MAJOR_VERSION < 15) {
            object.add("-XX:-UseBiasedLocking");
        }
        DEFAULT_JVM_OPTIONS_BASE = Collections.unmodifiableList(object);
        ArrayList<String> arrayList = new ArrayList<String>((Collection<String>)object);
        arrayList.add("-Xmx1G");
        arrayList.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        arrayList.add("--add-opens=java.base/jdk.internal.misc=ALL-UNNAMED");
        DEFAULT_JVM_OPTIONS_GATLING = Collections.unmodifiableList(arrayList);
    }
}

