/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.client.http;

import io.gatling.plugin.client.http.AbstractApiRequests;
import io.gatling.plugin.client.http.ApiPath;
import io.gatling.plugin.client.http.HttpResponse;
import io.gatling.plugin.exceptions.ApiCallIOException;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.InvalidApiCallException;
import io.gatling.plugin.exceptions.PackageNotFoundException;
import io.gatling.plugin.model.PackageCreationPayload;
import io.gatling.plugin.model.Packages;
import io.gatling.plugin.model.Pkg;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.UUID;

class PackagesApiRequests
extends AbstractApiRequests {
    private static final ApiPath PKG_PATH = ApiPath.of("artifacts");

    PackagesApiRequests(URL uRL, String string) {
        super(uRL, string);
    }

    Packages listPackages() throws EnterprisePluginException {
        return this.getJson(ApiPath.of("artifacts"), Packages.class);
    }

    Pkg readPackage(UUID uUID) throws EnterprisePluginException {
        return this.getJson(PKG_PATH.append(uUID.toString()), Pkg.class, (HttpResponse httpResponse) -> {
            if (httpResponse.code == 404) {
                throw new PackageNotFoundException(uUID);
            }
        });
    }

    Pkg createPackage(PackageCreationPayload packageCreationPayload) throws EnterprisePluginException {
        return this.postJson(PKG_PATH, packageCreationPayload, Pkg.class);
    }

    long uploadPackage(UUID uUID, File file) throws EnterprisePluginException {
        ApiPath apiPath = PKG_PATH.append(uUID.toString(), "content").addQueryParam("filename", file.getName());
        this.put(apiPath, httpURLConnection -> {
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpURLConnection.setDoOutput(true);
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                Files.copy(file.toPath(), outputStream);
            }
            catch (IOException iOException) {
                throw new ApiCallIOException(iOException);
            }
        }, httpResponse -> {
            if (httpResponse.code == 413) {
                throw new InvalidApiCallException("Package exceeds maximum allowed size (5 GB)");
            }
            if (httpResponse.code == 404) {
                throw new PackageNotFoundException(uUID);
            }
        });
        return file.length();
    }
}

