/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client;

import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.LocalAddresses;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.List;
import java.util.function.Function;

public final class Request {
    private final String name;
    private final HttpMethod method;
    private final Uri uri;
    private final HttpHeaders headers;
    private final List<Cookie> cookies;
    private final RequestBody body;
    private final long requestTimeout;
    private final boolean autoOrigin;
    private final LocalAddresses localAddresses;
    private final Realm realm;
    private final ProxyServer proxyServer;
    private final Function<Request, Request> signatureCalculator;
    private final InetAddressNameResolver nameResolver;
    private final boolean http2Enabled;
    private final Http2PriorKnowledge http2PriorKnowledge;
    private final String wsSubprotocol;

    public Request(String string, HttpMethod httpMethod, Uri uri, HttpHeaders httpHeaders, List<Cookie> list, RequestBody requestBody, long l, boolean bl, LocalAddresses localAddresses, Realm realm, ProxyServer proxyServer, Function<Request, Request> function, InetAddressNameResolver inetAddressNameResolver, boolean bl2, Http2PriorKnowledge http2PriorKnowledge, String string2) {
        this.name = string;
        this.method = httpMethod;
        this.uri = uri;
        this.headers = httpHeaders;
        this.cookies = list;
        this.body = requestBody;
        this.requestTimeout = l;
        this.autoOrigin = bl;
        this.localAddresses = localAddresses;
        this.realm = realm;
        this.proxyServer = proxyServer;
        this.signatureCalculator = function;
        this.nameResolver = inetAddressNameResolver;
        this.http2Enabled = bl2;
        this.http2PriorKnowledge = http2PriorKnowledge;
        this.wsSubprotocol = string2;
    }

    public Request copyWithCopiedHeaders() {
        return new Request(this.name, this.method, this.uri, this.headers.copy(), this.cookies, this.body, this.requestTimeout, this.autoOrigin, this.localAddresses, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, this.http2PriorKnowledge, this.wsSubprotocol);
    }

    public Request copyWithNewUri(Uri uri) {
        return new Request(this.name, this.method, uri, this.headers, this.cookies, this.body, this.requestTimeout, this.autoOrigin, this.localAddresses, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, this.http2PriorKnowledge, this.wsSubprotocol);
    }

    public Request copyWithNewBody(RequestBody requestBody) {
        return new Request(this.name, this.method, this.uri, this.headers, this.cookies, requestBody, this.requestTimeout, this.autoOrigin, this.localAddresses, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, this.http2PriorKnowledge, this.wsSubprotocol);
    }

    public Request copyWithHttp2PriorKnowledge(Http2PriorKnowledge http2PriorKnowledge) {
        return new Request(this.name, this.method, this.uri, this.headers, this.cookies, this.body, this.requestTimeout, this.autoOrigin, this.localAddresses, this.realm, this.proxyServer, this.signatureCalculator, this.nameResolver, this.http2Enabled, http2PriorKnowledge, this.wsSubprotocol);
    }

    public String getName() {
        return this.name;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Uri getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isAutoOrigin() {
        return this.autoOrigin;
    }

    public LocalAddresses getLocalAddresses() {
        return this.localAddresses;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public Function<Request, Request> getSignatureCalculator() {
        return this.signatureCalculator;
    }

    public InetAddressNameResolver getNameResolver() {
        return this.nameResolver;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    public Http2PriorKnowledge getHttp2PriorKnowledge() {
        return this.http2PriorKnowledge;
    }

    public String getWsSubprotocol() {
        return this.wsSubprotocol;
    }

    public String toString() {
        return "Request{method=" + String.valueOf(this.method) + ", uri=" + String.valueOf(this.uri) + ", headers=" + String.valueOf(this.headers) + ", cookies=" + String.valueOf(this.cookies) + ", body=" + String.valueOf(this.body) + ", requestTimeout=" + this.requestTimeout + ", localAddresses=" + String.valueOf(this.localAddresses) + ", realm=" + String.valueOf(this.realm) + ", proxyServer=" + String.valueOf(this.proxyServer) + ", signatureCalculator=" + String.valueOf(this.signatureCalculator) + ", nameResolver=" + String.valueOf(this.nameResolver) + ", http2Enabled=" + this.http2Enabled + ", http2PriorKnowledge=" + String.valueOf((Object)this.http2PriorKnowledge) + ", wsSubprotocol=" + this.wsSubprotocol + "}";
    }
}

