/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.http;

import io.gatling.core.action.builder.ActionBuilder;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.response.Response;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.http.RequestWithBodyActionBuilder;
import io.gatling.javaapi.http.internal.HttpChecks;
import io.gatling.javaapi.http.internal.ScalaHttpRequestActionBuilderConditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public final class HttpRequestActionBuilder
extends RequestWithBodyActionBuilder<HttpRequestActionBuilder, HttpRequestBuilder> {
    public HttpRequestActionBuilder(HttpRequestBuilder httpRequestBuilder) {
        super(httpRequestBuilder);
    }

    @Override
    protected HttpRequestActionBuilder make(Function<HttpRequestBuilder, HttpRequestBuilder> function) {
        return new HttpRequestActionBuilder(function.apply((HttpRequestBuilder)this.wrapped));
    }

    public ActionBuilder asScala() {
        return (ActionBuilder)this.wrapped;
    }

    public @NonNull HttpRequestActionBuilder check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    public @NonNull HttpRequestActionBuilder check(@NonNull List<CheckBuilder> list) {
        return new HttpRequestActionBuilder(((HttpRequestBuilder)this.wrapped).check(HttpChecks.toScalaChecks(list)));
    }

    public @NonNull UntypedCondition checkIf(@NonNull String string) {
        return new UntypedCondition(ScalaHttpRequestActionBuilderConditions.untyped((HttpRequestBuilder)this.wrapped, string));
    }

    public @NonNull UntypedCondition checkIf(@NonNull Function<Session, Boolean> function) {
        return new UntypedCondition(ScalaHttpRequestActionBuilderConditions.untyped((HttpRequestBuilder)this.wrapped, function));
    }

    public TypedCondition checkIf(BiFunction<Response, Session, Boolean> biFunction) {
        return new TypedCondition(ScalaHttpRequestActionBuilderConditions.typed((HttpRequestBuilder)this.wrapped, biFunction));
    }

    public @NonNull HttpRequestActionBuilder ignoreProtocolChecks() {
        return this.make(HttpRequestBuilder::ignoreProtocolChecks);
    }

    public @NonNull HttpRequestActionBuilder silent() {
        return this.make(HttpRequestBuilder::silent);
    }

    public @NonNull HttpRequestActionBuilder notSilent() {
        return this.make(HttpRequestBuilder::notSilent);
    }

    public @NonNull HttpRequestActionBuilder disableFollowRedirect() {
        return this.make(HttpRequestBuilder::disableFollowRedirect);
    }

    public @NonNull HttpRequestActionBuilder transformResponse(@NonNull BiFunction<Response, Session, Response> biFunction) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.transformResponse(Expressions.javaBiFunctionToExpression((BiFunction)biFunction)));
    }

    public @NonNull HttpRequestActionBuilder resources(HttpRequestActionBuilder ... httpRequestActionBuilderArray) {
        return this.resources(Arrays.asList(httpRequestActionBuilderArray));
    }

    public @NonNull HttpRequestActionBuilder resources(@NonNull List<HttpRequestActionBuilder> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.resources(Converters.toScalaSeq(list.stream().map(httpRequestActionBuilder -> (HttpRequestBuilder)httpRequestActionBuilder.wrapped).collect(Collectors.toList()))));
    }

    public @NonNull HttpRequestActionBuilder requestTimeout(int n) {
        return this.requestTimeout(Duration.ofSeconds(n));
    }

    public @NonNull HttpRequestActionBuilder requestTimeout(@NonNull Duration duration) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.requestTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    public static final class UntypedCondition {
        private final ScalaHttpRequestActionBuilderConditions.Untyped wrapped;

        public UntypedCondition(ScalaHttpRequestActionBuilderConditions.Untyped untyped) {
            this.wrapped = untyped;
        }

        public @NonNull HttpRequestActionBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        public @NonNull HttpRequestActionBuilder then(@NonNull List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }

    public static final class TypedCondition {
        private final ScalaHttpRequestActionBuilderConditions.Typed wrapped;

        public TypedCondition(ScalaHttpRequestActionBuilderConditions.Typed typed) {
            this.wrapped = typed;
        }

        public @NonNull HttpRequestActionBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        public @NonNull HttpRequestActionBuilder then(@NonNull List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }
}

