/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.CircularIterator$;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.protocol.HttpProtocol;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public final class BaseUrlSupport$
implements LazyLogging {
    public static final BaseUrlSupport$ MODULE$ = new BaseUrlSupport$();
    private static final String BaseUrlAttributeName;
    private static final String WsBaseUrlAttributeName;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        BaseUrlAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.cache.baseUrl");
        WsBaseUrlAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.cache.wsBaseUrl");
    }

    private Logger logger$lzycompute() {
        BaseUrlSupport$ baseUrlSupport$ = this;
        synchronized (baseUrlSupport$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private String BaseUrlAttributeName() {
        return BaseUrlAttributeName;
    }

    private String WsBaseUrlAttributeName() {
        return WsBaseUrlAttributeName;
    }

    private Function1<Session, Session> setBaseUrl(List<String> baseUrls, String attributeName) {
        List<String> list = baseUrls;
        if (Nil$.MODULE$.equals(list)) {
            return Session$.MODULE$.Identity();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String url = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return (Function1 & Serializable)x$1 -> x$1.set(attributeName, (Object)url);
            }
        }
        Iterator it = CircularIterator$.MODULE$.apply((IndexedSeq)ArraySeq$.MODULE$.from(list, ClassTag$.MODULE$.apply(String.class)), true);
        return (Function1 & Serializable)x$2 -> x$2.set(attributeName, it.next());
    }

    public Function1<Session, Session> setHttpBaseUrl(HttpProtocol httpProtocol) {
        return this.setBaseUrl(httpProtocol.baseUrls(), this.BaseUrlAttributeName());
    }

    public Function1<Session, Session> setWsBaseUrl(HttpProtocol httpProtocol) {
        return this.setBaseUrl(httpProtocol.wsPart().wsBaseUrls(), this.WsBaseUrlAttributeName());
    }

    private Option<String> baseUrl(Session session, String attributeName) {
        return session.attributes().get((Object)attributeName).map((Function1 & Serializable)x$3 -> (String)x$3);
    }

    public Function1<Session, Option<String>> httpBaseUrl(HttpProtocol httpProtocol) {
        List<String> list = httpProtocol.baseUrls();
        if (Nil$.MODULE$.equals(list)) {
            return (Function1 & Serializable)x$4 -> None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String single = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                Some s = new Some((Object)single);
                return (Function1 & Serializable)x$5 -> s;
            }
        }
        return (Function1 & Serializable)x$6 -> MODULE$.baseUrl((Session)x$6, MODULE$.BaseUrlAttributeName());
    }

    public Function1<Session, Option<String>> wsBaseUrl(HttpProtocol httpProtocol) {
        List<String> list = httpProtocol.wsPart().wsBaseUrls();
        if (Nil$.MODULE$.equals(list)) {
            return (Function1 & Serializable)x$7 -> None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String single = (String)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                Some s = new Some((Object)single);
                return (Function1 & Serializable)x$8 -> s;
            }
        }
        return (Function1 & Serializable)x$9 -> MODULE$.baseUrl((Session)x$9, MODULE$.WsBaseUrlAttributeName());
    }

    public Function1<Session, Validation<String>> defaultDomain(HttpProtocol httpProtocol, Function1<Session, Validation<String>> failure) {
        List<String> list = httpProtocol.baseUrls();
        if (Nil$.MODULE$.equals(list)) {
            List<String> list2 = httpProtocol.wsPart().wsBaseUrls();
            if (Nil$.MODULE$.equals(list2)) {
                return failure;
            }
            if (list2 instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list2;
                String single = (String)colon2.head();
                List list3 = colon2.next$access$1();
                if (Nil$.MODULE$.equals(list3)) {
                    return package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)Uri.create((String)single).getHost()));
                }
            }
            return (Function1 & Serializable)session -> package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Uri.create((String)((String)MODULE$.baseUrl((Session)session, MODULE$.WsBaseUrlAttributeName()).get())).getHost()));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon3 = (.colon.colon)list;
            String single = (String)colon3.head();
            List list4 = colon3.next$access$1();
            if (Nil$.MODULE$.equals(list4)) {
                return package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)Uri.create((String)single).getHost()));
            }
        }
        return (Function1 & Serializable)session -> package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Uri.create((String)((String)MODULE$.baseUrl((Session)session, MODULE$.BaseUrlAttributeName()).get())).getHost()));
    }

    private BaseUrlSupport$() {
    }
}

