/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.ws;

import akka.actor.ActorRef;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Clock;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.ws.fsm.BinaryFrameReceived;
import io.gatling.http.action.ws.fsm.TextFrameReceived;
import io.gatling.http.action.ws.fsm.WebSocketClosed;
import io.gatling.http.action.ws.fsm.WebSocketConnected;
import io.gatling.http.action.ws.fsm.WebSocketCrashed;
import io.gatling.http.client.WebSocket;
import io.gatling.http.client.WebSocketListener;
import io.gatling.http.util.HttpHelper$;
import io.gatling.netty.util.ByteBufUtils;
import io.gatling.netty.util.Utf8ByteBufCharsetDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\b\u0011\u0001mA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!Aa\b\u0001B\u0001B\u0003%q\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0004O\u0001\u0001\u0007I\u0011B(\t\u000f-\u0004\u0001\u0019!C\u0005Y\"11\u000f\u0001Q!\nACQ\u0001\u001e\u0001\u0005BUDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003\u007f\u0001A\u0011IA!\u0005)96\u000fT5ti\u0016tWM\u001d\u0006\u0003#I\t!a^:\u000b\u0005M!\u0012AB1di&|gN\u0003\u0002\u0016-\u0005!\u0001\u000e\u001e;q\u0015\t9\u0002$A\u0004hCRd\u0017N\\4\u000b\u0003e\t!![8\u0004\u0001M\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012AB2mS\u0016tG/\u0003\u0002\"=\t\tr+\u001a2T_\u000e\\W\r\u001e'jgR,g.\u001a:\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0014)\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0015\u0002\u0007\r|W.\u0003\u0002,I\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u001d98/Q2u_J\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003I\nA!Y6lC&\u0011Ag\f\u0002\t\u0003\u000e$xN\u001d*fM\u0006Y1\u000f^1ug\u0016sw-\u001b8f!\t9D(D\u00019\u0015\tI$(A\u0003ti\u0006$8O\u0003\u0002<-\u0005!1m\u001c:f\u0013\ti\u0004HA\u0006Ti\u0006$8/\u00128hS:,\u0017!B2m_\u000e\\\u0007C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011)H/\u001b7\u000b\u0005\u00113\u0012aB2p[6|gn]\u0005\u0003\r\u0006\u0013Qa\u00117pG.\fa\u0001P5oSRtD\u0003B%L\u00196\u0003\"A\u0013\u0001\u000e\u0003AAQ\u0001\f\u0003A\u00025BQ!\u000e\u0003A\u0002YBQA\u0010\u0003A\u0002}\nqaY8pW&,7/F\u0001Q!\r\t6L\u0018\b\u0003%bs!a\u0015,\u000e\u0003QS!!\u0016\u000e\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0016!B:dC2\f\u0017BA-[\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aV\u0005\u00039v\u0013A\u0001T5ti*\u0011\u0011L\u0017\t\u0003?&l\u0011\u0001\u0019\u0006\u0003C\n\faaY8pW&,'BA\u000bd\u0015\t!W-A\u0003d_\u0012,7M\u0003\u0002gO\u00069\u0001.\u00198eY\u0016\u0014(B\u00015\u0019\u0003\u0015qW\r\u001e;z\u0013\tQ\u0007M\u0001\u0004D_>\\\u0017.Z\u0001\fG>|7.[3t?\u0012*\u0017\u000f\u0006\u0002ncB\u0011an\\\u0007\u00025&\u0011\u0001O\u0017\u0002\u0005+:LG\u000fC\u0004s\r\u0005\u0005\t\u0019\u0001)\u0002\u0007a$\u0013'\u0001\u0005d_>\\\u0017.Z:!\u00039yg\u000e\u0013;uaJ+7\u000f]8og\u0016$2!\u001c<}\u0011\u00159\b\u00021\u0001y\u0003IAG\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\u0011\u0005eTX\"\u00012\n\u0005m\u0014'A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukNDQ! \u0005A\u0002y\f1\u0002\u001b;ua\"+\u0017\rZ3sgB\u0011\u0011p`\u0005\u0004\u0003\u0003\u0011'a\u0003%uiBDU-\u00193feN\fqb\u001c8XK\n\u001cvnY6fi>\u0003XM\u001c\u000b\u0002[\u0006aqN\\\"m_N,gI]1nKR\u0019Q.a\u0003\t\u000f\u00055!\u00021\u0001\u0002\u0010\u0005)aM]1nKB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\t\f!b^3cg>\u001c7.\u001a;y\u0013\u0011\tI\"a\u0005\u0003'\rcwn]3XK\n\u001cvnY6fi\u001a\u0013\u0018-\\3\u0002\u0017=tG+\u001a=u\rJ\fW.\u001a\u000b\u0004[\u0006}\u0001bBA\u0007\u0017\u0001\u0007\u0011\u0011\u0005\t\u0005\u0003#\t\u0019#\u0003\u0003\u0002&\u0005M!A\u0005+fqR<VMY*pG.,GO\u0012:b[\u0016\fQb\u001c8CS:\f'/\u001f$sC6,GcA7\u0002,!9\u0011Q\u0002\u0007A\u0002\u00055\u0002\u0003BA\t\u0003_IA!!\r\u0002\u0014\t!\")\u001b8bef<VMY*pG.,GO\u0012:b[\u0016\f1b\u001c8Q_:<gI]1nKR\u0019Q.a\u000e\t\u000f\u00055Q\u00021\u0001\u0002:A!\u0011\u0011CA\u001e\u0013\u0011\ti$a\u0005\u0003%A{gnZ,fEN{7m[3u\rJ\fW.Z\u0001\f_:$\u0006N]8xC\ndW\rF\u0002n\u0003\u0007Bq!!\u0012\u000f\u0001\u0004\t9%A\u0001u!\r\t\u0016\u0011J\u0005\u0004\u0003\u0017j&!\u0003+ie><\u0018M\u00197f\u0001")
public class WsListener
extends WebSocketListener
implements LazyLogging {
    private final ActorRef wsActor;
    private final Clock clock;
    private List<Cookie> cookies;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        WsListener wsListener = this;
        synchronized (wsListener) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private List<Cookie> cookies() {
        return this.cookies;
    }

    private void cookies_$eq(List<Cookie> x$1) {
        this.cookies = x$1;
    }

    public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received response to WebSocket CONNECT: {} {}", new Object[]{httpResponseStatus, httpHeaders});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.cookies_$eq(HttpHelper$.MODULE$.responseCookies(httpHeaders));
    }

    public void onWebSocketOpen() {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.wsActor);
        WebSocketConnected x$1 = new WebSocketConnected((WebSocket)this, this.cookies(), this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onCloseFrame(CloseWebSocketFrame frame) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.wsActor);
        WebSocketClosed x$1 = new WebSocketClosed(frame.statusCode(), frame.reasonText(), this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onTextFrame(TextWebSocketFrame frame) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.wsActor);
        TextFrameReceived x$1 = new TextFrameReceived(Utf8ByteBufCharsetDecoder.decodeUtf8((ByteBuf)frame.content()), this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onBinaryFrame(BinaryWebSocketFrame frame) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.wsActor);
        BinaryFrameReceived x$1 = new BinaryFrameReceived(ByteBufUtils.byteBuf2Bytes((ByteBuf)frame.content()), this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void onPongFrame(PongWebSocketFrame frame) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received PONG frame");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onThrowable(Throwable t) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.wsActor);
        WebSocketCrashed x$1 = new WebSocketCrashed(t, this.clock.nowMillis());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public WsListener(ActorRef wsActor, StatsEngine statsEngine, Clock clock) {
        this.wsActor = wsActor;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        this.cookies = Nil$.MODULE$;
    }
}

