/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.util.NameGen;
import io.gatling.jms.action.JmsLogging;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTracker$;
import io.gatling.jms.client.JmsTrackerPool$;
import io.gatling.jms.protocol.JmsMessageMatcher;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Es!B\b\u0011\u0011\u0003Ib!B\u000e\u0011\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003bB\u0013\u0002\u0005\u0004%IA\n\u0005\u0007c\u0005\u0001\u000b\u0011B\u0014\u0007\tm\u0001\"A\r\u0005\t\u0001\u0016\u0011\t\u0011)A\u0005\u0003\"AA)\u0002B\u0001B\u0003%Q\t\u0003\u0005L\u000b\t\u0005\t\u0015!\u0003M\u0011!\u0011VA!A!\u0002\u0013\u0019\u0006\u0002\u0003.\u0006\u0005\u0003\u0005\u000b\u0011B.\t\u000b\r*A\u0011A1\t\u000f!,!\u0019!C\u0005S\"9\u0011\u0011F\u0003!\u0002\u0013Q\u0007bBA\u0016\u000b\u0011\u0005\u0011QF\u0001\u000f\u00156\u001cHK]1dW\u0016\u0014\bk\\8m\u0015\t\t\"#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003'Q\t1A[7t\u0015\t)b#A\u0004hCRd\u0017N\\4\u000b\u0003]\t!![8\u0004\u0001A\u0011!$A\u0007\u0002!\tq!*\\:Ue\u0006\u001c7.\u001a:Q_>d7CA\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!G\u0001\u0019\u00156\u001c8i\u001c8tk6,'\u000f\u00165sK\u0006$g)Y2u_JLX#A\u0014\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013AC2p]\u000e,(O]3oi*\u0011A&L\u0001\u0005kRLGN\u0003\u0002/-\u0005)a.\u001a;us&\u0011\u0001'\u000b\u0002\u0015\t\u00164\u0017-\u001e7u)\"\u0014X-\u00193GC\u000e$xN]=\u00023)k7oQ8ogVlWM\u001d+ie\u0016\fGMR1di>\u0014\u0018\u0010I\n\u0005\u000bu\u0019\u0014\b\u0005\u00025o5\tQG\u0003\u00027%\u00051\u0011m\u0019;j_:L!\u0001O\u001b\u0003\u0015)k7\u000fT8hO&tw\r\u0005\u0002;}5\t1H\u0003\u0002-y)\u0011Q\bF\u0001\u0005G>\u0014X-\u0003\u0002@w\t9a*Y7f\u000f\u0016t\u0017aC:fgNLwN\u001c)p_2\u0004\"A\u0007\"\n\u0005\r\u0003\"A\u0004&ngN+7o]5p]B{w\u000e\\\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0019KU\"A$\u000b\u0005!c\u0014!B1di>\u0014\u0018B\u0001&H\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0017M$\u0018\r^:F]\u001eLg.\u001a\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001fr\nQa\u001d;biNL!!\u0015(\u0003\u0017M#\u0018\r^:F]\u001eLg.Z\u0001\u0006G2|7m\u001b\t\u0003)bk\u0011!\u0016\u0006\u0003YYS!a\u0016\u000b\u0002\u000f\r|W.\\8og&\u0011\u0011,\u0016\u0002\u0006\u00072|7m[\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005q{V\"A/\u000b\u0005yc\u0014AB2p]\u001aLw-\u0003\u0002a;\n!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:$bAY2eK\u001a<\u0007C\u0001\u000e\u0006\u0011\u0015\u00015\u00021\u0001B\u0011\u0015!5\u00021\u0001F\u0011\u0015Y5\u00021\u0001M\u0011\u0015\u00116\u00021\u0001T\u0011\u0015Q6\u00021\u0001\\\u0003!!(/Y2lKJ\u001cX#\u00016\u0011\u000b-\u0004(/!\u0006\u000e\u00031T!AK7\u000b\u00051r'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011q2/\u001e?\n\u0005Q|\"A\u0002+va2,'\u0007\u0005\u0002wu6\tqO\u0003\u0002\u0014q*\t\u00110A\u0004kC.\f'\u000f^1\n\u0005m<(a\u0003#fgRLg.\u0019;j_:\u00042AH?\u0000\u0013\tqxD\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0003\tyA\u0004\u0003\u0002\u0004\u0005-\u0001cAA\u0003?5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013A\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u000e}\ta\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007?A)a)a\u0006\u0002\u001c%\u0019\u0011\u0011D$\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\u0004B!!\b\u0002$9\u0019!$a\b\n\u0007\u0005\u0005\u0002#\u0001\u0006K[N$&/Y2lKJLA!!\n\u0002(\t91i\\7nC:$'bAA\u0011!\u0005IAO]1dW\u0016\u00148\u000fI\u0001\biJ\f7m[3s))\t)\"a\f\u00024\u0005]\u0012\u0011\t\u0005\u0007\u0003cq\u0001\u0019A;\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u0005\u0007\u0003kq\u0001\u0019\u0001?\u0002\u0011M,G.Z2u_JDq!!\u000f\u000f\u0001\u0004\tY$A\nmSN$XM\\3s)\"\u0014X-\u00193D_VtG\u000fE\u0002\u001f\u0003{I1!a\u0010 \u0005\rIe\u000e\u001e\u0005\b\u0003\u0007r\u0001\u0019AA#\u00039iWm]:bO\u0016l\u0015\r^2iKJ\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017\u0012\u0012\u0001\u00039s_R|7m\u001c7\n\t\u0005=\u0013\u0011\n\u0002\u0012\u00156\u001cX*Z:tC\u001e,W*\u0019;dQ\u0016\u0014\b")
public final class JmsTrackerPool
implements JmsLogging,
NameGen {
    private final JmsSessionPool sessionPool;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final ConcurrentHashMap<Tuple2<Destination, Option<String>>, ActorRef<JmsTracker.Command>> trackers;
    private Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void logMessage(Function0<String> text, Message msg) {
        JmsLogging.logMessage$(this, text, msg);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<Tuple2<Destination, Option<String>>, ActorRef<JmsTracker.Command>> trackers() {
        return this.trackers;
    }

    public ActorRef<JmsTracker.Command> tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackers().computeIfAbsent((Tuple2<Destination, Option<String>>)new Tuple2((Object)destination, selector), x$1 -> {
            ActorRef tracker = $this.system.actorOf(JmsTracker$.MODULE$.actor(this.genName("jmsTrackerActor"), $this.statsEngine, $this.clock, $this.configuration));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), listenerThreadCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                int n = x$2;
                Thread thread = JmsTrackerPool$.MODULE$.io$gatling$jms$client$JmsTrackerPool$$JmsConsumerThreadFactory().newThread(() -> {
                    MessageConsumer consumer = $this.sessionPool.jmsSession().createConsumer(destination, (String)selector.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    consumer.setMessageListener(message -> {
                        String matchId = messageMatcher.responseMatchId(message);
                        this.logMessage((Function0<String>)(Function0 & Serializable)() -> "Message received JMSMessageID=" + message.getJMSMessageID() + " matchId=" + matchId, message);
                        tracker.$bang((Object)new JmsTracker.Command.MessageReceived(matchId, $this.clock.nowMillis(), message));
                    });
                });
                thread.start();
            });
            return tracker;
        });
    }

    public JmsTrackerPool(JmsSessionPool sessionPool, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.sessionPool = sessionPool;
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        JmsLogging.$init$(this);
        NameGen.$init$((NameGen)this);
        this.trackers = new ConcurrentHashMap();
        Statics.releaseFence();
    }
}

