/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public final class Transports {
    private static final ChannelFactory<? extends SocketChannel> EPOLL_SOCKET_CHANNEL_FACTORY = EpollSocketChannel::new;
    private static final ChannelFactory<? extends SocketChannel> NIO_SOCKET_CHANNEL_FACTORY = NioSocketChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> EPOLL_DATAGRAM_CHANNEL_FACTORY = EpollDatagramChannel::new;
    private static final ChannelFactory<? extends DatagramChannel> NIO_DATAGRAM_CHANNEL_FACTORY = NioDatagramChannel::new;

    private Transports() {
    }

    public static EventLoopGroup newEventLoopGroup(boolean bl, int n, String string) {
        DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(string);
        return bl && Epoll.isAvailable() ? new EpollEventLoopGroup(n, (ThreadFactory)defaultThreadFactory) : new NioEventLoopGroup(n, (ThreadFactory)defaultThreadFactory);
    }

    public static ChannelFactory<? extends SocketChannel> newSocketChannelFactory(boolean bl) {
        return bl && Epoll.isAvailable() ? EPOLL_SOCKET_CHANNEL_FACTORY : NIO_SOCKET_CHANNEL_FACTORY;
    }

    public static ChannelFactory<? extends DatagramChannel> newDatagramChannelFactory(boolean bl) {
        return bl && Epoll.isAvailable() ? EPOLL_DATAGRAM_CHANNEL_FACTORY : NIO_DATAGRAM_CHANNEL_FACTORY;
    }
}

