/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util;

import io.gatling.netty.util.Utf8ByteBufCharsetDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public final class ByteBufUtils {
    public static final ByteBuf[] EMPTY_BYTEBUF_ARRAY = new ByteBuf[0];
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final char[] EMPTY_CHARS = new char[0];
    private static final ThreadLocal<CharBuffer> CHAR_BUFFERS = ThreadLocal.withInitial(() -> CharBuffer.allocate(1024));

    private ByteBufUtils() {
    }

    public static byte[] byteBuf2Bytes(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n];
        if (byteBuf.hasArray()) {
            System.arraycopy(byteBuf.array(), byteBuf.readerIndex(), byArray, 0, n);
        } else {
            byteBuf.getBytes(byteBuf.readerIndex(), byArray);
        }
        return byArray;
    }

    public static byte[] byteBufs2Bytes(ByteBuf ... byteBufArray) {
        int n = 0;
        for (ByteBuf byteBuf : byteBufArray) {
            n += byteBuf.readableBytes();
        }
        if (n == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (ByteBuf byteBuf : byteBufArray) {
            int n3 = byteBuf.readableBytes();
            if (byteBuf.hasArray()) {
                System.arraycopy(byteBuf.array(), byteBuf.readerIndex(), byArray, n2, n3);
            } else {
                byteBuf.getBytes(byteBuf.readerIndex(), byArray, n2, n3);
            }
            n2 += n3;
        }
        return byArray;
    }

    public static String byteBuf2String(Charset charset, ByteBuf byteBuf) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8(byteBuf) : ByteBufUtils.decodeString(charset, byteBuf);
    }

    public static String byteBuf2String(Charset charset, ByteBuf ... byteBufArray) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8(byteBufArray) : ByteBufUtils.byteBuf2String0(charset, byteBufArray);
    }

    public static char[] byteBuf2Chars(Charset charset, ByteBuf byteBuf) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8Chars(byteBuf) : ByteBufUtils.decodeChars(charset, byteBuf);
    }

    public static char[] byteBuf2Chars(Charset charset, ByteBuf ... byteBufArray) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8Chars(byteBufArray) : ByteBufUtils.byteBuf2Chars0(charset, byteBufArray);
    }

    private static boolean isUtf8OrUsAscii(Charset charset) {
        return charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.US_ASCII);
    }

    static String decodeString(Charset charset, ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return "";
        }
        return ByteBufUtils.decode(byteBuf, charset).toString();
    }

    static char[] decodeChars(Charset charset, ByteBuf byteBuf) {
        if (!byteBuf.isReadable()) {
            return EMPTY_CHARS;
        }
        return ByteBufUtils.toCharArray(ByteBufUtils.decode(byteBuf, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String byteBuf2String0(Charset charset, ByteBuf ... byteBufArray) {
        if (byteBufArray.length == 1) {
            return ByteBufUtils.decodeString(charset, byteBufArray[0]);
        }
        ByteBuf byteBuf = ByteBufUtils.composite(byteBufArray);
        try {
            String string = ByteBufUtils.decodeString(charset, byteBuf);
            return string;
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] byteBuf2Chars0(Charset charset, ByteBuf ... byteBufArray) {
        if (byteBufArray.length == 1) {
            return ByteBufUtils.decodeChars(charset, byteBufArray[0]);
        }
        ByteBuf byteBuf = ByteBufUtils.composite(byteBufArray);
        try {
            char[] cArray = ByteBufUtils.decodeChars(charset, byteBuf);
            return cArray;
        }
        finally {
            byteBuf.release();
        }
    }

    private static ByteBuf composite(ByteBuf[] byteBufArray) {
        for (ByteBuf byteBuf : byteBufArray) {
            byteBuf.retain();
        }
        return Unpooled.wrappedBuffer((ByteBuf[])byteBufArray);
    }

    private static void decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
    }

    static char[] toCharArray(CharBuffer charBuffer) {
        char[] cArray = new char[charBuffer.remaining()];
        charBuffer.get(cArray);
        return cArray;
    }

    private static CharBuffer pooledCharBuffer(int n, CharsetDecoder charsetDecoder) {
        int n2 = (int)((double)n * (double)charsetDecoder.maxCharsPerByte());
        CharBuffer charBuffer = CHAR_BUFFERS.get();
        if (charBuffer.length() < n2) {
            charBuffer = CharBuffer.allocate(n2);
            CHAR_BUFFERS.set(charBuffer);
        } else {
            charBuffer.clear();
        }
        return charBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharBuffer decode(ByteBuf byteBuf, Charset charset) {
        int n = byteBuf.readerIndex();
        int n2 = byteBuf.readableBytes();
        CharsetDecoder charsetDecoder = CharsetUtil.decoder((Charset)charset);
        CharBuffer charBuffer = ByteBufUtils.pooledCharBuffer(n2, charsetDecoder);
        if (byteBuf.nioBufferCount() == 1) {
            ByteBufUtils.decode(charsetDecoder, byteBuf.internalNioBuffer(n, n2), charBuffer);
        } else {
            ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n2);
            try {
                byteBuf2.writeBytes(byteBuf, n, n2);
                ByteBufUtils.decode(charsetDecoder, byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n2), charBuffer);
            }
            finally {
                byteBuf2.release();
            }
        }
        charBuffer.flip();
        return charBuffer;
    }
}

