/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.xwing;

import io.gatling.recorder.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.gatling.recorder.internal.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.xwing.XWingKeyParameters;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;

public class XWingPrivateKeyParameters
extends XWingKeyParameters {
    private final KyberPrivateKeyParameters kybPriv;
    private final X25519PrivateKeyParameters xdhPriv;

    XWingPrivateKeyParameters(AsymmetricKeyParameter asymmetricKeyParameter, AsymmetricKeyParameter asymmetricKeyParameter2) {
        super(true);
        this.kybPriv = (KyberPrivateKeyParameters)asymmetricKeyParameter;
        this.xdhPriv = (X25519PrivateKeyParameters)asymmetricKeyParameter2;
    }

    public XWingPrivateKeyParameters(byte[] byArray) {
        super(false);
        this.kybPriv = new KyberPrivateKeyParameters(KyberParameters.kyber768, Arrays.copyOfRange(byArray, 0, byArray.length - 32));
        this.xdhPriv = new X25519PrivateKeyParameters(byArray, byArray.length - 32);
    }

    KyberPrivateKeyParameters getKyberPrivateKey() {
        return this.kybPriv;
    }

    X25519PrivateKeyParameters getXDHPrivateKey() {
        return this.xdhPriv;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(this.kybPriv.getEncoded(), this.xdhPriv.getEncoded());
    }
}

