/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.headless;

import io.gatling.commons.util.Io$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.ui.FrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.headless.HeadlessFrontEnd$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ErAB\r\u001b\u0011\u0003QBE\u0002\u0004'5!\u0005!d\n\u0005\u0006]\u0005!\t\u0001\r\u0005\bc\u0005\u0011\r\u0011\"\u00033\u0011\u0019Q\u0014\u0001)A\u0005g\u0019)aE\u0007\u0001\u001dw!A\u0001)\u0002B\u0001B\u0003%\u0011\t\u0003\u0005G\u000b\t\u0005\t\u0015a\u0003H\u0011\u0015qS\u0001\"\u0001N\u0011\u001d\u0011V\u00011A\u0005\nMCqaV\u0003A\u0002\u0013%\u0001\f\u0003\u0004_\u000b\u0001\u0006K\u0001\u0016\u0005\u0006?\u0016!\t\u0005\u0019\u0005\u0006I\u0016!\t%\u001a\u0005\u0006W\u0016!\t\u0005\u001c\u0005\u0006[\u0016!\tE\u001c\u0005\u0006y\u0016!\t% \u0005\u0006}\u0016!\t\u0005\u001c\u0005\u0006\u007f\u0016!\t\u0005\u001c\u0005\b\u0003\u0003)A\u0011IA\u0002\u0011\u0019\tY\"\u0002C!'\"1\u0011QD\u0003\u0005B1Dq!a\b\u0006\t\u0003\n\t\u0003\u0003\u0004\u0002(\u0015!I\u0001\u001c\u0005\b\u0003S)A\u0011BA\u0016\u0003AAU-\u00193mKN\u001chI]8oi\u0016sGM\u0003\u0002\u001c9\u0005A\u0001.Z1eY\u0016\u001c8O\u0003\u0002\u001e=\u0005\u0011Q/\u001b\u0006\u0003?\u0001\n\u0001B]3d_J$WM\u001d\u0006\u0003C\t\nqaZ1uY&twMC\u0001$\u0003\tIw\u000e\u0005\u0002&\u00035\t!D\u0001\tIK\u0006$G.Z:t\rJ|g\u000e^#oIN\u0011\u0011\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001J\u0001\u0010%\u0016\u001cwN\u001d3feBKGMR5mKV\t1\u0007\u0005\u00025q5\tQG\u0003\u0002$m)\tq'\u0001\u0003kCZ\f\u0017BA\u001d6\u0005\u00111\u0015\u000e\\3\u0002!I+7m\u001c:eKJ\u0004\u0016\u000e\u001a$jY\u0016\u00043CA\u0003=!\tid(D\u0001\u001d\u0013\tyDD\u0001\tSK\u000e|'\u000fZ3s\rJ|g\u000e^#oI\u0006Q1m\u001c8ue>dG.\u001a:\u0011\u0005\t#U\"A\"\u000b\u0005\u0001s\u0012BA#D\u0005I\u0011VmY8sI\u0016\u00148i\u001c8ue>dG.\u001a:\u0002\u001b\r|gNZ5hkJ\fG/[8o!\tA5*D\u0001J\u0015\tQe$\u0001\u0004d_:4\u0017nZ\u0005\u0003\u0019&\u0013QCU3d_J$WM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0002O#R\u0011q\n\u0015\t\u0003K\u0015AQA\u0012\u0005A\u0004\u001dCQ\u0001\u0011\u0005A\u0002\u0005\u000ba\u0001[1t%VtW#\u0001+\u0011\u0005%*\u0016B\u0001,+\u0005\u001d\u0011un\u001c7fC:\f!\u0002[1t%Vtw\fJ3r)\tIF\f\u0005\u0002*5&\u00111L\u000b\u0002\u0005+:LG\u000fC\u0004^\u0015\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0013'A\u0004iCN\u0014VO\u001c\u0011\u0002)M,G.Z2uK\u0012\u0014VmY8sI\u0016\u0014Xj\u001c3f+\u0005\t\u0007C\u0001%c\u0013\t\u0019\u0017J\u0001\u0007SK\u000e|'\u000fZ3s\u001b>$W-\u0001\u0007sK\u000e,\u0017N^3Fm\u0016tG\u000f\u0006\u0002ZM\")q-\u0004a\u0001Q\u0006)QM^3oiB\u0011Q([\u0005\u0003Ur\u0011QB\u0012:p]R,e\u000eZ#wK:$\u0018\u0001B5oSR$\u0012!W\u0001\u0017Q\u0006tG\r\\3ICJ,\u0005\u0010]8si\u001a\u000b\u0017\u000e\\;sKR\u0011\u0011l\u001c\u0005\u0006a>\u0001\r!]\u0001\b[\u0016\u001c8/Y4f!\t\u0011\u0018P\u0004\u0002toB\u0011AOK\u0007\u0002k*\u0011aoL\u0001\u0007yI|w\u000e\u001e \n\u0005aT\u0013A\u0002)sK\u0012,g-\u0003\u0002{w\n11\u000b\u001e:j]\u001eT!\u0001\u001f\u0016\u0002\u0017!\f'OR5mKB\u000bG\u000f[\u000b\u0002c\u00061\u0002.\u00198eY\u0016D\u0015M]#ya>\u0014HoU;dG\u0016\u001c8/\u0001\tsK\u000e|'\u000fZ5oON#\u0018M\u001d;fI\u0006q\u0002.\u00198eY\u00164\u0015\u000e\u001c;feZ\u000bG.\u001b3bi&|gNR1jYV\u0014Xm\u001d\u000b\u00043\u0006\u0015\u0001bBA\u0004'\u0001\u0007\u0011\u0011B\u0001\tM\u0006LG.\u001e:fgB)\u00111BA\u000bc:!\u0011QBA\t\u001d\r!\u0018qB\u0005\u0002W%\u0019\u00111\u0003\u0016\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u0005\r\u0019V-\u001d\u0006\u0004\u0003'Q\u0013AF1tWNKW.\u001e7bi&|gn\u0014<fe^\u0014\u0018\u000e^3\u0002!I,7m\u001c:eS:<7\u000b^8qa\u0016$\u0017\u0001\u00065b]\u0012dW-T5tg&tw\rS1s\r&dW\rF\u0002Z\u0003GAa!!\n\u0017\u0001\u0004\t\u0018\u0001\u00029bi\"\fab\u0019:fCR,Gj\\2l\r&dW-\u0001\u0005qe&tG/\u0012:s)\rI\u0016Q\u0006\u0005\u0007\u0003_A\u0002\u0019A9\u0002\u00075\u001cx\r")
public class HeadlessFrontEnd
extends RecorderFrontEnd {
    private final RecorderConfiguration configuration;
    private boolean hasRun;

    private boolean hasRun() {
        return this.hasRun;
    }

    private void hasRun_$eq(boolean x$1) {
        this.hasRun = x$1;
    }

    @Override
    public RecorderMode selectedRecorderMode() {
        return this.configuration.core().mode();
    }

    @Override
    public void receiveEvent(FrontEndEvent event) {
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("[Event] ").append(event).toString());
    }

    @Override
    public void init() {
        if (!this.hasRun()) {
            this.hasRun_$eq(true);
            Predef$.MODULE$.println((Object)"Starting Recorder in headless mode");
            RecorderMode recorderMode = this.selectedRecorderMode();
            RecorderMode$Proxy$ recorderMode$Proxy$ = RecorderMode$Proxy$.MODULE$;
            if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Proxy$) : recorderMode$Proxy$ != null) && HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile().exists()) {
                this.printErr(new StringBuilder(29).append("Recorder lock file found at ").append(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()).append(".").toString());
                this.printErr("Make sure that there is no other recording in progress.");
                throw package$.MODULE$.exit(1);
            }
            this.startRecording();
        } else {
            package$.MODULE$.runtime().halt(0);
        }
    }

    @Override
    public void handleHarExportFailure(String message) {
        this.printErr(new StringBuilder(28).append("Could not convert HAR file: ").append(message).toString());
    }

    @Override
    public String harFilePath() {
        return (String)this.configuration.core().harFilePath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    @Override
    public void handleHarExportSuccess() {
        Predef$.MODULE$.println((Object)"HAR file successfully converted.");
    }

    @Override
    public void recordingStarted() {
        this.createLockFile();
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Recording started, proxy port is ").append(this.configuration.proxy().port()).toString());
        Predef$.MODULE$.println((Object)"To stop the Recorder and generate the Simulation, kill the Recorder process with: ");
        Predef$.MODULE$.println((Object)"- CTRL-C");
        Predef$.MODULE$.println((Object)new StringBuilder(37).append("- Use the Recorder's PID, written to ").append(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()).toString());
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopRecording(true));
    }

    @Override
    public void handleFilterValidationFailures(Seq<String> failures) {
    }

    @Override
    public boolean askSimulationOverwrite() {
        this.printErr("Another simulation with the same name exists.");
        return false;
    }

    @Override
    public void recordingStopped() {
        HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile().delete();
        Predef$.MODULE$.println((Object)"New Gatling simulation created.");
    }

    @Override
    public void handleMissingHarFile(String path) {
        String errorMessage = path.isEmpty() ? "The HAR file to convert was not specified, either through recorder.conf or through CLI options." : new StringBuilder(36).append("Could not find the HAR file (path: ").append(path).append(")").toString();
        this.printErr(errorMessage);
    }

    private void createLockFile() {
        String pid = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getRuntimeMXBean().getName().split("@"))).head();
        Io$.MODULE$.withCloseable((AutoCloseable)new PrintStream(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.println(pid);
            return BoxedUnit.UNIT;
        });
    }

    private void printErr(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public HeadlessFrontEnd(RecorderController controller, RecorderConfiguration configuration) {
        this.configuration = configuration;
        super(controller);
        this.hasRun = false;
    }
}

