/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.ssl;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.recorder.http.ssl.Ca;
import io.gatling.recorder.http.ssl.Csr;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.Extension;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.GeneralName;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.GeneralNames;
import io.gatling.recorder.internal.bouncycastle.cert.X509CertificateHolder;
import io.gatling.recorder.internal.bouncycastle.cert.X509v3CertificateBuilder;
import io.gatling.recorder.internal.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import io.gatling.recorder.internal.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import io.gatling.recorder.internal.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import io.gatling.recorder.internal.bouncycastle.openssl.PEMKeyPair;
import io.gatling.recorder.internal.bouncycastle.openssl.PEMParser;
import io.gatling.recorder.internal.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import io.gatling.recorder.internal.bouncycastle.openssl.jcajce.JcaPEMWriter;
import io.gatling.recorder.internal.bouncycastle.operator.ContentSigner;
import io.gatling.recorder.internal.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import io.gatling.recorder.internal.bouncycastle.pkcs.PKCS10CertificationRequest;
import io.gatling.recorder.internal.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertGenerator$;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.x500.X500Principal;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class SslUtil$
implements StrictLogging {
    public static final SslUtil$ MODULE$;
    private static final SslProvider TheSslProvider;
    private static Logger logger;

    static {
        SslProvider sslProvider;
        MODULE$ = new SslUtil$();
        StrictLogging.$init$((StrictLogging)MODULE$);
        Security.addProvider((Provider)SelfSignedCertGenerator$.MODULE$.BcProvider());
        if (OpenSsl.isAvailable()) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("OpenSSL is not available on your architecture.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            sslProvider = SslProvider.OPENSSL;
        } else {
            sslProvider = SslProvider.JDK;
        }
        TheSslProvider = sslProvider;
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public SslProvider TheSslProvider() {
        return TheSslProvider;
    }

    public Tuple2<File, File> generateSelfSignedCertificate() {
        return SelfSignedCertGenerator$.MODULE$.generate();
    }

    public Object readPEM(InputStream file) {
        return Using$.MODULE$.resource((Object)new PEMParser((Reader)new InputStreamReader(file)), (Function1 & Serializable)x$1 -> x$1.readObject(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void writePEM(Object obj, OutputStream os) {
        Using$.MODULE$.resource((Object)new JcaPEMWriter((Writer)new OutputStreamWriter(os)), (Function1 & Serializable)x$2 -> {
            x$2.writeObject(obj);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public X509Certificate certificateFromHolder(X509CertificateHolder certHolder) {
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
    }

    public KeyPair newRSAKeyPair() {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(1024);
        return kpGen.generateKeyPair();
    }

    private ContentSigner newSigner(PrivateKey privKey) {
        return new JcaContentSignerBuilder("SHA256withRSA").build(privKey);
    }

    public void generateGatlingCAPEMFiles(Path dir, String privKeyFileName, String certFileName) {
        Predef$.MODULE$.assert(Files.isDirectory(dir, new LinkOption[0]), (Function0 & Serializable)() -> new StringBuilder(18).append(dir).append(" isn't a directory").toString());
        KeyPair pair = this.newRSAKeyPair();
        X509CertificateHolder crtHolder = this.generateCACertificate$1(pair);
        this.writePEM(crtHolder, new BufferedOutputStream(Files.newOutputStream(dir.resolve(certFileName), new OpenOption[0])));
        this.writePEM(pair, new BufferedOutputStream(Files.newOutputStream(dir.resolve(privKeyFileName), new OpenOption[0])));
    }

    public Try<Ca> getCA(InputStream crtFile, InputStream keyFile) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Object object = MODULE$.readPEM(crtFile);
            if (!(object instanceof X509CertificateHolder)) {
                throw new IllegalArgumentException("Cert file is not a valid X509 cert");
            }
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            X509Certificate certificate = MODULE$.certificateFromHolder(x509CertificateHolder);
            Object object2 = MODULE$.readPEM(keyFile);
            if (!(object2 instanceof PEMKeyPair)) {
                throw new IllegalArgumentException("Key file is not a valid PEM key pair");
            }
            PEMKeyPair pEMKeyPair = (PEMKeyPair)object2;
            PrivateKey privKey = new JcaPEMKeyConverter().getPrivateKey(pEMKeyPair.getPrivateKeyInfo());
            return new Ca(certificate, privKey);
        });
    }

    public Try<KeyStore> updateKeystoreWithNewAlias(KeyStore keyStore, char[] password, String alias, Try<Ca> caT) {
        return caT.flatMap((Function1 & Serializable)ca -> MODULE$.createCSR(alias).flatMap((Function1 & Serializable)csr -> MODULE$.createServerCert(ca.cert(), ca.privKey(), csr.cert(), csr.hostname()).flatMap((Function1 & Serializable)serverCrt -> MODULE$.addNewKeystoreEntry(keyStore, password, (X509Certificate)serverCrt, csr.privKey(), ca.cert(), alias))));
    }

    private Try<Csr> createCSR(String hostname) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            KeyPair pair = MODULE$.newRSAKeyPair();
            String dn = new StringBuilder(51).append("C=FR, ST=Val de marne, O=GatlingCA, OU=Gatling, CN=").append(hostname).toString();
            JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal(dn), pair.getPublic());
            ContentSigner signer = MODULE$.newSigner(pair.getPrivate());
            PKCS10CertificationRequest pkcs10CR = builder.build(signer);
            return new Csr(pkcs10CR, pair.getPrivate(), hostname);
        });
    }

    private Try<X509Certificate> createServerCert(X509Certificate caCert, PrivateKey caKey, PKCS10CertificationRequest csr, String hostname) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            long now = System.currentTimeMillis();
            X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(caCert).getSubject(), BigInteger.valueOf(ThreadLocalRandom.current().nextLong()), new Date(now), new Date(now + new package.DurationInt(package$.MODULE$.DurationInt(1)).day().toMillis()), csr.getSubject(), csr.getSubjectPublicKeyInfo());
            byte[] subjectAltName = new GeneralNames(new GeneralName(2, hostname)).getEncoded();
            certBuilder.addExtension(Extension.subjectAlternativeName, false, subjectAltName);
            ContentSigner signer = MODULE$.newSigner(caKey);
            return MODULE$.certificateFromHolder(certBuilder.build(signer));
        });
    }

    private Try<KeyStore> addNewKeystoreEntry(KeyStore keyStore, char[] password, X509Certificate serverCert, PrivateKey csrPrivKey, X509Certificate caCert, String alias) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            keyStore.setCertificateEntry(alias, serverCert);
            keyStore.setKeyEntry(alias, csrPrivKey, password, (Certificate[])((Object[])new Certificate[]{serverCert, caCert}));
            return keyStore;
        });
    }

    private final X509CertificateHolder generateCACertificate$1(KeyPair pair) {
        String dn = "C=FR, ST=Val de marne, O=GatlingCA, CN=Gatling";
        long now = System.currentTimeMillis();
        JcaX509v1CertificateBuilder certGen = new JcaX509v1CertificateBuilder(new X500Principal(dn), BigInteger.valueOf(now), new Date(now), new Date(now + new package.DurationInt(package$.MODULE$.DurationInt(365)).days().toMillis()), new X500Principal(dn), pair.getPublic());
        ContentSigner signer = this.newSigner(pair.getPrivate());
        return certGen.build(signer);
    }

    private SslUtil$() {
    }
}

