/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.render.template;

import io.gatling.commons.util.StringHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.render.DumpedBody;
import io.gatling.recorder.render.HttpTrafficElement;
import io.gatling.recorder.render.PauseElement;
import io.gatling.recorder.render.ProtocolDefinition;
import io.gatling.recorder.render.RequestElement;
import io.gatling.recorder.render.TagElement;
import io.gatling.recorder.render.template.ExtractedUris;
import io.gatling.recorder.render.template.ExtractedUris$;
import io.gatling.recorder.render.template.Format;
import io.gatling.recorder.render.template.Format$Java11$;
import io.gatling.recorder.render.template.Format$Java17$;
import io.gatling.recorder.render.template.Format$Java8$;
import io.gatling.recorder.render.template.Format$Kotlin$;
import io.gatling.recorder.render.template.Format$Scala$;
import io.gatling.recorder.render.template.ProtocolTemplate;
import io.gatling.recorder.render.template.RequestTemplate;
import io.gatling.recorder.render.template.SimulationTemplate$;
import io.gatling.recorder.render.template.UrlVal;
import io.gatling.recorder.render.template.package$;
import io.gatling.recorder.render.template.package$TemplateString$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005esA\u0002\u000b\u0016\u0011\u00039rD\u0002\u0004\"+!\u0005qC\t\u0005\u0006S\u0005!\ta\u000b\u0005\u0006Y\u0005!\t!\f\u0005\t\u0003s\tA\u0011A\u000b\u0002<!A\u00111J\u0001\u0005\u0002U\ti\u0005C\u0005\u0002T\u0005\u0011\r\u0011\"\u0003\u0002V!9\u0011qK\u0001!\u0002\u00131f!B\u0011\u0016\u0001]y\u0003\u0002\u0003\u0019\t\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011qB!\u0011!Q\u0001\nEB\u0001\"\u0010\u0005\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0003\"\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0003B\u0001B\u0003%a\tC\u0003*\u0011\u0011\u0005\u0011\nC\u0003P\u0011\u0011%\u0001\u000bC\u0003f\u0011\u0011%a\rC\u0003z\u0011\u0011%!\u0010\u0003\u0004\u0000\u0011\u0011%\u0011\u0011\u0001\u0005\u00071!!\t!a\u0002\u0002%MKW.\u001e7bi&|g\u000eV3na2\fG/\u001a\u0006\u0003-]\t\u0001\u0002^3na2\fG/\u001a\u0006\u00031e\taA]3oI\u0016\u0014(B\u0001\u000e\u001c\u0003!\u0011XmY8sI\u0016\u0014(B\u0001\u000f\u001e\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AH\u0001\u0003S>\u0004\"\u0001I\u0001\u000e\u0003U\u0011!cU5nk2\fG/[8o)\u0016l\u0007\u000f\\1uKN\u0011\u0011a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aH\u0001\u0006CB\u0004H.\u001f\u000b\b]\u0005e\u0011QEA\u0015!\t\u0001\u0003b\u0005\u0002\tG\u0005Y\u0001/Y2lC\u001e,g*Y7f!\t\u0011\u0014H\u0004\u00024oA\u0011A'J\u0007\u0002k)\u0011aGK\u0001\u0007yI|w\u000e\u001e \n\u0005a*\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u0013\u0002'MLW.\u001e7bi&|gn\u00117bgNt\u0015-\\3\u0002\r\u0019|'/\\1u!\t\u0001s(\u0003\u0002A+\t1ai\u001c:nCR\f\u0001\u0003\u001d:pi>\u001cw\u000e\u001c+f[Bd\u0017\r^3\u0011\u0005\u0001\u001a\u0015B\u0001#\u0016\u0005A\u0001&o\u001c;pG>dG+Z7qY\u0006$X-A\bsKF,Xm\u001d;UK6\u0004H.\u0019;f!\t\u0001s)\u0003\u0002I+\ty!+Z9vKN$H+Z7qY\u0006$X\r\u0006\u0004/\u0015.cUJ\u0014\u0005\u0006a9\u0001\r!\r\u0005\u0006y9\u0001\r!\r\u0005\u0006{9\u0001\rA\u0010\u0005\u0006\u0003:\u0001\rA\u0011\u0005\u0006\u000b:\u0001\rAR\u0001\u000ee\u0016tG-\u001a:IK\u0006$WM]:\u0015\u0005E\n\u0006\"\u0002*\u0010\u0001\u0004\u0019\u0016a\u00025fC\u0012,'o\u001d\t\u0005eQ3\u0016,\u0003\u0002Vw\t\u0019Q*\u00199\u0011\u0005\u0011:\u0016B\u0001-&\u0005\rIe\u000e\u001e\t\u00045~\u0013gBA.^\u001d\t!D,C\u0001'\u0013\tqV%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'aA*fc*\u0011a,\n\t\u0005I\r\f\u0014'\u0003\u0002eK\t1A+\u001e9mKJ\nQC]3oI\u0016\u00148kY3oCJLw.\u00127f[\u0016tG\u000fF\u0002h]R\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\t1\fgn\u001a\u0006\u0002Y\u0006!!.\u0019<b\u0013\tQ\u0014\u000eC\u0003p!\u0001\u0007\u0001/\u0001\u0002tKB\u0011\u0011O]\u0007\u0002/%\u00111o\u0006\u0002\u0013\u0011R$\b\u000f\u0016:bM\u001aL7-\u00127f[\u0016tG\u000fC\u0003v!\u0001\u0007a/A\u0007fqR\u0014\u0018m\u0019;fIV\u0013\u0018n\u001d\t\u0003A]L!\u0001_\u000b\u0003\u001b\u0015CHO]1di\u0016$WK]5t\u00035\u0019\u0007.Y5o\u000b2,W.\u001a8ugR\u0019\u0011g\u001f?\t\u000bU\f\u0002\u0019\u0001<\t\u000bu\f\u0002\u0019\u0001@\u0002\u0011\u0015dW-\\3oiN\u00042AW0q\u00039\u0011XM\u001c3feN\u001bWM\\1sS>$R!MA\u0002\u0003\u000bAQ!\u001e\nA\u0002YDQ! \nA\u0002y$r!MA\u0005\u0003'\t)\u0002C\u0004\u0002\fM\u0001\r!!\u0004\u0002\u0011A\u0014x\u000e^8d_2\u00042!]A\b\u0013\r\t\tb\u0006\u0002\u0013!J|Go\\2pY\u0012+g-\u001b8ji&|g\u000eC\u0003S'\u0001\u00071\u000b\u0003\u0004\u0002\u0018M\u0001\rA`\u0001\u0011g\u000e,g.\u0019:j_\u0016cW-\\3oiNDq!a\u0007\u0004\u0001\u0004\ti\"A\u0007sKF,Xm\u001d;C_\u0012LWm\u001d\t\u0006eQ3\u0016q\u0004\t\u0004c\u0006\u0005\u0012bAA\u0012/\tQA)^7qK\u0012\u0014u\u000eZ=\t\u000f\u0005\u001d2\u00011\u0001\u0002\u001e\u0005q!/Z:q_:\u001cXMQ8eS\u0016\u001c\bbBA\u0016\u0007\u0001\u0007\u0011QF\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r\u001a\u0003\u0019\u0019wN\u001c4jO&!\u0011qGA\u0019\u0005U\u0011VmY8sI\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\f\u0011C]3oI\u0016\u0014hj\u001c8CCN,WK\u001d7t)\u0015\t\u0014QHA%\u0011\u001d\ty\u0004\u0002a\u0001\u0003\u0003\naA^1mk\u0016\u001c\b\u0003\u0002.`\u0003\u0007\u00022\u0001IA#\u0013\r\t9%\u0006\u0002\u0007+Jdg+\u00197\t\u000bu\"\u0001\u0019\u0001 \u0002!!,\u0017\rZ3sg\ncwnY6OC6,GcA4\u0002P!1\u0011\u0011K\u0003A\u0002Y\u000b!!\u001b3\u0002%5\u000b\u00070\u00127f[\u0016tG\u000fU3s\u0007\"\f\u0017N\\\u000b\u0002-\u0006\u0019R*\u0019=FY\u0016lWM\u001c;QKJ\u001c\u0005.Y5oA\u0001")
public class SimulationTemplate {
    private final String packageName;
    private final String simulationClassName;
    private final Format format;
    private final ProtocolTemplate protocolTemplate;
    private final RequestTemplate requestTemplate;

    public static SimulationTemplate apply(Map<Object, DumpedBody> requestBodies, Map<Object, DumpedBody> responseBodies, RecorderConfiguration configuration) {
        return SimulationTemplate$.MODULE$.apply(requestBodies, responseBodies, configuration);
    }

    private String renderHeaders(Map<Object, Seq<Tuple2<String, String>>> headers) {
        return ((IterableOnceOps)headers.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int headersBlockIndex = tuple2._1$mcI$sp();
                Seq headersBlock = (Seq)tuple2._2();
                String headerReference = SimulationTemplate$.MODULE$.headersBlockName(headersBlockIndex);
                Seq protectedHeaders = (Seq)headersBlock.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return new Tuple2((Object)package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(name), $this.format), (Object)package$TemplateString$.MODULE$.protect$extension(package$.MODULE$.TemplateString(value), $this.format));
                    }
                    throw new MatchError((Object)tuple2);
                });
                Format format = $this.format;
                if (Format$Scala$.MODULE$.equals(format)) {
                    Tuple2 tuple22;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple22 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple22._1();
                        String protectedValue = (String)tuple22._2();
                        return new StringBuilder(24).append("private val ").append(headerReference).append(" = Map(").append(protectedName).append(" -> ").append(protectedValue).append(")").toString();
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(62).append("private val ").append(headerReference).append(" = Map(\n                   |").append(((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return new StringBuilder(6).append("\t\t").append(protectedName).append(" -> ").append(protectedValue).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString(new StringBuilder(1).append(",").append(StringHelper$.MODULE$.Eol()).toString())).append("\n                   |)").toString()));
                }
                if (Format$Kotlin$.MODULE$.equals(format)) {
                    Tuple2 tuple23;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple23 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple23._1();
                        String protectedValue = (String)tuple23._2();
                        return new StringBuilder(26).append("private val ").append(headerReference).append(" = mapOf(").append(protectedName).append(" to ").append(protectedValue).append(")").toString();
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(64).append("private val ").append(headerReference).append(" = mapOf(\n                   |").append(((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return new StringBuilder(6).append("  ").append(protectedName).append(" to ").append(protectedValue).toString();
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString(new StringBuilder(1).append(",").append(StringHelper$.MODULE$.Eol()).toString())).append("\n                   |)").toString()));
                }
                if (Format$Java11$.MODULE$.equals(format) ? true : Format$Java17$.MODULE$.equals(format)) {
                    Tuple2 tuple24;
                    SeqOps seqOps;
                    Seq seq = protectedHeaders;
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple24 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        String protectedName = (String)tuple24._1();
                        String protectedValue = (String)tuple24._2();
                        return new StringBuilder(48).append("private Map<CharSequence, String> ").append(headerReference).append(" = Map.of(").append(protectedName).append(", ").append(protectedValue).append(");").toString();
                    }
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(95).append("private Map<CharSequence, String> ").append(headerReference).append(" = Map.ofEntries(\n                   |").append(((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$5 -> {
                        Tuple2 tuple2 = x0$5;
                        if (tuple2 != null) {
                            String protectedName = (String)tuple2._1();
                            String protectedValue = (String)tuple2._2();
                            return new StringBuilder(15).append("  Map.entry(").append(protectedName).append(", ").append(protectedValue).append(")").toString();
                        }
                        throw new MatchError((Object)tuple2);
                    })).mkString(new StringBuilder(1).append(",").append(StringHelper$.MODULE$.Eol()).toString())).append("\n                   |);").toString()));
                }
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(62).append("Map<CharSequence, String> ").append(headerReference).append(" = new HashMap<>();\n               |").append(((IterableOnceOps)protectedHeaders.map((Function1 & Serializable)x0$6 -> {
                    Tuple2 tuple2 = x0$6;
                    if (tuple2 != null) {
                        String protectedName = (String)tuple2._1();
                        String protectedValue = (String)tuple2._2();
                        return new StringBuilder(9).append(headerReference).append(".put(").append(protectedName).append(", ").append(protectedValue).append(");").toString();
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString(StringHelper$.MODULE$.Eol())).toString()));
            }
            throw new MatchError((Object)tuple2);
        })).mkString(StringHelper$.MODULE$.Eol(), new StringBuilder(0).append(StringHelper$.MODULE$.Eol()).append(StringHelper$.MODULE$.Eol()).toString(), "");
    }

    private String renderScenarioElement(HttpTrafficElement se, ExtractedUris extractedUris) {
        HttpTrafficElement httpTrafficElement = se;
        if (httpTrafficElement instanceof TagElement) {
            TagElement tagElement = (TagElement)httpTrafficElement;
            String text = tagElement.text();
            return new StringBuilder(3).append("// ").append(text).toString();
        }
        if (httpTrafficElement instanceof PauseElement) {
            Format format;
            PauseElement pauseElement = (PauseElement)httpTrafficElement;
            FiniteDuration duration = pauseElement.duration();
            String pauseString = duration.$greater((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()) ? Long.toString(duration.toSeconds()) : (Format$Scala$.MODULE$.equals(format = this.format) ? new StringBuilder(13).append(duration.toMillis()).append(".milliseconds").toString() : new StringBuilder(19).append("Duration.ofMillis(").append(duration.toMillis()).append(")").toString());
            return new StringBuilder(7).append("pause(").append(pauseString).append(")").toString();
        }
        if (httpTrafficElement instanceof RequestElement) {
            RequestElement requestElement = (RequestElement)httpTrafficElement;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(28).append("exec(\n         |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.requestTemplate.render(this.simulationClassName, requestElement, extractedUris)), 2)).append("\n         |)").toString()));
        }
        throw new MatchError((Object)httpTrafficElement);
    }

    private String chainElements(ExtractedUris extractedUris, Seq<HttpTrafficElement> elements) {
        BooleanRef firstNonTagElement = BooleanRef.create((boolean)true);
        return ((IterableOnceOps)elements.map((Function1 & Serializable)element -> {
            String string;
            HttpTrafficElement httpTrafficElement = element;
            if (httpTrafficElement instanceof TagElement) {
                string = "";
            } else if (firstNonTagElement$1.elem) {
                firstNonTagElement$1.elem = false;
                string = "";
            } else {
                string = ".";
            }
            String prefix = string;
            return new StringBuilder(0).append(prefix).append(this.renderScenarioElement((HttpTrafficElement)element, extractedUris)).toString();
        })).mkString(StringHelper$.MODULE$.Eol());
    }

    private String renderScenario(ExtractedUris extractedUris, Seq<HttpTrafficElement> elements) {
        String string;
        String string2;
        Format format = this.format;
        if (Format$Scala$.MODULE$.equals(format) ? true : Format$Kotlin$.MODULE$.equals(format)) {
            string2 = "private val";
        } else if (Format$Java11$.MODULE$.equals(format) ? true : Format$Java17$.MODULE$.equals(format)) {
            string2 = "private ScenarioBuilder";
        } else if (Format$Java8$.MODULE$.equals(format)) {
            string2 = "ScenarioBuilder";
        } else {
            throw new MatchError((Object)format);
        }
        String scenarioReferenceType = string2;
        if (IterableOps.SizeCompareOps$.MODULE$.$less$eq$extension(elements.sizeIs(), SimulationTemplate$.MODULE$.io$gatling$recorder$render$template$SimulationTemplate$$MaxElementPerChain())) {
            String scenarioElements = this.chainElements(extractedUris, elements);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(30).append(scenarioReferenceType).append(" scn = scenario(\"").append(this.simulationClassName).append("\")\n         |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(new StringBuilder(1).append(".").append(scenarioElements).toString()), 2)).append(this.format.lineTermination()).toString()));
        }
        List chains = ((List)elements.grouped(SimulationTemplate$.MODULE$.io$gatling$recorder$render$template$SimulationTemplate$$MaxElementPerChain()).toList().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq chain = (Seq)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)this.chainElements(extractedUris, (Seq<HttpTrafficElement>)chain));
            }
            throw new MatchError((Object)tuple2);
        });
        Format format2 = this.format;
        if (Format$Scala$.MODULE$.equals(format2) ? true : Format$Kotlin$.MODULE$.equals(format2)) {
            string = "private val";
        } else if (Format$Java11$.MODULE$.equals(format2) ? true : Format$Java17$.MODULE$.equals(format2)) {
            string = "private ChainBuilder";
        } else if (Format$Java8$.MODULE$.equals(format2)) {
            string = "ChainBuilder";
        } else {
            throw new MatchError((Object)format2);
        }
        String chainReferenceType = string;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(61).append(((IterableOnceOps)chains.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int i = tuple2._1$mcI$sp();
                String content = (String)tuple2._2();
                return new StringBuilder(9).append(chainReferenceType).append(" chain_").append(i).append(" =").append(StringHelper$.MODULE$.Eol()).append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(content), 2)).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString(new StringBuilder(0).append(this.format.lineTermination()).append(StringHelper$.MODULE$.Eol()).append(StringHelper$.MODULE$.Eol()).toString())).append("\n         |\n         |").append(scenarioReferenceType).append(" scn = scenario(\"").append(this.simulationClassName).append("\")\n         |  .exec(").append(((IterableOnceOps)chains.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int i = tuple2._1$mcI$sp();
                return new StringBuilder(6).append("chain_").append(i).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ")).append(")").append(this.format.lineTermination()).toString()));
    }

    public String render(ProtocolDefinition protocol, Map<Object, Seq<Tuple2<String, String>>> headers, Seq<HttpTrafficElement> scenarioElements) {
        ExtractedUris extractedUris = ExtractedUris$.MODULE$.apply(scenarioElements, this.format);
        Seq<UrlVal> nonBaseUrls = extractedUris.nonBaseUrls(protocol.baseUrl());
        Format format = this.format;
        if (Format$Scala$.MODULE$.equals(format)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(434).append((Object)(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? new StringBuilder(8).append("package ").append(this.packageName).append(StringHelper$.MODULE$.Eol()).toString() : "")).append("\n           |import scala.concurrent.duration._\n           |\n           |import io.gatling.core.Predef._\n           |import io.gatling.http.Predef._\n           |import io.gatling.jdbc.Predef._\n           |\n           |class ").append(this.simulationClassName).append(" extends Simulation {\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2)).append("\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2)).append("\n           |\n           |\tsetUp(scn.inject(atOnceUsers(1))).protocols(httpProtocol)\n           |}\n           |").toString()));
        }
        if (Format$Kotlin$.MODULE$.equals(format)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(639).append((Object)(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? new StringBuilder(8).append("package ").append(this.packageName).append(StringHelper$.MODULE$.Eol()).toString() : "")).append("\n           |import java.time.Duration\n           |\n           |import io.gatling.javaapi.core.*\n           |import io.gatling.javaapi.http.*\n           |import io.gatling.javaapi.jdbc.*\n           |\n           |import io.gatling.javaapi.core.CoreDsl.*\n           |import io.gatling.javaapi.http.HttpDsl.*\n           |import io.gatling.javaapi.jdbc.JdbcDsl.*\n           |\n           |class ").append(this.simulationClassName).append(" : Simulation() {\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2)).append("\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2)).append("\n           |\n           |  init {\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol)\n           |  }\n           |}\n           |").toString()));
        }
        if (Format$Java11$.MODULE$.equals(format) ? true : Format$Java17$.MODULE$.equals(format)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(706).append((Object)(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? new StringBuilder(9).append("package ").append(this.packageName).append(";").append(StringHelper$.MODULE$.Eol()).toString() : "")).append("\n           |import java.time.Duration;\n           |import java.util.*;\n           |\n           |import io.gatling.javaapi.core.*;\n           |import io.gatling.javaapi.http.*;\n           |import io.gatling.javaapi.jdbc.*;\n           |\n           |import static io.gatling.javaapi.core.CoreDsl.*;\n           |import static io.gatling.javaapi.http.HttpDsl.*;\n           |import static io.gatling.javaapi.jdbc.JdbcDsl.*;\n           |\n           |public class ").append(this.simulationClassName).append(" extends Simulation {\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 2)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 2)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 2)).append("\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 2)).append("\n           |\n           |  {\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol);\n           |  }\n           |}\n           |").toString()));
        }
        if (Format$Java8$.MODULE$.equals(format)) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(706).append((Object)(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.packageName)) ? new StringBuilder(9).append("package ").append(this.packageName).append(";").append(StringHelper$.MODULE$.Eol()).toString() : "")).append("\n           |import java.time.Duration;\n           |import java.util.*;\n           |\n           |import io.gatling.javaapi.core.*;\n           |import io.gatling.javaapi.http.*;\n           |import io.gatling.javaapi.jdbc.*;\n           |\n           |import static io.gatling.javaapi.core.CoreDsl.*;\n           |import static io.gatling.javaapi.http.HttpDsl.*;\n           |import static io.gatling.javaapi.jdbc.JdbcDsl.*;\n           |\n           |public class ").append(this.simulationClassName).append(" extends Simulation {\n           |\n           |  {\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.protocolTemplate.render(protocol)), 4)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderHeaders(headers)), 4)).append("\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(SimulationTemplate$.MODULE$.renderNonBaseUrls(nonBaseUrls, this.format)), 4)).append("\n           |\n           |").append(package$TemplateString$.MODULE$.indent$extension(package$.MODULE$.TemplateString(this.renderScenario(extractedUris, scenarioElements)), 4)).append("\n           |\n           |\t  setUp(scn.injectOpen(atOnceUsers(1))).protocols(httpProtocol);\n           |  }\n           |}\n           |").toString()));
        }
        throw new MatchError((Object)format);
    }

    public SimulationTemplate(String packageName, String simulationClassName, Format format, ProtocolTemplate protocolTemplate, RequestTemplate requestTemplate) {
        this.packageName = packageName;
        this.simulationClassName = simulationClassName;
        this.format = format;
        this.protocolTemplate = protocolTemplate;
        this.requestTemplate = requestTemplate;
    }
}

