/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.gatling.recorder.internal.bouncycastle.asn1.x500.X500Name;
import io.gatling.recorder.internal.bouncycastle.cert.X509CertificateHolder;
import io.gatling.recorder.internal.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import io.gatling.recorder.internal.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import io.gatling.recorder.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import io.gatling.recorder.internal.bouncycastle.operator.ContentSigner;
import io.gatling.recorder.internal.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.ssl.util.ThreadLocalInsecureRandom;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import scala.Array;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;

public final class SelfSignedCertGenerator$ {
    public static final SelfSignedCertGenerator$ MODULE$ = new SelfSignedCertGenerator$();
    private static final BouncyCastleProvider BcProvider = new BouncyCastleProvider();

    public BouncyCastleProvider BcProvider() {
        return BcProvider;
    }

    public Tuple2<File, File> generate() {
        Object object;
        KeyPair keyPair;
        String fqdn = "localhost";
        SecureRandom random = ThreadLocalInsecureRandom.current();
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048, random);
            keyPair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        KeyPair keypair = keyPair;
        PrivateKey privateKey = keypair.getPrivate();
        X500Name owner = new X500Name(new StringBuilder(3).append("CN=").append(fqdn).toString());
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), new Date(System.currentTimeMillis() - 31536000000L), new Date(253402300799000L), owner, keypair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(privateKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)this.BcProvider()).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        String[] stringArray = SelfSignedCertificate.newSelfSignedCertificate((String)fqdn, (PrivateKey)privateKey, (X509Certificate)cert);
        if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)stringArray);
        }
        String certificatePath = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String privateKeyPath = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)certificatePath, (Object)privateKeyPath);
        String certificatePath2 = (String)tuple2._1();
        String privateKeyPath2 = (String)tuple2._2();
        return new Tuple2((Object)new File(certificatePath2), (Object)new File(privateKeyPath2));
    }

    private SelfSignedCertGenerator$() {
    }
}

