/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.gatling.jsonpath.AST;
import io.gatling.jsonpath.AST$AnyField$;
import io.gatling.jsonpath.AST$CurrentNode$;
import io.gatling.jsonpath.AST$RecursiveAnyField$;
import io.gatling.jsonpath.AST$RootNode$;
import io.gatling.jsonpath.BinaryBooleanOperator;
import io.gatling.jsonpath.ComparisonOperator;
import io.gatling.jsonpath.RecursiveDataIterator;
import io.gatling.jsonpath.RecursiveFieldIterator;
import io.gatling.jsonpath.RecursiveNodeIterator;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A!\u0003\u0006\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0019)\u0005\u0001)C\u0005\u0015\"1q\n\u0001Q\u0005\nACa\u0001\u0016\u0001!\n\u0013)\u0006BB/\u0001A\u0013%aL\u0001\bKg>t\u0007+\u0019;i/\u0006d7.\u001a:\u000b\u0005-a\u0011\u0001\u00036t_:\u0004\u0018\r\u001e5\u000b\u00055q\u0011aB4bi2Lgn\u001a\u0006\u0002\u001f\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VMZ\u0001\te>|GOT8eKB\u0011!dI\u0007\u00027)\u0011A$H\u0001\tI\u0006$\u0018MY5oI*\u0011adH\u0001\bU\u0006\u001c7n]8o\u0015\t\u0001\u0013%A\u0005gCN$XM\u001d=nY*\t!%A\u0002d_6L!\u0001J\u000e\u0003\u0011)\u001bxN\u001c(pI\u0016\f\u0001BZ;mYB\u000bG\u000f\u001b\t\u0004O=\u0012dB\u0001\u0015.\u001d\tIC&D\u0001+\u0015\tY\u0003#\u0001\u0004=e>|GOP\u0005\u0002+%\u0011a\u0006F\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0014G\u0001\u0003MSN$(B\u0001\u0018\u0015!\t\u0019DH\u0004\u00025u9\u0011Q'\u000f\b\u0003mar!!K\u001c\n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u001e\u000b\u0003\r\t5\u000bV\u0005\u0003{y\u0012\u0011\u0002U1uQR{7.\u001a8\u000b\u0005mR\u0011A\u0002\u001fj]&$h\bF\u0002B\u0007\u0012\u0003\"A\u0011\u0001\u000e\u0003)AQ\u0001G\u0002A\u0002eAQ!J\u0002A\u0002\u0019\nAa^1mWR\tq\tE\u0002(\u0011fI!!S\u0019\u0003\u0011%#XM]1u_J$2aR&N\u0011\u0015aU\u00011\u0001\u001a\u0003\u0011qw\u000eZ3\t\u000b9+\u0001\u0019\u0001\u0014\u0002\tA\fG\u000f[\u0001\u0006o\u0006d7.\r\u000b\u0004\u000fF\u0013\u0006\"\u0002'\u0007\u0001\u0004I\u0002\"B*\u0007\u0001\u0004\u0011\u0014!B9vKJL\u0018aC1qa2Lh)\u001b7uKJ$2a\u0012,Y\u0011\u00159v\u00011\u0001\u001a\u0003-\u0019WO\u001d:f]Rtu\u000eZ3\t\u000be;\u0001\u0019\u0001.\u0002\u0017\u0019LG\u000e^3s)>\\WM\u001c\t\u0003gmK!\u0001\u0018 \u0003\u0017\u0019KG\u000e^3s)>\\WM\\\u0001\u000bg2L7-Z!se\u0006LH#B$`C&\\\u0007\"\u00021\t\u0001\u0004I\u0012!B1se\u0006L\b\"\u00022\t\u0001\u0004\u0019\u0017!B:uCJ$\bcA\neM&\u0011Q\r\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005M9\u0017B\u00015\u0015\u0005\rIe\u000e\u001e\u0005\u0006U\"\u0001\raY\u0001\u0005gR|\u0007\u000fC\u0003m\u0011\u0001\u0007a-\u0001\u0003ti\u0016\u0004\b")
public class JsonPathWalker {
    private final JsonNode rootNode;
    private final List<AST.PathToken> fullPath;

    public Iterator<JsonNode> walk() {
        return this.walk(this.rootNode, this.fullPath);
    }

    private Iterator<JsonNode> walk(JsonNode node, List<AST.PathToken> path) {
        Iterator iterator;
        List<AST.PathToken> list = path;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            AST.PathToken head = (AST.PathToken)colon2.head();
            List tail = colon2.tl$access$1();
            iterator = this.walk1(node, head).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.walk((JsonNode)x$2, (List<AST.PathToken>)tail));
        } else {
            iterator = scala.package$.MODULE$.Iterator().single((Object)node);
        }
        return iterator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterator<JsonNode> walk1(JsonNode node, AST.PathToken query) {
        boolean bl = false;
        AST.ArraySlice arraySlice = null;
        AST.PathToken pathToken = query;
        if (AST$RootNode$.MODULE$.equals(pathToken)) {
            return scala.package$.MODULE$.Iterator().single((Object)this.rootNode);
        }
        if (AST$CurrentNode$.MODULE$.equals(pathToken)) {
            return scala.package$.MODULE$.Iterator().single((Object)node);
        }
        if (pathToken instanceof AST.Field) {
            JsonNode child;
            AST.Field field = (AST.Field)pathToken;
            String name2 = field.name();
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType2 = JsonNodeType.OBJECT;
            return !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType2) : jsonNodeType2 != null) ? ((child = node.get(name2)) == null ? scala.package$.MODULE$.Iterator().empty() : scala.package$.MODULE$.Iterator().single((Object)child)) : scala.package$.MODULE$.Iterator().empty();
        }
        if (pathToken instanceof AST.RecursiveField) {
            AST.RecursiveField recursiveField = (AST.RecursiveField)pathToken;
            String name3 = recursiveField.name();
            return new RecursiveFieldIterator(node, name3);
        }
        if (pathToken instanceof AST.MultiField) {
            AST.MultiField multiField = (AST.MultiField)pathToken;
            List<String> fieldNames = multiField.names();
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType3 = JsonNodeType.OBJECT;
            return !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType3) : jsonNodeType3 != null) ? fieldNames.iterator().flatMap((Function1 & Serializable & scala.Serializable)name -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)node.get(name)))) : scala.package$.MODULE$.Iterator().empty();
        }
        if (AST$AnyField$.MODULE$.equals(pathToken)) {
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType4 = JsonNodeType.OBJECT;
            return !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType4) : jsonNodeType4 != null) ? (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.elements()).asScala() : scala.package$.MODULE$.Iterator().empty();
        }
        if (pathToken instanceof AST.ArraySlice) {
            bl = true;
            arraySlice = (AST.ArraySlice)pathToken;
            Option<Object> option = arraySlice.start();
            Option<Object> option2 = arraySlice.stop();
            int n = arraySlice.step();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2) && 1 == n) {
                JsonNodeType jsonNodeType = node.getNodeType();
                JsonNodeType jsonNodeType5 = JsonNodeType.ARRAY;
                return !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType5) : jsonNodeType5 != null) ? (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.elements()).asScala() : scala.package$.MODULE$.Iterator().empty();
            }
        }
        if (bl) {
            Option<Object> start = arraySlice.start();
            Option<Object> stop = arraySlice.stop();
            int step = arraySlice.step();
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType6 = JsonNodeType.ARRAY;
            return !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType6) : jsonNodeType6 != null) ? this.sliceArray(node, start, stop, step) : scala.package$.MODULE$.Iterator().empty();
        }
        if (pathToken instanceof AST.ArrayRandomAccess) {
            AST.ArrayRandomAccess arrayRandomAccess = (AST.ArrayRandomAccess)pathToken;
            List<Object> indices = arrayRandomAccess.indices();
            JsonNodeType jsonNodeType = node.getNodeType();
            JsonNodeType jsonNodeType7 = JsonNodeType.ARRAY;
            return !(jsonNodeType != null ? !jsonNodeType.equals(jsonNodeType7) : jsonNodeType7 != null) ? indices.iterator().collect((PartialFunction)new scala.Serializable(null, node){
                public static final long serialVersionUID = 0L;
                private final JsonNode node$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    switch (A1) {
                        default: 
                    }
                    return (B1)(A1 >= false && A1 < this.node$1.size() ? this.node$1.get(A1) : (A1 < false && A1 >= -this.node$1.size() ? this.node$1.get((int)(A1 + this.node$1.size())) : function1.apply((Object)BoxesRunTime.boxToInteger(x1))));
                }

                public final boolean isDefinedAt(int x1) {
                    int n = x1;
                    switch (n) {
                        default: 
                    }
                    return n >= 0 && n < this.node$1.size() ? true : n < 0 && n >= -this.node$1.size();
                }
                {
                    this.node$1 = node$1;
                }
            }) : scala.package$.MODULE$.Iterator().empty();
        }
        if (pathToken instanceof AST.RecursiveFilterToken) {
            AST.RecursiveFilterToken recursiveFilterToken = (AST.RecursiveFilterToken)pathToken;
            AST.FilterToken filterToken = recursiveFilterToken.filter();
            return new RecursiveDataIterator(node).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> this.applyFilter((JsonNode)x$3, filterToken));
        }
        if (pathToken instanceof AST.FilterToken) {
            AST.FilterToken filterToken = (AST.FilterToken)pathToken;
            return this.applyFilter(node, filterToken);
        }
        if (!AST$RecursiveAnyField$.MODULE$.equals(pathToken)) throw new MatchError((Object)pathToken);
        return new RecursiveNodeIterator(node);
    }

    private Iterator<JsonNode> applyFilter(JsonNode currentNode, AST.FilterToken filterToken) {
        Function1 filterFunction = this.evaluateFilter$1(filterToken);
        return JsonPathWalker.elementsToFilter$1(currentNode).filter(filterFunction);
    }

    private Iterator<JsonNode> sliceArray(JsonNode array, Option<Object> start, Option<Object> stop, int step) {
        int n;
        int n2;
        int size = array.size();
        Option<Object> option = start;
        if (option instanceof Some) {
            Some some = (Some)option;
            int v = BoxesRunTime.unboxToInt((Object)some.value());
            n2 = JsonPathWalker.relative$1(v, size, step);
        } else {
            n2 = 0;
        }
        int absStart = n2;
        Option<Object> option2 = stop;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int v = BoxesRunTime.unboxToInt((Object)some.value());
            n = JsonPathWalker.relative$1(v, size, step);
        } else {
            n = size;
        }
        int absEnd = n;
        int absStep = package$.MODULE$.abs(step);
        Iterator elements = step < 0 ? scala.package$.MODULE$.Iterator().range(array.size() - 1, -1, -1).map((Function1 & Serializable & scala.Serializable)x$1 -> array.get(BoxesRunTime.unboxToInt((Object)x$1))) : (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(array.elements()).asScala();
        Iterator fromStartToEnd = elements.slice(absStart, absEnd);
        return absStep == 1 ? fromStartToEnd : fromStartToEnd.grouped(absStep).map((Function1 & Serializable & scala.Serializable)x$8 -> (JsonNode)x$8.head());
    }

    private final boolean resolveSubQuery$1(JsonNode node, List q, Function1 nextOp) {
        Iterator<JsonNode> it = this.walk(node, (List<AST.PathToken>)q);
        return it.hasNext() && BoxesRunTime.unboxToBoolean((Object)nextOp.apply(it.next()));
    }

    private final boolean applyBinaryOpWithResolvedLeft$1(JsonNode node, ComparisonOperator op, JsonNode lhsNode, AST.FilterValue rhs) {
        boolean bl;
        AST.FilterValue filterValue = rhs;
        if (filterValue instanceof AST.FilterDirectValue) {
            AST.FilterDirectValue filterDirectValue = (AST.FilterDirectValue)filterValue;
            JsonNode valueNode = filterDirectValue.node();
            bl = op.apply(lhsNode, valueNode);
        } else if (filterValue instanceof AST.SubQuery) {
            AST.SubQuery subQuery = (AST.SubQuery)filterValue;
            List<AST.PathToken> q = subQuery.path();
            bl = this.resolveSubQuery$1(node, q, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)op.apply(lhsNode, x$4)));
        } else {
            throw new MatchError((Object)filterValue);
        }
        return bl;
    }

    private final Function1 applyBinaryOp$1(ComparisonOperator op, AST.FilterValue lhs, AST.FilterValue rhs) {
        Function1 & Serializable & scala.Serializable intersect;
        AST.FilterValue filterValue = lhs;
        if (filterValue instanceof AST.FilterDirectValue) {
            AST.FilterDirectValue filterDirectValue = (AST.FilterDirectValue)filterValue;
            JsonNode valueNode = filterDirectValue.node();
            intersect = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)this.applyBinaryOpWithResolvedLeft$1(x$5, op, valueNode, rhs));
        } else if (filterValue instanceof AST.SubQuery) {
            AST.SubQuery subQuery = (AST.SubQuery)filterValue;
            List<AST.PathToken> q = subQuery.path();
            intersect = (Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)this.resolveSubQuery$1(node, q, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$this.applyBinaryOpWithResolvedLeft$1(node, op$2, x$6, rhs$1))));
        } else {
            throw new MatchError((Object)filterValue);
        }
        return intersect;
    }

    private static final Iterator elementsToFilter$1(JsonNode node) {
        JsonNodeType jsonNodeType = node.getNodeType();
        Iterator iterator = JsonNodeType.ARRAY.equals(jsonNodeType) ? (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.elements()).asScala() : (JsonNodeType.OBJECT.equals(jsonNodeType) ? scala.package$.MODULE$.Iterator().single((Object)node) : scala.package$.MODULE$.Iterator().empty());
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$applyFilter$5(JsonPathWalker $this, AST.SubQuery subQuery$1, JsonNode x$7) {
        return $this.walk(x$7, subQuery$1.path()).hasNext();
    }

    private final Function1 evaluateFilter$1(AST.FilterToken filterToken) {
        Function1 & Serializable & scala.Serializable intersect;
        AST.FilterToken filterToken2 = filterToken;
        if (filterToken2 instanceof AST.HasFilter) {
            AST.HasFilter hasFilter = (AST.HasFilter)filterToken2;
            AST.SubQuery subQuery = hasFilter.query();
            intersect = (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JsonPathWalker.$anonfun$applyFilter$5(this, subQuery, x$7));
        } else if (filterToken2 instanceof AST.ComparisonFilter) {
            AST.ComparisonFilter comparisonFilter = (AST.ComparisonFilter)filterToken2;
            ComparisonOperator op = comparisonFilter.operator();
            AST.FilterValue lhs = comparisonFilter.lhs();
            AST.FilterValue rhs = comparisonFilter.rhs();
            intersect = this.applyBinaryOp$1(op, lhs, rhs);
        } else if (filterToken2 instanceof AST.BooleanFilter) {
            AST.BooleanFilter booleanFilter = (AST.BooleanFilter)filterToken2;
            BinaryBooleanOperator op = booleanFilter.operator();
            AST.FilterToken filter1 = booleanFilter.lhs();
            AST.FilterToken filter2 = booleanFilter.rhs();
            Function1 f1 = this.evaluateFilter$1(filter1);
            Function1 f2 = this.evaluateFilter$1(filter2);
            intersect = (Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)op.apply(BoxesRunTime.unboxToBoolean((Object)f1.apply((Object)node)), BoxesRunTime.unboxToBoolean((Object)f2.apply((Object)node))));
        } else {
            throw new MatchError((Object)filterToken2);
        }
        return intersect;
    }

    private static final int lenRelative$1(int x, int size$1) {
        return x >= 0 ? x : size$1 + x;
    }

    private static final int stepRelative$1(int x, int step$1) {
        return step$1 >= 0 ? x : -1 - x;
    }

    private static final int relative$1(int x, int size$1, int step$1) {
        return JsonPathWalker.lenRelative$1(JsonPathWalker.stepRelative$1(x, step$1), size$1);
    }

    public JsonPathWalker(JsonNode rootNode, List<AST.PathToken> fullPath) {
        this.rootNode = rootNode;
        this.fullPath = fullPath;
    }
}

