/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.tar;

import coursierapi.shaded.commonscompress.archivers.ArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.tar.TarArchiveStructSparse;
import coursierapi.shaded.commonscompress.archivers.tar.TarUtils;
import coursierapi.shaded.commonscompress.archivers.zip.ZipEncoding;
import coursierapi.shaded.commonscompress.utils.ArchiveUtils;
import coursierapi.shaded.commonscompress.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TarArchiveEntry
implements ArchiveEntry {
    private static final TarArchiveEntry[] EMPTY_TAR_ARCHIVE_ENTRY_ARRAY = new TarArchiveEntry[0];
    private String name = "";
    private final boolean preserveAbsolutePath;
    private int mode;
    private long userId;
    private long groupId;
    private long size;
    private FileTime mTime;
    private FileTime cTime;
    private FileTime aTime;
    private FileTime birthTime;
    private boolean checkSumOK;
    private byte linkFlag;
    private String linkName = "";
    private String magic = "ustar\u0000";
    private String version = "00";
    private String userName;
    private String groupName = "";
    private int devMajor;
    private int devMinor;
    private List<TarArchiveStructSparse> sparseHeaders;
    private boolean isExtended;
    private long realSize;
    private boolean paxGNUSparse;
    private boolean paxGNU1XSparse;
    private boolean starSparse;
    private final Path file;
    private final LinkOption[] linkOptions;
    private final Map<String, String> extraPaxHeaders = new HashMap<String, String>();
    private long dataOffset = -1L;

    private static FileTime fileTimeFromOptionalSeconds(long seconds) {
        if (seconds <= 0L) {
            return null;
        }
        return FileTime.from(seconds, TimeUnit.SECONDS);
    }

    private static String normalizeFileName(String fileName, boolean preserveAbsolutePath) {
        String property;
        if (!preserveAbsolutePath && (property = System.getProperty("os.name")) != null) {
            int colon2;
            String osName = property.toLowerCase(Locale.ROOT);
            if (osName.startsWith("windows")) {
                if (fileName.length() > 2) {
                    char ch1 = fileName.charAt(0);
                    char ch2 = fileName.charAt(1);
                    if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                        fileName = fileName.substring(2);
                    }
                }
            } else if (osName.contains("netware") && (colon2 = fileName.indexOf(58)) != -1) {
                fileName = fileName.substring(colon2 + 1);
            }
        }
        fileName = fileName.replace(File.separatorChar, '/');
        while (!preserveAbsolutePath && fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private static Instant parseInstantFromDecimalSeconds(String value) {
        BigDecimal epochSeconds = new BigDecimal(value);
        long seconds = epochSeconds.longValue();
        long nanos = epochSeconds.remainder(BigDecimal.ONE).movePointRight(9).longValue();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    private TarArchiveEntry(boolean preserveAbsolutePath) {
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userName = user;
        this.file = null;
        this.linkOptions = IOUtils.EMPTY_LINK_OPTIONS;
        this.preserveAbsolutePath = preserveAbsolutePath;
    }

    public TarArchiveEntry(Map<String, String> globalPaxHeaders, byte[] headerBuf, ZipEncoding encoding, boolean lenient) throws IOException {
        this(false);
        this.parseTarHeader(globalPaxHeaders, headerBuf, encoding, false, lenient);
    }

    public boolean equals(Object it) {
        if (it == null || this.getClass() != it.getClass()) {
            return false;
        }
        return this.equals((TarArchiveEntry)it);
    }

    public boolean equals(TarArchiveEntry it) {
        return it != null && this.getName().equals(it.getName());
    }

    private int evaluateType(Map<String, String> globalPaxHeaders, byte[] header) {
        if (ArchiveUtils.matchAsciiBuffer("ustar ", header, 257, 6)) {
            return 2;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", header, 257, 6)) {
            if (this.isXstar(globalPaxHeaders, header)) {
                return 4;
            }
            return 3;
        }
        return 0;
    }

    void fillGNUSparse0xData(Map<String, String> headers) {
        this.paxGNUSparse = true;
        this.realSize = Integer.parseInt(headers.get("GNU.sparse.size"));
        if (headers.containsKey("GNU.sparse.name")) {
            this.name = headers.get("GNU.sparse.name");
        }
    }

    void fillGNUSparse1xData(Map<String, String> headers) throws IOException {
        this.paxGNUSparse = true;
        this.paxGNU1XSparse = true;
        if (headers.containsKey("GNU.sparse.name")) {
            this.name = headers.get("GNU.sparse.name");
        }
        if (headers.containsKey("GNU.sparse.realsize")) {
            try {
                this.realSize = Integer.parseInt(headers.get("GNU.sparse.realsize"));
            }
            catch (NumberFormatException ex) {
                throw new IOException("Corrupted TAR archive. GNU.sparse.realsize header for " + this.name + " contains non-numeric value");
            }
        }
    }

    void fillStarSparseData(Map<String, String> headers) throws IOException {
        this.starSparse = true;
        if (headers.containsKey("SCHILY.realsize")) {
            try {
                this.realSize = Long.parseLong(headers.get("SCHILY.realsize"));
            }
            catch (NumberFormatException ex) {
                throw new IOException("Corrupted TAR archive. SCHILY.realsize header for " + this.name + " contains non-numeric value");
            }
        }
    }

    public String getLinkName() {
        return this.linkName;
    }

    public int getMode() {
        return this.mode;
    }

    public Date getModTime() {
        return new Date(this.mTime.toMillis());
    }

    public String getName() {
        return this.name;
    }

    public List<TarArchiveStructSparse> getOrderedSparseHeaders() throws IOException {
        TarArchiveStructSparse last;
        if (this.sparseHeaders == null || this.sparseHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        List<TarArchiveStructSparse> orderedAndFiltered = this.sparseHeaders.stream().filter(s -> s.getOffset() > 0L || s.getNumbytes() > 0L).sorted(Comparator.comparingLong(TarArchiveStructSparse::getOffset)).collect(Collectors.toList());
        int numberOfHeaders = orderedAndFiltered.size();
        for (int i = 0; i < numberOfHeaders; ++i) {
            TarArchiveStructSparse str = (TarArchiveStructSparse)orderedAndFiltered.get(i);
            if (i + 1 < numberOfHeaders && str.getOffset() + str.getNumbytes() > orderedAndFiltered.get(i + 1).getOffset()) {
                throw new IOException("Corrupted TAR archive. Sparse blocks for " + this.getName() + " overlap each other.");
            }
            if (str.getOffset() + str.getNumbytes() >= 0L) continue;
            throw new IOException("Unreadable TAR archive. Offset and numbytes for sparse block in " + this.getName() + " too large.");
        }
        if (!orderedAndFiltered.isEmpty() && (last = orderedAndFiltered.get(numberOfHeaders - 1)).getOffset() + last.getNumbytes() > this.getRealSize()) {
            throw new IOException("Corrupted TAR archive. Sparse block extends beyond real size of the entry");
        }
        return orderedAndFiltered;
    }

    public long getRealSize() {
        if (!this.isSparse()) {
            return this.getSize();
        }
        return this.realSize;
    }

    public long getSize() {
        return this.size;
    }

    public List<TarArchiveStructSparse> getSparseHeaders() {
        return this.sparseHeaders;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return Files.isDirectory(this.file, this.linkOptions);
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return !this.isPaxHeader() && !this.isGlobalPaxHeader() && this.getName().endsWith("/");
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public boolean isGlobalPaxHeader() {
        return this.linkFlag == 103;
    }

    public boolean isGNULongLinkEntry() {
        return this.linkFlag == 75;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76;
    }

    public boolean isGNUSparse() {
        return this.isOldGNUSparse() || this.isPaxGNUSparse();
    }

    private boolean isInvalidPrefix(byte[] header) {
        if (header[475] != 0) {
            if (header[156] == 77) {
                if ((header[464] & 0x80) == 0 && header[475] != 32) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isInvalidXtarTime(byte[] buffer, int offset, int length) {
        if ((buffer[offset] & 0x80) == 0) {
            int lastIndex = length - 1;
            for (int i = 0; i < lastIndex; ++i) {
                byte b = buffer[offset + i];
                if (b >= 48 && b <= 55) continue;
                return true;
            }
            byte b = buffer[offset + lastIndex];
            if (b != 32 && b != 0) {
                return true;
            }
        }
        return false;
    }

    public boolean isOldGNUSparse() {
        return this.linkFlag == 83;
    }

    public boolean isPaxGNU1XSparse() {
        return this.paxGNU1XSparse;
    }

    public boolean isPaxGNUSparse() {
        return this.paxGNUSparse;
    }

    public boolean isPaxHeader() {
        return this.linkFlag == 120 || this.linkFlag == 88;
    }

    public boolean isSparse() {
        return this.isGNUSparse() || this.isStarSparse();
    }

    public boolean isStarSparse() {
        return this.starSparse;
    }

    public boolean isSymbolicLink() {
        return this.linkFlag == 50;
    }

    private boolean isXstar(Map<String, String> globalPaxHeaders, byte[] header) {
        if (ArchiveUtils.matchAsciiBuffer("tar\u0000", header, 508, 4)) {
            return true;
        }
        String archType = globalPaxHeaders.get("SCHILY.archtype");
        if (archType != null) {
            return "xustar".equals(archType) || "exustar".equals(archType);
        }
        if (this.isInvalidPrefix(header)) {
            return false;
        }
        if (this.isInvalidXtarTime(header, 476, 12)) {
            return false;
        }
        return !this.isInvalidXtarTime(header, 488, 12);
    }

    private long parseOctalOrBinary(byte[] header, int offset, int length, boolean lenient) {
        if (lenient) {
            try {
                return TarUtils.parseOctalOrBinary(header, offset, length);
            }
            catch (IllegalArgumentException ex) {
                return -1L;
            }
        }
        return TarUtils.parseOctalOrBinary(header, offset, length);
    }

    private void parseTarHeader(Map<String, String> globalPaxHeaders, byte[] header, ZipEncoding encoding, boolean oldStyle, boolean lenient) throws IOException {
        try {
            this.parseTarHeaderUnwrapped(globalPaxHeaders, header, encoding, oldStyle, lenient);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException("Corrupted TAR archive.", ex);
        }
    }

    private void parseTarHeaderUnwrapped(Map<String, String> globalPaxHeaders, byte[] header, ZipEncoding encoding, boolean oldStyle, boolean lenient) throws IOException {
        int offset = 0;
        this.name = oldStyle ? TarUtils.parseName(header, offset, 100) : TarUtils.parseName(header, offset, 100, encoding);
        this.mode = (int)this.parseOctalOrBinary(header, offset += 100, 8, lenient);
        this.userId = (int)this.parseOctalOrBinary(header, offset += 8, 8, lenient);
        this.groupId = (int)this.parseOctalOrBinary(header, offset += 8, 8, lenient);
        this.size = TarUtils.parseOctalOrBinary(header, offset += 8, 12);
        if (this.size < 0L) {
            throw new IOException("broken archive, entry with negative size");
        }
        this.mTime = FileTime.from(this.parseOctalOrBinary(header, offset += 12, 12, lenient), TimeUnit.SECONDS);
        offset += 12;
        this.checkSumOK = TarUtils.verifyCheckSum(header);
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = oldStyle ? TarUtils.parseName(header, offset, 100) : TarUtils.parseName(header, offset, 100, encoding);
        this.magic = TarUtils.parseName(header, offset += 100, 6);
        this.version = TarUtils.parseName(header, offset += 6, 2);
        this.userName = oldStyle ? TarUtils.parseName(header, offset, 32) : TarUtils.parseName(header, offset += 2, 32, encoding);
        this.groupName = oldStyle ? TarUtils.parseName(header, offset, 32) : TarUtils.parseName(header, offset += 32, 32, encoding);
        offset += 32;
        if (this.linkFlag == 51 || this.linkFlag == 52) {
            this.devMajor = (int)this.parseOctalOrBinary(header, offset, 8, lenient);
            this.devMinor = (int)this.parseOctalOrBinary(header, offset += 8, 8, lenient);
            offset += 8;
        } else {
            offset += 16;
        }
        int type = this.evaluateType(globalPaxHeaders, header);
        switch (type) {
            case 2: {
                this.aTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(header, offset, 12, lenient));
                this.cTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(header, offset += 12, 12, lenient));
                offset += 12;
                offset += 12;
                offset += 4;
                this.sparseHeaders = new ArrayList<TarArchiveStructSparse>(TarUtils.readSparseStructs(header, ++offset, 4));
                this.isExtended = TarUtils.parseBoolean(header, offset += 96);
                this.realSize = TarUtils.parseOctal(header, ++offset, 12);
                offset += 12;
                break;
            }
            case 4: {
                String xstarPrefix = oldStyle ? TarUtils.parseName(header, offset, 131) : TarUtils.parseName(header, offset, 131, encoding);
                offset += 131;
                if (!xstarPrefix.isEmpty()) {
                    this.name = xstarPrefix + "/" + this.name;
                }
                this.aTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(header, offset, 12, lenient));
                this.cTime = TarArchiveEntry.fileTimeFromOptionalSeconds(this.parseOctalOrBinary(header, offset += 12, 12, lenient));
                offset += 12;
                break;
            }
            default: {
                String prefix = oldStyle ? TarUtils.parseName(header, offset, 155) : TarUtils.parseName(header, offset, 155, encoding);
                offset += 155;
                if (this.isDirectory() && !this.name.endsWith("/")) {
                    this.name = this.name + "/";
                }
                if (prefix.isEmpty()) break;
                this.name = prefix + "/" + this.name;
            }
        }
    }

    private void processPaxHeader(String key, String val, Map<String, String> headers) throws IOException {
        switch (key) {
            case "path": {
                this.setName(val);
                break;
            }
            case "linkpath": {
                this.setLinkName(val);
                break;
            }
            case "gid": {
                this.setGroupId(Long.parseLong(val));
                break;
            }
            case "gname": {
                this.setGroupName(val);
                break;
            }
            case "uid": {
                this.setUserId(Long.parseLong(val));
                break;
            }
            case "uname": {
                this.setUserName(val);
                break;
            }
            case "size": {
                long size = Long.parseLong(val);
                if (size < 0L) {
                    throw new IOException("Corrupted TAR archive. Entry size is negative");
                }
                this.setSize(size);
                break;
            }
            case "mtime": {
                this.setLastModifiedTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(val)));
                break;
            }
            case "atime": {
                this.setLastAccessTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(val)));
                break;
            }
            case "ctime": {
                this.setStatusChangeTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(val)));
                break;
            }
            case "LIBARCHIVE.creationtime": {
                this.setCreationTime(FileTime.from(TarArchiveEntry.parseInstantFromDecimalSeconds(val)));
                break;
            }
            case "SCHILY.devminor": {
                int devMinor = Integer.parseInt(val);
                if (devMinor < 0) {
                    throw new IOException("Corrupted TAR archive. Dev-Minor is negative");
                }
                this.setDevMinor(devMinor);
                break;
            }
            case "SCHILY.devmajor": {
                int devMajor = Integer.parseInt(val);
                if (devMajor < 0) {
                    throw new IOException("Corrupted TAR archive. Dev-Major is negative");
                }
                this.setDevMajor(devMajor);
                break;
            }
            case "GNU.sparse.size": {
                this.fillGNUSparse0xData(headers);
                break;
            }
            case "GNU.sparse.realsize": {
                this.fillGNUSparse1xData(headers);
                break;
            }
            case "SCHILY.filetype": {
                if (!"sparse".equals(val)) break;
                this.fillStarSparseData(headers);
                break;
            }
            default: {
                this.extraPaxHeaders.put(key, val);
            }
        }
    }

    public void setCreationTime(FileTime time) {
        this.birthTime = time;
    }

    public void setDevMajor(int devNo) {
        if (devNo < 0) {
            throw new IllegalArgumentException("Major device number is out of range: " + devNo);
        }
        this.devMajor = devNo;
    }

    public void setDevMinor(int devNo) {
        if (devNo < 0) {
            throw new IllegalArgumentException("Minor device number is out of range: " + devNo);
        }
        this.devMinor = devNo;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setLastAccessTime(FileTime time) {
        this.aTime = time;
    }

    public void setLastModifiedTime(FileTime time) {
        this.mTime = Objects.requireNonNull(time, "Time must not be null");
    }

    public void setLinkName(String link) {
        this.linkName = link;
    }

    public void setName(String name) {
        this.name = TarArchiveEntry.normalizeFileName(name, this.preserveAbsolutePath);
    }

    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size is out of range: " + size);
        }
        this.size = size;
    }

    public void setSparseHeaders(List<TarArchiveStructSparse> sparseHeaders) {
        this.sparseHeaders = sparseHeaders;
    }

    public void setStatusChangeTime(FileTime time) {
        this.cTime = time;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    void updateEntryFromPaxHeaders(Map<String, String> headers) throws IOException {
        for (Map.Entry<String, String> ent : headers.entrySet()) {
            this.processPaxHeader(ent.getKey(), ent.getValue(), headers);
        }
    }
}

