/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.utils;

public final class ByteUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static long fromLittleEndian(byte[] bytes, int off, int length) {
        ByteUtils.checkReadLength(length);
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l |= ((long)bytes[off + i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public static void toLittleEndian(byte[] b, long value, int off, int length) {
        long num = value;
        for (int i = 0; i < length; ++i) {
            b[off + i] = (byte)(num & 0xFFL);
            num >>= 8;
        }
    }

    private static void checkReadLength(int length) {
        if (length > 8) {
            throw new IllegalArgumentException("Can't read more than eight bytes into a long value");
        }
    }
}

