/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * A modifiable implementation of the {@link MavenExclusion MavenExclusion} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * <p><em>MavenExclusionBean is not thread-safe</em>
 */
@Generated(from = "MavenExclusion", generator = "Modifiables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated({"Modifiables.generator", "MavenExclusion"})
public class MavenExclusionBean
    implements MavenExclusion {
  private static final long INIT_BIT_GROUP_ID = 0x1L;
  private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
  private static final long OPT_BIT_CLASSIFIER = 0x1L;
  private static final long OPT_BIT_TYPE = 0x2L;
  private long initBits = 0x3L;
  private long optBits;

  private String groupId;
  private String artifactId;
  private String classifier;
  private String type;

  /**
   * @return value of {@code groupId} attribute, may be {@code null}
   */
  @Override
  public String getGroupId() {
    if (!groupIdIsSet()) checkRequiredAttributes();
    return groupId;
  }

  /**
   * @return value of {@code artifactId} attribute, may be {@code null}
   */
  @Override
  public String getArtifactId() {
    if (!artifactIdIsSet()) checkRequiredAttributes();
    return artifactId;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code classifier} attribute
   */
  @Override
  public String getClassifier() {
    if (classifierIsSet()) {
      return classifier;
    } else {
      return MavenExclusion.super.getClassifier();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code type} attribute
   */
  @Override
  public String getType() {
    if (typeIsSet()) {
      return type;
    } else {
      return MavenExclusion.super.getType();
    }
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x3L;
    optBits = 0;
    groupId = null;
    artifactId = null;
    classifier = null;
    type = null;
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link MavenExclusion} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public MavenExclusionBean from(MavenExclusion instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof MavenExclusionBean) {
      from((MavenExclusionBean) instance);
      return this;
    }
    String groupIdValue = instance.getGroupId();
    if (groupIdValue != null) {
      setGroupId(groupIdValue);
    }
    String artifactIdValue = instance.getArtifactId();
    if (artifactIdValue != null) {
      setArtifactId(artifactIdValue);
    }
    setClassifier(instance.getClassifier());
    setType(instance.getType());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link MavenExclusion} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public MavenExclusionBean from(MavenExclusionBean instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.groupIdIsSet()) {
      String groupIdValue = instance.getGroupId();
      if (groupIdValue != null) {
        setGroupId(groupIdValue);
      }
    }
    if (instance.artifactIdIsSet()) {
      String artifactIdValue = instance.getArtifactId();
      if (artifactIdValue != null) {
        setArtifactId(artifactIdValue);
      }
    }
    setClassifier(instance.getClassifier());
    setType(instance.getType());
    return this;
  }

  /**
   * Assigns a value to the {@code groupId} attribute.
   * @param groupId The value for groupId, can be {@code null}
   */
  public void setGroupId(String groupId) {
    this.groupId = groupId;
    initBits &= ~INIT_BIT_GROUP_ID;
    return;
  }

  /**
   * Assigns a value to the {@code artifactId} attribute.
   * @param artifactId The value for artifactId, can be {@code null}
   */
  public void setArtifactId(String artifactId) {
    this.artifactId = artifactId;
    initBits &= ~INIT_BIT_ARTIFACT_ID;
    return;
  }

  /**
   * Assigns a value to the {@code classifier} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code classifier}.</em>
   * @param classifier The value for classifier
   */
  public void setClassifier(String classifier) {
    this.classifier = Objects.requireNonNull(classifier, "classifier");
    optBits |= OPT_BIT_CLASSIFIER;
    return;
  }

  /**
   * Assigns a value to the {@code type} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code type}.</em>
   * @param type The value for type
   */
  public void setType(String type) {
    this.type = Objects.requireNonNull(type, "type");
    optBits |= OPT_BIT_TYPE;
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@code groupId} is set.
   * @return {@code true} if set
   */
  public final boolean groupIdIsSet() {
    return (initBits & INIT_BIT_GROUP_ID) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@code artifactId} is set.
   * @return {@code true} if set
   */
  public final boolean artifactIdIsSet() {
    return (initBits & INIT_BIT_ARTIFACT_ID) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code classifier} is set.
   * @return {@code true} if set
   */
  public final boolean classifierIsSet() {
    return (optBits & OPT_BIT_CLASSIFIER) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code type} is set.
   * @return {@code true} if set
   */
  public final boolean typeIsSet() {
    return (optBits & OPT_BIT_TYPE) != 0;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetGroupId() {
    initBits |= INIT_BIT_GROUP_ID;
    groupId = null;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetArtifactId() {
    initBits |= INIT_BIT_ARTIFACT_ID;
    artifactId = null;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetClassifier() {
    optBits |= 0;
    classifier = null;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetType() {
    optBits |= 0;
    type = null;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!groupIdIsSet()) attributes.add("groupId");
    if (!artifactIdIsSet()) attributes.add("artifactId");
    return "MavenExclusion is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * This instance is equal to all instances of {@code MavenExclusionBean} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof MavenExclusionBean)) return false;
    MavenExclusionBean other = (MavenExclusionBean) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(MavenExclusionBean another) {
    String classifier = getClassifier();
    String type = getType();
    return Objects.equals(groupId, another.groupId)
        && Objects.equals(artifactId, another.artifactId)
        && classifier.equals(another.getClassifier())
        && type.equals(another.getType());
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code classifier}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(groupId);
    h += (h << 5) + Objects.hashCode(artifactId);
    String classifier = getClassifier();
    h += (h << 5) + classifier.hashCode();
    String type = getType();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code MavenExclusion}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "MavenExclusionBean{"
        + "groupId=" + getGroupId()
        + ", artifactId=" + getArtifactId()
        + ", classifier=" + getClassifier()
        + ", type=" + getType()
        + "}";
  }
}
