/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.protoc.targets;

import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link PluginProtocTarget}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePluginProtocTarget.builder()}.
 */
@Generated(from = "PluginProtocTarget", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePluginProtocTarget
    implements PluginProtocTarget {
  private final @Nullable ResolvedProtocPlugin plugin;
  private transient final int order;

  private ImmutablePluginProtocTarget(ImmutablePluginProtocTarget.Builder builder) {
    this.plugin = builder.plugin;
    this.order = PluginProtocTarget.super.getOrder();
  }

  /**
   * @return The value of the {@code plugin} attribute
   */
  @Override
  public @Nullable ResolvedProtocPlugin getPlugin() {
    return plugin;
  }

  /**
   * @return The computed-at-construction value of the {@code order} attribute
   */
  @Override
  public int getOrder() {
    return order;
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePluginProtocTarget} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePluginProtocTarget
        && equalsByValue((ImmutablePluginProtocTarget) another);
  }

  private boolean equalsByValue(ImmutablePluginProtocTarget another) {
    return Objects.equals(plugin, another.plugin)
        && order == another.order;
  }

  /**
   * Computes a hash code from attributes: {@code plugin}, {@code order}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(plugin);
    h += (h << 5) + order;
    return h;
  }

  /**
   * Prints the immutable value {@code PluginProtocTarget} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PluginProtocTarget{"
        + "plugin=" + plugin
        + ", order=" + order
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutablePluginProtocTarget ImmutablePluginProtocTarget}.
   * <pre>
   * ImmutablePluginProtocTarget.builder()
   *    .plugin(io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin | null) // nullable {@link PluginProtocTarget#getPlugin() plugin}
   *    .build();
   * </pre>
   * @return A new ImmutablePluginProtocTarget builder
   */
  public static ImmutablePluginProtocTarget.Builder builder() {
    return new ImmutablePluginProtocTarget.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePluginProtocTarget ImmutablePluginProtocTarget}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginProtocTarget", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PLUGIN = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ResolvedProtocPlugin plugin;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PluginProtocTarget} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PluginProtocTarget instance) {
      Objects.requireNonNull(instance, "instance");
      ResolvedProtocPlugin pluginValue = instance.getPlugin();
      if (pluginValue != null) {
        plugin(pluginValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PluginProtocTarget#getPlugin() plugin} attribute.
     * @param plugin The value for plugin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder plugin(ResolvedProtocPlugin plugin) {
      this.plugin = plugin;
      initBits &= ~INIT_BIT_PLUGIN;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePluginProtocTarget ImmutablePluginProtocTarget}.
     * @return An immutable instance of PluginProtocTarget
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePluginProtocTarget build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePluginProtocTarget(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PLUGIN) != 0) attributes.add("plugin");
      return "Cannot build PluginProtocTarget, some of required attributes are not set " + attributes;
    }
  }
}
