/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link IncrementalCache}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIncrementalCache.builder()}.
 */
@Generated(from = "IncrementalCache", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableIncrementalCache
    implements IncrementalCache {
  private final Map<Path, String> protoDependencies;
  private final Map<Path, String> protoSources;
  private final Map<Path, String> descriptorFiles;

  private ImmutableIncrementalCache(ImmutableIncrementalCache.Builder builder) {
    this.protoDependencies = builder.protoDependencies == null ? Collections.<Path, String>emptyMap() : createUnmodifiableMap(false, false, builder.protoDependencies);
    this.protoSources = builder.protoSources == null ? Collections.<Path, String>emptyMap() : createUnmodifiableMap(false, false, builder.protoSources);
    this.descriptorFiles = builder.descriptorFiles == null ? Collections.<Path, String>emptyMap() : createUnmodifiableMap(false, false, builder.descriptorFiles);
  }

  /**
   * @return The value of the {@code protoDependencies} attribute
   */
  @Override
  public Map<Path, String> getProtoDependencies() {
    return protoDependencies;
  }

  /**
   * @return The value of the {@code protoSources} attribute
   */
  @Override
  public Map<Path, String> getProtoSources() {
    return protoSources;
  }

  /**
   * @return The value of the {@code descriptorFiles} attribute
   */
  @Override
  public Map<Path, String> getDescriptorFiles() {
    return descriptorFiles;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIncrementalCache} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIncrementalCache
        && equalsByValue((ImmutableIncrementalCache) another);
  }

  private boolean equalsByValue(ImmutableIncrementalCache another) {
    return protoDependencies.equals(another.protoDependencies)
        && protoSources.equals(another.protoSources)
        && descriptorFiles.equals(another.descriptorFiles);
  }

  /**
   * Computes a hash code from attributes: {@code protoDependencies}, {@code protoSources}, {@code descriptorFiles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + protoDependencies.hashCode();
    h += (h << 5) + protoSources.hashCode();
    h += (h << 5) + descriptorFiles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IncrementalCache} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IncrementalCache{"
        + "protoDependencies=" + protoDependencies
        + ", protoSources=" + protoSources
        + ", descriptorFiles=" + descriptorFiles
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableIncrementalCache ImmutableIncrementalCache}.
   * <pre>
   * ImmutableIncrementalCache.builder()
   *    .putProtoDependencies|putAllProtoDependencies(java.nio.file.Path =&gt; String) // {@link IncrementalCache#getProtoDependencies() protoDependencies} mappings
   *    .putProtoSources|putAllProtoSources(java.nio.file.Path =&gt; String) // {@link IncrementalCache#getProtoSources() protoSources} mappings
   *    .putDescriptorFiles|putAllDescriptorFiles(java.nio.file.Path =&gt; String) // {@link IncrementalCache#getDescriptorFiles() descriptorFiles} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableIncrementalCache builder
   */
  public static ImmutableIncrementalCache.Builder builder() {
    return new ImmutableIncrementalCache.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIncrementalCache ImmutableIncrementalCache}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IncrementalCache", generator = "Immutables")
  public static final class Builder {
    private @Nullable Map<Path, String> protoDependencies = null;
    private @Nullable Map<Path, String> protoSources = null;
    private @Nullable Map<Path, String> descriptorFiles = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IncrementalCache} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IncrementalCache instance) {
      Objects.requireNonNull(instance, "instance");
      putAllProtoDependencies(instance.getProtoDependencies());
      putAllProtoSources(instance.getProtoSources());
      putAllDescriptorFiles(instance.getDescriptorFiles());
      return this;
    }

    /**
     * Put one entry to the {@link IncrementalCache#getProtoDependencies() protoDependencies} map.
     * @param key The key in the protoDependencies map
     * @param value The associated value in the protoDependencies map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProtoDependencies(@Nullable Path key, @Nullable String value) {
      if (this.protoDependencies == null) {
        this.protoDependencies = new LinkedHashMap<Path, String>();
      }
      this.protoDependencies.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link IncrementalCache#getProtoDependencies() protoDependencies} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProtoDependencies(Map.Entry<? extends @Nullable Path, ? extends @Nullable String> entry) {
      if (this.protoDependencies == null) {
        this.protoDependencies = new LinkedHashMap<Path, String>();
      }
      Path k = entry.getKey();
      @Nullable String v = entry.getValue();
      this.protoDependencies.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IncrementalCache#getProtoDependencies() protoDependencies} map. Nulls are not permitted
     * @param entries The entries that will be added to the protoDependencies map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protoDependencies(Map<? extends @Nullable Path, ? extends @Nullable String> entries) {
      this.protoDependencies = new LinkedHashMap<Path, String>();
      return putAllProtoDependencies(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IncrementalCache#getProtoDependencies() protoDependencies} map. Nulls are not permitted
     * @param entries The entries that will be added to the protoDependencies map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProtoDependencies(Map<? extends @Nullable Path, ? extends @Nullable String> entries) {
      if (this.protoDependencies == null) {
        this.protoDependencies = new LinkedHashMap<Path, String>();
      }
      for (Map.Entry<? extends @Nullable Path, ? extends @Nullable String> e : entries.entrySet()) {
        Path k = e.getKey();
        @Nullable String v = e.getValue();
        this.protoDependencies.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link IncrementalCache#getProtoSources() protoSources} map.
     * @param key The key in the protoSources map
     * @param value The associated value in the protoSources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProtoSources(@Nullable Path key, @Nullable String value) {
      if (this.protoSources == null) {
        this.protoSources = new LinkedHashMap<Path, String>();
      }
      this.protoSources.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link IncrementalCache#getProtoSources() protoSources} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProtoSources(Map.Entry<? extends @Nullable Path, ? extends @Nullable String> entry) {
      if (this.protoSources == null) {
        this.protoSources = new LinkedHashMap<Path, String>();
      }
      Path k = entry.getKey();
      @Nullable String v = entry.getValue();
      this.protoSources.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IncrementalCache#getProtoSources() protoSources} map. Nulls are not permitted
     * @param entries The entries that will be added to the protoSources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protoSources(Map<? extends @Nullable Path, ? extends @Nullable String> entries) {
      this.protoSources = new LinkedHashMap<Path, String>();
      return putAllProtoSources(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IncrementalCache#getProtoSources() protoSources} map. Nulls are not permitted
     * @param entries The entries that will be added to the protoSources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProtoSources(Map<? extends @Nullable Path, ? extends @Nullable String> entries) {
      if (this.protoSources == null) {
        this.protoSources = new LinkedHashMap<Path, String>();
      }
      for (Map.Entry<? extends @Nullable Path, ? extends @Nullable String> e : entries.entrySet()) {
        Path k = e.getKey();
        @Nullable String v = e.getValue();
        this.protoSources.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link IncrementalCache#getDescriptorFiles() descriptorFiles} map.
     * @param key The key in the descriptorFiles map
     * @param value The associated value in the descriptorFiles map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putDescriptorFiles(@Nullable Path key, @Nullable String value) {
      if (this.descriptorFiles == null) {
        this.descriptorFiles = new LinkedHashMap<Path, String>();
      }
      this.descriptorFiles.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link IncrementalCache#getDescriptorFiles() descriptorFiles} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putDescriptorFiles(Map.Entry<? extends @Nullable Path, ? extends @Nullable String> entry) {
      if (this.descriptorFiles == null) {
        this.descriptorFiles = new LinkedHashMap<Path, String>();
      }
      Path k = entry.getKey();
      @Nullable String v = entry.getValue();
      this.descriptorFiles.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IncrementalCache#getDescriptorFiles() descriptorFiles} map. Nulls are not permitted
     * @param entries The entries that will be added to the descriptorFiles map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descriptorFiles(Map<? extends @Nullable Path, ? extends @Nullable String> entries) {
      this.descriptorFiles = new LinkedHashMap<Path, String>();
      return putAllDescriptorFiles(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IncrementalCache#getDescriptorFiles() descriptorFiles} map. Nulls are not permitted
     * @param entries The entries that will be added to the descriptorFiles map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllDescriptorFiles(Map<? extends @Nullable Path, ? extends @Nullable String> entries) {
      if (this.descriptorFiles == null) {
        this.descriptorFiles = new LinkedHashMap<Path, String>();
      }
      for (Map.Entry<? extends @Nullable Path, ? extends @Nullable String> e : entries.entrySet()) {
        Path k = e.getKey();
        @Nullable String v = e.getValue();
        this.descriptorFiles.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableIncrementalCache ImmutableIncrementalCache}.
     * @return An immutable instance of IncrementalCache
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIncrementalCache build() {
      return new ImmutableIncrementalCache(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
