/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.sources.DescriptorListing;
import io.github.ascopes.protobufmavenplugin.sources.ImmutableFilesToCompile;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public interface FilesToCompile {
    public Collection<Path> getProtoSources();

    public Collection<String> getDescriptorFiles();

    @Value.Derived
    default public boolean isEmpty() {
        return this.getProtoSources().isEmpty() && this.getDescriptorFiles().isEmpty();
    }

    public static FilesToCompile allOf(ProjectInputListing listing) {
        return ImmutableFilesToCompile.builder().descriptorFiles(DescriptorListing.flatten(listing.getCompilableDescriptorFiles())).protoSources(SourceListing.flatten(listing.getCompilableProtoSources())).build();
    }

    public static FilesToCompile empty() {
        return ImmutableFilesToCompile.builder().descriptorFiles(List.of()).protoSources(List.of()).build();
    }
}

