/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link SourceListing}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSourceListing.builder()}.
 */
@Generated(from = "SourceListing", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSourceListing
    implements SourceListing {
  private final @Nullable Path sourceRoot;
  private final Set<Path> sourceFiles;

  private ImmutableSourceListing(ImmutableSourceListing.Builder builder) {
    this.sourceRoot = builder.sourceRoot;
    this.sourceFiles = builder.sourceFiles == null ? Collections.<Path>emptySet() : createUnmodifiableSet(builder.sourceFiles);
  }

  /**
   * @return The value of the {@code sourceRoot} attribute
   */
  @Override
  public @Nullable Path getSourceRoot() {
    return sourceRoot;
  }

  /**
   * @return The value of the {@code sourceFiles} attribute
   */
  @Override
  public Set<Path> getSourceFiles() {
    return sourceFiles;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSourceListing} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSourceListing
        && equalsByValue((ImmutableSourceListing) another);
  }

  private boolean equalsByValue(ImmutableSourceListing another) {
    return Objects.equals(sourceRoot, another.sourceRoot)
        && sourceFiles.equals(another.sourceFiles);
  }

  /**
   * Computes a hash code from attributes: {@code sourceRoot}, {@code sourceFiles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(sourceRoot);
    h += (h << 5) + sourceFiles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SourceListing} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SourceListing{"
        + "sourceRoot=" + sourceRoot
        + ", sourceFiles=" + sourceFiles
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableSourceListing ImmutableSourceListing}.
   * <pre>
   * ImmutableSourceListing.builder()
   *    .sourceRoot(java.nio.file.Path | null) // nullable {@link SourceListing#getSourceRoot() sourceRoot}
   *    .addSourceFiles|addAllSourceFiles(java.nio.file.Path) // {@link SourceListing#getSourceFiles() sourceFiles} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSourceListing builder
   */
  public static ImmutableSourceListing.Builder builder() {
    return new ImmutableSourceListing.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSourceListing ImmutableSourceListing}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SourceListing", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SOURCE_ROOT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Path sourceRoot;
    private @Nullable List<Path> sourceFiles = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SourceListing} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SourceListing instance) {
      Objects.requireNonNull(instance, "instance");
      Path sourceRootValue = instance.getSourceRoot();
      if (sourceRootValue != null) {
        sourceRoot(sourceRootValue);
      }
      addAllSourceFiles(instance.getSourceFiles());
      return this;
    }

    /**
     * Initializes the value for the {@link SourceListing#getSourceRoot() sourceRoot} attribute.
     * @param sourceRoot The value for sourceRoot (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceRoot(Path sourceRoot) {
      this.sourceRoot = sourceRoot;
      initBits &= ~INIT_BIT_SOURCE_ROOT;
      return this;
    }

    /**
     * Adds one element to {@link SourceListing#getSourceFiles() sourceFiles} set.
     * @param element A sourceFiles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourceFiles(@Nullable Path element) {
      if (this.sourceFiles == null) {
        this.sourceFiles = new ArrayList<Path>();
      }
      this.sourceFiles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SourceListing#getSourceFiles() sourceFiles} set.
     * @param elements An array of sourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourceFiles(@Nullable Path... elements) {
      if (this.sourceFiles == null) {
        this.sourceFiles = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.sourceFiles.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SourceListing#getSourceFiles() sourceFiles} set.
     * @param elements An iterable of sourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceFiles(Iterable<? extends @Nullable Path> elements) {
      this.sourceFiles = new ArrayList<Path>();
      return addAllSourceFiles(elements);
    }

    /**
     * Adds elements to {@link SourceListing#getSourceFiles() sourceFiles} set.
     * @param elements An iterable of sourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSourceFiles(Iterable<? extends @Nullable Path> elements) {
      Objects.requireNonNull(elements, "sourceFiles element");
      if (this.sourceFiles == null) {
        this.sourceFiles = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.sourceFiles.add(element);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSourceListing ImmutableSourceListing}.
     * @return An immutable instance of SourceListing
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSourceListing build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSourceListing(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE_ROOT) != 0) attributes.add("sourceRoot");
      return "Cannot build SourceListing, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
