/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * A modifiable implementation of the {@link PathProtocPlugin PathProtocPlugin} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * <p><em>PathProtocPluginBean is not thread-safe</em>
 */
@Generated(from = "PathProtocPlugin", generator = "Modifiables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated({"Modifiables.generator", "PathProtocPlugin"})
public class PathProtocPluginBean extends PathProtocPlugin {
  private static final long INIT_BIT_NAME = 0x1L;
  private static final long OPT_BIT_ORDER = 0x1L;
  private static final long OPT_BIT_SKIP = 0x2L;
  private static final long OPT_BIT_OPTIONAL = 0x4L;
  private long initBits = 0x1L;
  private long optBits;

  private @Nullable String options;
  private @Nullable Path outputDirectory;
  private @Nullable Boolean registerAsCompilationRoot;
  private int order;
  private boolean skip;
  private boolean optional;
  private String name;

  /**
   * @return value of {@code options} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getOptions() {
    return options;
  }

  /**
   * @return value of {@code outputDirectory} attribute, may be {@code null}
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * @return value of {@code registerAsCompilationRoot} attribute, may be {@code null}
   */
  @Override
  public @Nullable Boolean isRegisterAsCompilationRoot() {
    return registerAsCompilationRoot;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code order} attribute
   */
  @Override
  public int getOrder() {
    if (orderIsSet()) {
      return order;
    } else {
      return super.getOrder();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code skip} attribute
   */
  @Override
  public boolean isSkip() {
    if (skipIsSet()) {
      return skip;
    } else {
      return super.isSkip();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code optional} attribute
   */
  @Override
  public boolean isOptional() {
    if (optionalIsSet()) {
      return optional;
    } else {
      return super.isOptional();
    }
  }

  /**
   * @return value of {@code name} attribute, may be {@code null}
   */
  @Override
  public String getName() {
    if (!nameIsSet()) checkRequiredAttributes();
    return name;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x1L;
    optBits = 0;
    options = null;
    outputDirectory = null;
    registerAsCompilationRoot = null;
    order = 0;
    skip = false;
    optional = false;
    name = null;
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.OptionalProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public PathProtocPluginBean from(OptionalProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public PathProtocPluginBean from(ProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public PathProtocPluginBean from(PathProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link PathProtocPlugin} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public PathProtocPluginBean from(PathProtocPluginBean instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof PathProtocPluginBean) {
      PathProtocPluginBean instance = (PathProtocPluginBean) object;
      @Nullable String optionsValue = instance.getOptions();
      if (optionsValue != null) {
        setOptions(optionsValue);
      }
      @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        setOutputDirectory(outputDirectoryValue);
      }
      @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
      if (registerAsCompilationRootValue != null) {
        setRegisterAsCompilationRoot(registerAsCompilationRootValue);
      }
      setOrder(instance.getOrder());
      setSkip(instance.isSkip());
      setOptional(instance.isOptional());
      if (instance.nameIsSet()) {
        String nameValue = instance.getName();
        if (nameValue != null) {
          setName(nameValue);
        }
      }
      return;
    }
    long bits = 0;
    if (object instanceof OptionalProtocPlugin) {
      OptionalProtocPlugin instance = (OptionalProtocPlugin) object;
      if ((bits & 0x2L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x2L;
      }
      if ((bits & 0x4L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x4L;
      }
      if ((bits & 0x8L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x8L;
      }
      if ((bits & 0x10L) == 0) {
        setOptional(instance.isOptional());
        bits |= 0x10L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x20L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x20L;
      }
    }
    if (object instanceof ProtocPlugin) {
      ProtocPlugin instance = (ProtocPlugin) object;
      if ((bits & 0x2L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x2L;
      }
      if ((bits & 0x4L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x4L;
      }
      if ((bits & 0x8L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x8L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x20L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x20L;
      }
    }
    if (object instanceof PathProtocPlugin) {
      PathProtocPlugin instance = (PathProtocPlugin) object;
      String nameValue = instance.getName();
      if (nameValue != null) {
        setName(nameValue);
      }
      if ((bits & 0x10L) == 0) {
        setOptional(instance.isOptional());
        bits |= 0x10L;
      }
    }
  }

  /**
   * Assigns a value to the {@code options} attribute.
   * @param options The value for options, can be {@code null}
   */
  public void setOptions(@Nullable String options) {
    this.options = options;
    return;
  }

  /**
   * Assigns a value to the {@code outputDirectory} attribute.
   * @param outputDirectory The value for outputDirectory, can be {@code null}
   */
  public void setOutputDirectory(@Nullable Path outputDirectory) {
    this.outputDirectory = outputDirectory;
    return;
  }

  /**
   * Assigns a value to the {@code registerAsCompilationRoot} attribute.
   * @param registerAsCompilationRoot The value for registerAsCompilationRoot, can be {@code null}
   */
  public void setRegisterAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
    this.registerAsCompilationRoot = registerAsCompilationRoot;
    return;
  }

  /**
   * Assigns a value to the {@code order} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code order}.</em>
   * @param order The value for order
   */
  public void setOrder(int order) {
    this.order = order;
    optBits |= OPT_BIT_ORDER;
    return;
  }

  /**
   * Assigns a value to the {@code skip} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code skip}.</em>
   * @param skip The value for skip
   */
  public void setSkip(boolean skip) {
    this.skip = skip;
    optBits |= OPT_BIT_SKIP;
    return;
  }

  /**
   * Assigns a value to the {@code optional} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@code optional}.</em>
   * @param optional The value for optional
   */
  public void setOptional(boolean optional) {
    this.optional = optional;
    optBits |= OPT_BIT_OPTIONAL;
    return;
  }

  /**
   * Assigns a value to the {@code name} attribute.
   * @param name The value for name, can be {@code null}
   */
  public void setName(String name) {
    this.name = name;
    initBits &= ~INIT_BIT_NAME;
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@code name} is set.
   * @return {@code true} if set
   */
  public final boolean nameIsSet() {
    return (initBits & INIT_BIT_NAME) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code order} is set.
   * @return {@code true} if set
   */
  public final boolean orderIsSet() {
    return (optBits & OPT_BIT_ORDER) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code skip} is set.
   * @return {@code true} if set
   */
  public final boolean skipIsSet() {
    return (optBits & OPT_BIT_SKIP) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@code optional} is set.
   * @return {@code true} if set
   */
  public final boolean optionalIsSet() {
    return (optBits & OPT_BIT_OPTIONAL) != 0;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetName() {
    initBits |= INIT_BIT_NAME;
    name = null;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetOrder() {
    optBits &= ~OPT_BIT_ORDER;
    order = 0;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetSkip() {
    optBits &= ~OPT_BIT_SKIP;
    skip = false;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetOptional() {
    optBits &= ~OPT_BIT_OPTIONAL;
    optional = false;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!nameIsSet()) attributes.add("name");
    return "PathProtocPlugin is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * This instance is equal to all instances of {@code PathProtocPluginBean} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof PathProtocPluginBean)) return false;
    PathProtocPluginBean other = (PathProtocPluginBean) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(PathProtocPluginBean another) {
    int order = getOrder();
    boolean skip = isSkip();
    boolean optional = isOptional();
    return Objects.equals(options, another.options)
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(registerAsCompilationRoot, another.registerAsCompilationRoot)
        && order == another.getOrder()
        && skip == another.isSkip()
        && optional == another.isOptional()
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code options}, {@code outputDirectory}, {@code registerAsCompilationRoot}, {@code order}, {@code skip}, {@code optional}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(registerAsCompilationRoot);
    int order = getOrder();
    h += (h << 5) + order;
    boolean skip = isSkip();
    h += (h << 5) + Boolean.hashCode(skip);
    boolean optional = isOptional();
    h += (h << 5) + Boolean.hashCode(optional);
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }
}
