/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link ProjectInputListing}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectInputListing.builder()}.
 */
@Generated(from = "ProjectInputListing", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableProjectInputListing
    implements ProjectInputListing {
  private final @Nullable Collection<SourceListing> compilableProtoSources;
  private final @Nullable Collection<SourceListing> dependencyProtoSources;
  private final @Nullable Collection<DescriptorListing> compilableDescriptorFiles;

  private ImmutableProjectInputListing(ImmutableProjectInputListing.Builder builder) {
    this.compilableProtoSources = builder.compilableProtoSources;
    this.dependencyProtoSources = builder.dependencyProtoSources;
    this.compilableDescriptorFiles = builder.compilableDescriptorFiles;
  }

  /**
   * @return The value of the {@code compilableProtoSources} attribute
   */
  @Override
  public @Nullable Collection<SourceListing> getCompilableProtoSources() {
    return compilableProtoSources;
  }

  /**
   * @return The value of the {@code dependencyProtoSources} attribute
   */
  @Override
  public @Nullable Collection<SourceListing> getDependencyProtoSources() {
    return dependencyProtoSources;
  }

  /**
   * @return The value of the {@code compilableDescriptorFiles} attribute
   */
  @Override
  public @Nullable Collection<DescriptorListing> getCompilableDescriptorFiles() {
    return compilableDescriptorFiles;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectInputListing} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectInputListing
        && equalsByValue((ImmutableProjectInputListing) another);
  }

  private boolean equalsByValue(ImmutableProjectInputListing another) {
    return Objects.equals(compilableProtoSources, another.compilableProtoSources)
        && Objects.equals(dependencyProtoSources, another.dependencyProtoSources)
        && Objects.equals(compilableDescriptorFiles, another.compilableDescriptorFiles);
  }

  /**
   * Computes a hash code from attributes: {@code compilableProtoSources}, {@code dependencyProtoSources}, {@code compilableDescriptorFiles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(compilableProtoSources);
    h += (h << 5) + Objects.hashCode(dependencyProtoSources);
    h += (h << 5) + Objects.hashCode(compilableDescriptorFiles);
    return h;
  }

  /**
   * Prints the immutable value {@code ProjectInputListing} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProjectInputListing{"
        + "compilableProtoSources=" + compilableProtoSources
        + ", dependencyProtoSources=" + dependencyProtoSources
        + ", compilableDescriptorFiles=" + compilableDescriptorFiles
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableProjectInputListing ImmutableProjectInputListing}.
   * <pre>
   * ImmutableProjectInputListing.builder()
   *    .compilableProtoSources(Collection&lt;io.github.ascopes.protobufmavenplugin.sources.SourceListing&gt; | null) // nullable {@link ProjectInputListing#getCompilableProtoSources() compilableProtoSources}
   *    .dependencyProtoSources(Collection&lt;io.github.ascopes.protobufmavenplugin.sources.SourceListing&gt; | null) // nullable {@link ProjectInputListing#getDependencyProtoSources() dependencyProtoSources}
   *    .compilableDescriptorFiles(Collection&lt;io.github.ascopes.protobufmavenplugin.sources.DescriptorListing&gt; | null) // nullable {@link ProjectInputListing#getCompilableDescriptorFiles() compilableDescriptorFiles}
   *    .build();
   * </pre>
   * @return A new ImmutableProjectInputListing builder
   */
  public static ImmutableProjectInputListing.Builder builder() {
    return new ImmutableProjectInputListing.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectInputListing ImmutableProjectInputListing}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProjectInputListing", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_COMPILABLE_PROTO_SOURCES = 0x1L;
    private static final long INIT_BIT_DEPENDENCY_PROTO_SOURCES = 0x2L;
    private static final long INIT_BIT_COMPILABLE_DESCRIPTOR_FILES = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Collection<SourceListing> compilableProtoSources;
    private @Nullable Collection<SourceListing> dependencyProtoSources;
    private @Nullable Collection<DescriptorListing> compilableDescriptorFiles;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectInputListing} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProjectInputListing instance) {
      Objects.requireNonNull(instance, "instance");
      Collection<SourceListing> compilableProtoSourcesValue = instance.getCompilableProtoSources();
      if (compilableProtoSourcesValue != null) {
        compilableProtoSources(compilableProtoSourcesValue);
      }
      Collection<SourceListing> dependencyProtoSourcesValue = instance.getDependencyProtoSources();
      if (dependencyProtoSourcesValue != null) {
        dependencyProtoSources(dependencyProtoSourcesValue);
      }
      Collection<DescriptorListing> compilableDescriptorFilesValue = instance.getCompilableDescriptorFiles();
      if (compilableDescriptorFilesValue != null) {
        compilableDescriptorFiles(compilableDescriptorFilesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectInputListing#getCompilableProtoSources() compilableProtoSources} attribute.
     * @param compilableProtoSources The value for compilableProtoSources (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder compilableProtoSources(Collection<SourceListing> compilableProtoSources) {
      this.compilableProtoSources = compilableProtoSources;
      initBits &= ~INIT_BIT_COMPILABLE_PROTO_SOURCES;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectInputListing#getDependencyProtoSources() dependencyProtoSources} attribute.
     * @param dependencyProtoSources The value for dependencyProtoSources (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dependencyProtoSources(Collection<SourceListing> dependencyProtoSources) {
      this.dependencyProtoSources = dependencyProtoSources;
      initBits &= ~INIT_BIT_DEPENDENCY_PROTO_SOURCES;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectInputListing#getCompilableDescriptorFiles() compilableDescriptorFiles} attribute.
     * @param compilableDescriptorFiles The value for compilableDescriptorFiles (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder compilableDescriptorFiles(Collection<DescriptorListing> compilableDescriptorFiles) {
      this.compilableDescriptorFiles = compilableDescriptorFiles;
      initBits &= ~INIT_BIT_COMPILABLE_DESCRIPTOR_FILES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectInputListing ImmutableProjectInputListing}.
     * @return An immutable instance of ProjectInputListing
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectInputListing build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectInputListing(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMPILABLE_PROTO_SOURCES) != 0) attributes.add("compilableProtoSources");
      if ((initBits & INIT_BIT_DEPENDENCY_PROTO_SOURCES) != 0) attributes.add("dependencyProtoSources");
      if ((initBits & INIT_BIT_COMPILABLE_DESCRIPTOR_FILES) != 0) attributes.add("compilableDescriptorFiles");
      return "Cannot build ProjectInputListing, some of required attributes are not set " + attributes;
    }
  }
}
