/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plexus;

import io.github.ascopes.protobufmavenplugin.plexus.KindHint;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
final class SealedTypePlexusConverter
extends AbstractBasicConverter {
    private static final Logger log = LoggerFactory.getLogger(SealedTypePlexusConverter.class);
    private final Map<Class<?>, Map<String, Class<?>>> kindMappings = Collections.synchronizedMap(new WeakHashMap());

    SealedTypePlexusConverter() {
    }

    public boolean canConvert(Class<?> type) {
        return Optional.of(type).filter(Class::isSealed).map(Class::getPermittedSubclasses).map(List::of).filter(Predicate.not(List::isEmpty)).isPresent();
    }

    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, @Nullable Class<?> enclosingType, @Nullable ClassLoader loader, ExpressionEvaluator evaluator, @Nullable ConfigurationListener listener) throws ComponentConfigurationException {
        String kind = Optional.ofNullable(configuration.getAttribute("kind")).filter(Predicate.not(String::isEmpty)).orElseThrow(() -> new ComponentConfigurationException(configuration, "Missing \"kind\" attribute. Valid kinds are: " + this.getValidKindsFor(type)));
        Class impl = Optional.of(this.getKindMappingFor(type)).map(mapping -> (Class)mapping.get(kind)).orElseThrow(() -> new ComponentConfigurationException(configuration, "Invalid kind \"" + kind + "\" specified. Valid kinds are: " + this.getValidKindsFor(type)));
        return lookup.lookupConverterForType(impl).fromConfiguration(lookup, configuration, impl, impl.getEnclosingClass(), impl.getClassLoader(), evaluator, listener);
    }

    private String getValidKindsFor(Class<?> base) {
        return this.getKindMappingFor(base).keySet().stream().map(kind -> "\"" + kind + "\"").sorted().collect(Collectors.joining(", "));
    }

    private Map<String, Class<?>> getKindMappingFor(Class<?> base) {
        return this.kindMappings.computeIfAbsent(base, SealedTypePlexusConverter::computeKindMappingFor);
    }

    private static Map<String, Class<?>> computeKindMappingFor(Class<?> base) {
        HashMap mapping = new HashMap();
        ArrayDeque queue = new ArrayDeque();
        queue.push(base);
        while (!queue.isEmpty()) {
            Class next = (Class)queue.removeFirst();
            if (next.isSealed()) {
                log.trace("Found sealed type \"{}\" (base is \"{}\"), adding children to queue", (Object)base.getName(), (Object)next.getName());
                for (Class<?> permittedSubtype : next.getPermittedSubclasses()) {
                    queue.push(permittedSubtype);
                }
                continue;
            }
            KindHint kind = next.getAnnotation(KindHint.class);
            if (kind == null) continue;
            log.trace("Found concrete kind for base \"{}\": \"{}\" will map to \"{}\"", new Object[]{base.getName(), kind.kind(), kind.implementation().getName()});
            mapping.put(kind.kind(), kind.implementation());
        }
        return Collections.unmodifiableMap(mapping);
    }
}

