/*
 * Copyright (C) 2023 Ashley Scopes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.java;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link JavaApp}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJavaApp.builder()}.
 */
@Generated(from = "JavaApp", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaApp implements JavaApp {
  private final @Nullable String uniqueName;
  private final List<Path> dependencies;
  private final @Nullable List<String> jvmArgs;
  private final @Nullable List<String> jvmConfigArgs;
  private final @Nullable String mainClass;

  private ImmutableJavaApp(ImmutableJavaApp.Builder builder) {
    this.uniqueName = builder.uniqueName;
    this.dependencies = builder.dependencies == null ? Collections.<Path>emptyList() : createUnmodifiableList(true, builder.dependencies);
    this.jvmArgs = builder.jvmArgs == null ? null : createUnmodifiableList(true, builder.jvmArgs);
    this.jvmConfigArgs = builder.jvmConfigArgs == null ? null : createUnmodifiableList(true, builder.jvmConfigArgs);
    this.mainClass = builder.mainClass;
  }

  /**
   * @return The value of the {@code uniqueName} attribute
   */
  @Override
  public @Nullable String getUniqueName() {
    return uniqueName;
  }

  /**
   * @return The value of the {@code dependencies} attribute
   */
  @Override
  public List<Path> getDependencies() {
    return dependencies;
  }

  /**
   * @return The value of the {@code jvmArgs} attribute
   */
  @Override
  public @Nullable List<String> getJvmArgs() {
    return jvmArgs;
  }

  /**
   * @return The value of the {@code jvmConfigArgs} attribute
   */
  @Override
  public @Nullable List<String> getJvmConfigArgs() {
    return jvmConfigArgs;
  }

  /**
   * @return The value of the {@code mainClass} attribute
   */
  @Override
  public @Nullable String getMainClass() {
    return mainClass;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaApp} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaApp
        && equalsByValue((ImmutableJavaApp) another);
  }

  private boolean equalsByValue(ImmutableJavaApp another) {
    return Objects.equals(uniqueName, another.uniqueName)
        && dependencies.equals(another.dependencies)
        && Objects.equals(jvmArgs, another.jvmArgs)
        && Objects.equals(jvmConfigArgs, another.jvmConfigArgs)
        && Objects.equals(mainClass, another.mainClass);
  }

  /**
   * Computes a hash code from attributes: {@code uniqueName}, {@code dependencies}, {@code jvmArgs}, {@code jvmConfigArgs}, {@code mainClass}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(uniqueName);
    h += (h << 5) + dependencies.hashCode();
    h += (h << 5) + Objects.hashCode(jvmArgs);
    h += (h << 5) + Objects.hashCode(jvmConfigArgs);
    h += (h << 5) + Objects.hashCode(mainClass);
    return h;
  }

  /**
   * Prints the immutable value {@code JavaApp} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaApp{"
        + "uniqueName=" + uniqueName
        + ", dependencies=" + dependencies
        + ", jvmArgs=" + jvmArgs
        + ", jvmConfigArgs=" + jvmConfigArgs
        + ", mainClass=" + mainClass
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableJavaApp ImmutableJavaApp}.
   * <pre>
   * ImmutableJavaApp.builder()
   *    .uniqueName(String | null) // nullable {@link JavaApp#getUniqueName() uniqueName}
   *    .addDependencies|addAllDependencies(java.nio.file.Path) // {@link JavaApp#getDependencies() dependencies} elements
   *    .jvmArgs(List&lt;String&gt; | null) // nullable {@link JavaApp#getJvmArgs() jvmArgs}
   *    .jvmConfigArgs(List&lt;String&gt; | null) // nullable {@link JavaApp#getJvmConfigArgs() jvmConfigArgs}
   *    .mainClass(String | null) // nullable {@link JavaApp#getMainClass() mainClass}
   *    .build();
   * </pre>
   * @return A new ImmutableJavaApp builder
   */
  public static ImmutableJavaApp.Builder builder() {
    return new ImmutableJavaApp.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJavaApp ImmutableJavaApp}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaApp", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_UNIQUE_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String uniqueName;
    private @Nullable List<Path> dependencies = null;
    private @Nullable List<String> jvmArgs = null;
    private @Nullable List<String> jvmConfigArgs = null;
    private @Nullable String mainClass;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavaApp} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JavaApp instance) {
      Objects.requireNonNull(instance, "instance");
      String uniqueNameValue = instance.getUniqueName();
      if (uniqueNameValue != null) {
        uniqueName(uniqueNameValue);
      }
      addAllDependencies(instance.getDependencies());
      @Nullable List<String> jvmArgsValue = instance.getJvmArgs();
      if (jvmArgsValue != null) {
        addAllJvmArgs(jvmArgsValue);
      }
      @Nullable List<String> jvmConfigArgsValue = instance.getJvmConfigArgs();
      if (jvmConfigArgsValue != null) {
        addAllJvmConfigArgs(jvmConfigArgsValue);
      }
      @Nullable String mainClassValue = instance.getMainClass();
      if (mainClassValue != null) {
        mainClass(mainClassValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JavaApp#getUniqueName() uniqueName} attribute.
     * @param uniqueName The value for uniqueName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uniqueName(String uniqueName) {
      this.uniqueName = uniqueName;
      initBits &= ~INIT_BIT_UNIQUE_NAME;
      return this;
    }

    /**
     * Adds one element to {@link JavaApp#getDependencies() dependencies} list.
     * @param element A dependencies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDependencies(@Nullable Path element) {
      if (this.dependencies == null) {
        this.dependencies = new ArrayList<Path>();
      }
      this.dependencies.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JavaApp#getDependencies() dependencies} list.
     * @param elements An array of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDependencies(@Nullable Path... elements) {
      if (this.dependencies == null) {
        this.dependencies = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.dependencies.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JavaApp#getDependencies() dependencies} list.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dependencies(Iterable<? extends @Nullable Path> elements) {
      this.dependencies = new ArrayList<Path>();
      return addAllDependencies(elements);
    }

    /**
     * Adds elements to {@link JavaApp#getDependencies() dependencies} list.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDependencies(Iterable<? extends @Nullable Path> elements) {
      Objects.requireNonNull(elements, "dependencies element");
      if (this.dependencies == null) {
        this.dependencies = new ArrayList<Path>();
      }
      for (Path element : elements) {
        this.dependencies.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link JavaApp#getJvmArgs() jvmArgs} list.
     * @param element A jvmArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmArgs(@Nullable String element) {
      if (this.jvmArgs == null) {
        this.jvmArgs = new ArrayList<String>();
      }
      this.jvmArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JavaApp#getJvmArgs() jvmArgs} list.
     * @param elements An array of jvmArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmArgs(@Nullable String... elements) {
      if (this.jvmArgs == null) {
        this.jvmArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmArgs.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JavaApp#getJvmArgs() jvmArgs} list.
     * @param elements An iterable of jvmArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jvmArgs(@Nullable Iterable<@Nullable String> elements) {
      if (elements == null) {
        this.jvmArgs = null;
        return this;
      }
      this.jvmArgs = new ArrayList<String>();
      return addAllJvmArgs(elements);
    }

    /**
     * Adds elements to {@link JavaApp#getJvmArgs() jvmArgs} list.
     * @param elements An iterable of jvmArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJvmArgs(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "jvmArgs element");
      if (this.jvmArgs == null) {
        this.jvmArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmArgs.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link JavaApp#getJvmConfigArgs() jvmConfigArgs} list.
     * @param element A jvmConfigArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmConfigArgs(@Nullable String element) {
      if (this.jvmConfigArgs == null) {
        this.jvmConfigArgs = new ArrayList<String>();
      }
      this.jvmConfigArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JavaApp#getJvmConfigArgs() jvmConfigArgs} list.
     * @param elements An array of jvmConfigArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmConfigArgs(@Nullable String... elements) {
      if (this.jvmConfigArgs == null) {
        this.jvmConfigArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmConfigArgs.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JavaApp#getJvmConfigArgs() jvmConfigArgs} list.
     * @param elements An iterable of jvmConfigArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jvmConfigArgs(@Nullable Iterable<@Nullable String> elements) {
      if (elements == null) {
        this.jvmConfigArgs = null;
        return this;
      }
      this.jvmConfigArgs = new ArrayList<String>();
      return addAllJvmConfigArgs(elements);
    }

    /**
     * Adds elements to {@link JavaApp#getJvmConfigArgs() jvmConfigArgs} list.
     * @param elements An iterable of jvmConfigArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJvmConfigArgs(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "jvmConfigArgs element");
      if (this.jvmConfigArgs == null) {
        this.jvmConfigArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmConfigArgs.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JavaApp#getMainClass() mainClass} attribute.
     * @param mainClass The value for mainClass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mainClass(@Nullable String mainClass) {
      this.mainClass = mainClass;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJavaApp ImmutableJavaApp}.
     * @return An immutable instance of JavaApp
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaApp build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaApp(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_UNIQUE_NAME) != 0) attributes.add("uniqueName");
      return "Cannot build JavaApp, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
