/*
 * Copyright (C) 2023 Ashley Scopes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link FilesToCompile}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFilesToCompile.builder()}.
 */
@Generated(from = "FilesToCompile", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFilesToCompile
    implements FilesToCompile {
  private final @Nullable Collection<Path> protoSources;
  private final @Nullable Collection<String> descriptorFiles;
  private transient final boolean empty;

  private ImmutableFilesToCompile(ImmutableFilesToCompile.Builder builder) {
    this.protoSources = builder.protoSources;
    this.descriptorFiles = builder.descriptorFiles;
    this.empty = FilesToCompile.super.isEmpty();
  }

  /**
   * @return The value of the {@code protoSources} attribute
   */
  @Override
  public @Nullable Collection<Path> getProtoSources() {
    return protoSources;
  }

  /**
   * @return The value of the {@code descriptorFiles} attribute
   */
  @Override
  public @Nullable Collection<String> getDescriptorFiles() {
    return descriptorFiles;
  }

  /**
   * @return The computed-at-construction value of the {@code empty} attribute
   */
  @Override
  public boolean isEmpty() {
    return empty;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFilesToCompile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFilesToCompile
        && equalsByValue((ImmutableFilesToCompile) another);
  }

  private boolean equalsByValue(ImmutableFilesToCompile another) {
    return Objects.equals(protoSources, another.protoSources)
        && Objects.equals(descriptorFiles, another.descriptorFiles)
        && empty == another.empty;
  }

  /**
   * Computes a hash code from attributes: {@code protoSources}, {@code descriptorFiles}, {@code empty}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(protoSources);
    h += (h << 5) + Objects.hashCode(descriptorFiles);
    h += (h << 5) + Boolean.hashCode(empty);
    return h;
  }

  /**
   * Prints the immutable value {@code FilesToCompile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FilesToCompile{"
        + "protoSources=" + protoSources
        + ", descriptorFiles=" + descriptorFiles
        + ", empty=" + empty
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableFilesToCompile ImmutableFilesToCompile}.
   * <pre>
   * ImmutableFilesToCompile.builder()
   *    .protoSources(Collection&lt;java.nio.file.Path&gt; | null) // nullable {@link FilesToCompile#getProtoSources() protoSources}
   *    .descriptorFiles(Collection&lt;String&gt; | null) // nullable {@link FilesToCompile#getDescriptorFiles() descriptorFiles}
   *    .build();
   * </pre>
   * @return A new ImmutableFilesToCompile builder
   */
  public static ImmutableFilesToCompile.Builder builder() {
    return new ImmutableFilesToCompile.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFilesToCompile ImmutableFilesToCompile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FilesToCompile", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PROTO_SOURCES = 0x1L;
    private static final long INIT_BIT_DESCRIPTOR_FILES = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Collection<Path> protoSources;
    private @Nullable Collection<String> descriptorFiles;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FilesToCompile} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FilesToCompile instance) {
      Objects.requireNonNull(instance, "instance");
      Collection<Path> protoSourcesValue = instance.getProtoSources();
      if (protoSourcesValue != null) {
        protoSources(protoSourcesValue);
      }
      Collection<String> descriptorFilesValue = instance.getDescriptorFiles();
      if (descriptorFilesValue != null) {
        descriptorFiles(descriptorFilesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FilesToCompile#getProtoSources() protoSources} attribute.
     * @param protoSources The value for protoSources (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protoSources(Collection<Path> protoSources) {
      this.protoSources = protoSources;
      initBits &= ~INIT_BIT_PROTO_SOURCES;
      return this;
    }

    /**
     * Initializes the value for the {@link FilesToCompile#getDescriptorFiles() descriptorFiles} attribute.
     * @param descriptorFiles The value for descriptorFiles (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descriptorFiles(Collection<String> descriptorFiles) {
      this.descriptorFiles = descriptorFiles;
      initBits &= ~INIT_BIT_DESCRIPTOR_FILES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFilesToCompile ImmutableFilesToCompile}.
     * @return An immutable instance of FilesToCompile
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFilesToCompile build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFilesToCompile(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROTO_SOURCES) != 0) attributes.add("protoSources");
      if ((initBits & INIT_BIT_DESCRIPTOR_FILES) != 0) attributes.add("descriptorFiles");
      return "Cannot build FilesToCompile, some of required attributes are not set " + attributes;
    }
  }
}
