/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProjectHelper;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputDescriptorAttachmentRegistrar {
    private static final Logger log = LoggerFactory.getLogger(OutputDescriptorAttachmentRegistrar.class);
    private final MavenProjectHelper mavenProjectHelper;
    private final String defaultArtifactType;
    private final @Nullable String defaultArtifactClassifier;

    public OutputDescriptorAttachmentRegistrar(MavenProjectHelper mavenProjectHelper, String defaultArtifactType, @Nullable String defaultArtifactClassifier) {
        this.mavenProjectHelper = mavenProjectHelper;
        this.defaultArtifactType = defaultArtifactType;
        this.defaultArtifactClassifier = defaultArtifactClassifier;
    }

    public void registerAttachedArtifact(MavenSession session, Path artifactPath, @Nullable String artifactType, @Nullable String artifactClassifier) {
        String resolvedArtifactType = Optional.ofNullable(artifactType).orElse(this.defaultArtifactType);
        String resolvedArtifactClassifier = Optional.ofNullable(artifactClassifier).orElse(this.defaultArtifactClassifier);
        log.info("Attaching \"{}\" to build outputs with type \"{}\" and classifier \"{}\"", new Object[]{artifactPath, resolvedArtifactType, resolvedArtifactClassifier});
        this.mavenProjectHelper.attachArtifact(session.getCurrentProject(), resolvedArtifactType, resolvedArtifactClassifier, artifactPath.toFile());
    }
}

