/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;

public class DoubleRangeRandomizer
extends AbstractRangeRandomizer<Double> {
    public DoubleRangeRandomizer(Double min, Double max) {
        super(min, max);
    }

    public DoubleRangeRandomizer(Double min, Double max, long seed) {
        super(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if ((Double)this.min > (Double)this.max) {
            throw new IllegalArgumentException("max must be greater than min");
        }
    }

    @Override
    protected Double getDefaultMinValue() {
        return Double.MIN_VALUE;
    }

    @Override
    protected Double getDefaultMaxValue() {
        return Double.MAX_VALUE;
    }

    public static DoubleRangeRandomizer aNewDoubleRangeRandomizer(Double min, Double max) {
        return new DoubleRangeRandomizer(min, max);
    }

    public static DoubleRangeRandomizer aNewDoubleRangeRandomizer(Double min, Double max, long seed) {
        return new DoubleRangeRandomizer(min, max, seed);
    }

    @Override
    public Double getRandomValue() {
        return this.nextDouble((Double)this.min, (Double)this.max);
    }
}

