/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.range.LocalDateRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.LocalDateTimeRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.LocalTimeRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.OffsetDateTimeRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.OffsetTimeRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.YearMonthRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.YearRangeRandomizer;
import io.github.benas.randombeans.randomizers.range.ZonedDateTimeRangeRandomizer;
import io.github.benas.randombeans.randomizers.time.DurationRandomizer;
import io.github.benas.randombeans.randomizers.time.GregorianCalendarRandomizer;
import io.github.benas.randombeans.randomizers.time.InstantRandomizer;
import io.github.benas.randombeans.randomizers.time.MonthDayRandomizer;
import io.github.benas.randombeans.randomizers.time.PeriodRandomizer;
import io.github.benas.randombeans.randomizers.time.TimeZoneRandomizer;
import io.github.benas.randombeans.randomizers.time.ZoneIdRandomizer;
import io.github.benas.randombeans.randomizers.time.ZoneOffsetRandomizer;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

@Priority(value=-3)
public class TimeRandomizerRegistry
implements RandomizerRegistry {
    private final Map<Class<?>, Randomizer<?>> randomizers = new HashMap();

    @Override
    public void init(EnhancedRandomParameters parameters) {
        long seed = parameters.getSeed();
        LocalDate minDate = parameters.getDateRange().getMin();
        LocalDate maxDate = parameters.getDateRange().getMax();
        LocalTime minTime = parameters.getTimeRange().getMin();
        LocalTime maxTime = parameters.getTimeRange().getMax();
        this.randomizers.put(Duration.class, new DurationRandomizer(seed));
        this.randomizers.put(GregorianCalendar.class, new GregorianCalendarRandomizer(seed));
        this.randomizers.put(Instant.class, new InstantRandomizer(seed));
        this.randomizers.put(LocalDate.class, new LocalDateRangeRandomizer(minDate, maxDate, seed));
        this.randomizers.put(LocalDateTime.class, new LocalDateTimeRangeRandomizer(LocalDateTime.of(minDate, minTime), LocalDateTime.of(maxDate, maxTime), seed));
        this.randomizers.put(LocalTime.class, new LocalTimeRangeRandomizer(minTime, maxTime, seed));
        this.randomizers.put(MonthDay.class, new MonthDayRandomizer(seed));
        this.randomizers.put(OffsetDateTime.class, new OffsetDateTimeRangeRandomizer(TimeRandomizerRegistry.toOffsetDateTime(minDate, minTime), TimeRandomizerRegistry.toOffsetDateTime(maxDate, maxTime), seed));
        this.randomizers.put(OffsetTime.class, new OffsetTimeRangeRandomizer(minTime.atOffset(OffsetDateTime.now().getOffset()), maxTime.atOffset(OffsetDateTime.now().getOffset()), seed));
        this.randomizers.put(Period.class, new PeriodRandomizer(seed));
        this.randomizers.put(TimeZone.class, new TimeZoneRandomizer(seed));
        this.randomizers.put(YearMonth.class, new YearMonthRangeRandomizer(YearMonth.of(minDate.getYear(), minDate.getMonth()), YearMonth.of(maxDate.getYear(), maxDate.getMonth()), seed));
        this.randomizers.put(Year.class, new YearRangeRandomizer(Year.of(minDate.getYear()), Year.of(maxDate.getYear()), seed));
        this.randomizers.put(ZonedDateTime.class, new ZonedDateTimeRangeRandomizer(TimeRandomizerRegistry.toZonedDateTime(minDate, minTime), TimeRandomizerRegistry.toZonedDateTime(maxDate, maxTime), seed));
        this.randomizers.put(ZoneOffset.class, new ZoneOffsetRandomizer(seed));
        this.randomizers.put(ZoneId.class, new ZoneIdRandomizer(seed));
    }

    private static ZonedDateTime toZonedDateTime(LocalDate localDate, LocalTime localTime) {
        return LocalDateTime.of(localDate, localTime).atZone(ZoneId.systemDefault());
    }

    private static OffsetDateTime toOffsetDateTime(LocalDate localDate, LocalTime localTime) {
        return LocalDateTime.of(localDate, localTime).atOffset(OffsetDateTime.now().getOffset());
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        return this.getRandomizer(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.randomizers.get(type);
    }
}

