/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.text;

import io.github.benas.randombeans.randomizers.AbstractRandomizer;
import io.github.benas.randombeans.randomizers.text.CharacterRandomizer;
import io.github.benas.randombeans.util.Constants;
import java.nio.charset.Charset;

public class StringRandomizer
extends AbstractRandomizer<String> {
    private final CharacterRandomizer characterRandomizer;
    private int maxLength = Constants.DEFAULT_STRING_LENGTH_RANGE.getMax();
    private int minLength = Constants.DEFAULT_STRING_LENGTH_RANGE.getMin();

    public StringRandomizer() {
        this.characterRandomizer = new CharacterRandomizer();
    }

    public StringRandomizer(Charset charset) {
        this.characterRandomizer = new CharacterRandomizer(charset);
    }

    public StringRandomizer(int maxLength) {
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer();
    }

    public StringRandomizer(long seed) {
        super(seed);
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(Charset charset, long seed) {
        super(seed);
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public StringRandomizer(int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(int minLength, int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(Charset charset, int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public StringRandomizer(Charset charset, int minLength, int maxLength, long seed) {
        super(seed);
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength should be less than or equal to maxLength");
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public static StringRandomizer aNewStringRandomizer() {
        return new StringRandomizer();
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset) {
        return new StringRandomizer(charset);
    }

    public static StringRandomizer aNewStringRandomizer(int maxLength) {
        return new StringRandomizer(maxLength);
    }

    public static StringRandomizer aNewStringRandomizer(long seed) {
        return new StringRandomizer(seed);
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset, long seed) {
        return new StringRandomizer(charset, seed);
    }

    public static StringRandomizer aNewStringRandomizer(int maxLength, long seed) {
        return new StringRandomizer(maxLength, seed);
    }

    public static StringRandomizer aNewStringRandomizer(int minLength, int maxLength, long seed) {
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength should be less than or equal to maxLength");
        }
        return new StringRandomizer(minLength, maxLength, seed);
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset, int maxLength, long seed) {
        return new StringRandomizer(charset, maxLength, seed);
    }

    public static StringRandomizer aNewStringRandomizer(Charset charset, int minLength, int maxLength, long seed) {
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength should be less than or equal to maxLength");
        }
        return new StringRandomizer(charset, minLength, maxLength, seed);
    }

    @Override
    public String getRandomValue() {
        int length = (int)this.nextDouble(this.minLength, this.maxLength);
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.characterRandomizer.getRandomValue().charValue();
        }
        return new String(chars);
    }
}

