/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.versions.UrlComparator;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class InternetExplorerDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.IEXPLORER;
    }

    @Override
    protected String getDriverName() {
        return "IEDriverServer";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getIExplorerDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return "";
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setIExplorerDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
    }

    @Override
    protected URL getDriverUrl() {
        return this.config().getIExplorerDriverUrl();
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getIExplorerDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setIExplorerDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls() throws IOException {
        List<URL> driverUrls = this.getDriversFromGitHub();
        Collections.sort(driverUrls, new UrlComparator());
        return driverUrls;
    }

    @Override
    protected Optional<String> getBrowserVersionFromTheShell() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return Optional.empty();
    }

    @Override
    protected NamespaceContext getNamespaceContext() {
        return S3_NAMESPACE_CONTEXT;
    }

    @Override
    public Optional<Path> getBrowserPath() {
        throw new WebDriverManagerException("The browser path of " + this.getDriverManagerType().getBrowserName() + " cannot be found since it is a legacy browser and not maintained in the commands database");
    }

    @Override
    protected Capabilities getCapabilities() {
        return new InternetExplorerOptions();
    }

    @Override
    protected String getCurrentVersion(URL url) {
        String currentVersion = super.getCurrentVersion(url);
        String versionRegex = this.config.getBrowserVersionDetectionRegex();
        return currentVersion.replaceAll(versionRegex, "");
    }

    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setInternetExplorerDriverExport(exportParameter);
        return this;
    }
}

