/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.webdriver;

import io.github.bonigarcia.wdm.docker.DockerContainer;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverBrowser {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    WebDriver driver;
    List<DockerContainer> dockerContainerList;
    String browserContainerId;
    String noVncUrl;
    String seleniumServerUrl;
    Path recordingPath;
    int identityHash;

    public WebDriverBrowser() {
        this.dockerContainerList = new ArrayList<DockerContainer>();
    }

    public WebDriverBrowser(WebDriver driver) {
        this.setDriver(driver);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
        this.identityHash = this.calculateIdentityHash(driver);
    }

    public List<DockerContainer> getDockerContainerList() {
        return this.dockerContainerList;
    }

    public void addDockerContainer(DockerContainer dockerContainer) {
        this.dockerContainerList.add(dockerContainer);
    }

    public void addDockerContainer(DockerContainer dockerContainer, int position) {
        this.dockerContainerList.add(position, dockerContainer);
    }

    public String getBrowserContainerId() {
        return this.browserContainerId;
    }

    public void setBrowserContainerId(String browserContainerId) {
        this.browserContainerId = browserContainerId;
    }

    public URL getNoVncUrl() {
        return this.getUrl(this.noVncUrl);
    }

    public void setNoVncUrl(String noVncUrl) {
        this.noVncUrl = noVncUrl;
    }

    public URL getSeleniumServerUrl() {
        return this.getUrl(this.seleniumServerUrl);
    }

    public void setSeleniumServerUrl(String seleniumServerUrl) {
        this.seleniumServerUrl = seleniumServerUrl;
    }

    protected URL getUrl(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.log.error("Exception creating URL", (Throwable)e);
        }
        return url;
    }

    public Path getRecordingPath() {
        return this.recordingPath;
    }

    public void setRecordingPath(Path recordingPath) {
        this.recordingPath = recordingPath;
    }

    public int getIdentityHash() {
        return this.identityHash;
    }

    public int calculateIdentityHash(Object object) {
        return System.identityHashCode(object);
    }
}

