/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2023-2025 Jeremy Long. All Rights Reserved.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AbstractPageable implements Serializable {

    /**
     * Serialization version UID.
     */
    private static final long serialVersionUID = 7420520124100919177L;
    @JsonProperty(value = "totalCount", access = JsonProperty.Access.WRITE_ONLY)
    private int totalCount;

    @JsonProperty(value = "pageInfo", access = JsonProperty.Access.WRITE_ONLY)
    private PageInfo pageInfo;

    @JsonIgnore
    int getTotalCount() {
        return totalCount;
    }

    @JsonIgnore()
    PageInfo getPageInfo() {
        return pageInfo;
    }

}
