/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.NullableConfigurationHolder;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.OperationType;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.utils.ParameterLocation;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;

public class SpringMvcReader
extends AstractLibraryReader {
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(9);

    public SpringMvcReader(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public List<String> readBasePaths(Class<?> clazz, MergedAnnotations mergedAnnotations) {
        String[] paths;
        List<String> basePaths = Collections.singletonList("");
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(RequestMapping.class);
        if (requestMappingMergedAnnotation.isPresent() && (paths = requestMappingMergedAnnotation.getStringArray("value")).length > 0) {
            basePaths = Arrays.asList(paths);
        }
        return basePaths;
    }

    @Override
    public void computeAnnotations(Class clazz, String basePath, Method method, MergedAnnotations mergedAnnotations, Tag tag) throws MojoFailureException {
        RequestMethod[] requestMethods;
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(RequestMapping.class);
        if (requestMappingMergedAnnotation.isPresent() && !this.excludedByReturnType(method) && (requestMethods = (RequestMethod[])requestMappingMergedAnnotation.getEnumArray("method", RequestMethod.class)).length > 0) {
            this.logger.debug((CharSequence)("Parsing request method : " + method.getName()));
            String methodIdentifier = JavaClassAnalyser.createIdentifier(method);
            List<ParameterObject> parameterObjects = this.readParameters(clazz, method);
            DataObject responseObject = this.readResponseObject(clazz, method, mergedAnnotations);
            int responseCode = this.readResponseCode(mergedAnnotations);
            List<String> paths = this.readEndpointPaths(basePath, (MergedAnnotation<? extends Annotation>)requestMappingMergedAnnotation);
            for (RequestMethod requestMethod : requestMethods) {
                for (String path : paths) {
                    Endpoint endpoint = new Endpoint();
                    endpoint.setType(OperationType.fromJavax(requestMethod));
                    endpoint.setPath(path);
                    endpoint.setName(method.getName());
                    endpoint.setParameters(parameterObjects);
                    endpoint.setResponseObject(responseObject);
                    endpoint.setResponseCode(responseCode);
                    this.setConsumeProduceProperties(endpoint, mergedAnnotations);
                    endpoint.setIdentifier(methodIdentifier);
                    endpoint.setDeprecated(this.isDeprecated(method));
                    tag.addEndpoint(endpoint);
                    this.logger.debug((CharSequence)("Finished parsing endpoint : " + endpoint.getName() + " - " + endpoint.getType().name()));
                }
            }
        }
    }

    private boolean excludedByReturnType(Method method) {
        return "org.springframework.web.servlet.ModelAndView".equals(method.getReturnType().getCanonicalName());
    }

    @Override
    protected List<ParameterObject> readParameters(Class clazz, Method originalMethod) {
        this.logger.debug((CharSequence)("Reading parameters from " + originalMethod.getName()));
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        LinkedHashMap<String, ParameterObject> parameters = new LinkedHashMap<String, ParameterObject>();
        for (Method method : overridenMethods) {
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation requestPartMA;
                MergedAnnotation requestBodyMA;
                MergedAnnotation requestParamMA;
                MergedAnnotation pathVariableMA;
                if (!OpenApiTypeResolver.INSTANCE.canBeDocumented(parameter)) continue;
                this.logger.debug((CharSequence)("Parameter : " + parameter.getName()));
                ParameterObject paramObj2 = parameters.computeIfAbsent(parameter.getName(), name -> this.unwrapParameterObject(new ParameterObject((String)name, this.genericityResolver.resolve(clazz, parameter.getParameterizedType()))));
                MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)parameter, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                boolean annotationFound = false;
                MergedAnnotation headerVariableMA = mergedAnnotations.get(RequestHeader.class);
                if (headerVariableMA.isPresent()) {
                    annotationFound = true;
                    paramObj2.setLocation(ParameterLocation.HEADER);
                    paramObj2.setRequired(headerVariableMA.getBoolean("required") && "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(headerVariableMA.getString("defaultValue")));
                    String value = headerVariableMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj2.setName(value);
                    }
                    this.logger.debug((CharSequence)("RequestHeader annotation detected (" + paramObj2.getName() + ")"));
                }
                if ((pathVariableMA = mergedAnnotations.get(PathVariable.class)).isPresent()) {
                    annotationFound = true;
                    paramObj2.setLocation(ParameterLocation.PATH);
                    paramObj2.setRequired(pathVariableMA.getBoolean("required"));
                    String value = pathVariableMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj2.setName(value);
                    }
                    this.logger.debug((CharSequence)("PathVariable annotation detected (" + paramObj2.getName() + ")"));
                }
                if ((requestParamMA = mergedAnnotations.get(RequestParam.class)).isPresent()) {
                    annotationFound = true;
                    if (paramObj2.isMultipartFile()) {
                        paramObj2.setLocation(ParameterLocation.BODY);
                    } else {
                        paramObj2.setLocation(ParameterLocation.QUERY);
                    }
                    paramObj2.setRequired(requestParamMA.getBoolean("required") && "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParamMA.getString("defaultValue")));
                    String value = requestParamMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj2.setName(value);
                    }
                    this.logger.debug((CharSequence)("RequestParam annotation detected (" + paramObj2.getName() + "), location is " + paramObj2.getLocation().toString()));
                }
                if ((requestBodyMA = mergedAnnotations.get(RequestBody.class)).isPresent()) {
                    annotationFound = true;
                    paramObj2.setLocation(ParameterLocation.BODY);
                    paramObj2.setRequired(requestBodyMA.getBoolean("required"));
                    this.logger.debug((CharSequence)("RequestBody annotation detected, location is " + paramObj2.getLocation().toString()));
                }
                if ((requestPartMA = mergedAnnotations.get(RequestPart.class)).isPresent()) {
                    annotationFound = true;
                    paramObj2.setLocation(ParameterLocation.BODY_PART);
                    paramObj2.setRequired(requestPartMA.getBoolean("required"));
                    String value = requestPartMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj2.setName(value);
                    }
                    this.logger.debug((CharSequence)("RequestPart annotation detected, location is " + paramObj2.getLocation().toString()));
                }
                if (!annotationFound && SpringMvcReader.isSpringSimpleProperty(parameter.getType())) {
                    paramObj2.setLocation(ParameterLocation.QUERY);
                    paramObj2.setRequired(true);
                }
                if (paramObj2.getClassRequired() == null) continue;
                paramObj2.setRequired(paramObj2.getClassRequired());
            }
        }
        LinkedHashMap unnestedParams = new LinkedHashMap(parameters);
        parameters.values().stream().filter(x -> x.getLocation() == null && SpringMvcReader.parameterObjectBindableToQueryParams(x)).forEach(paramObj -> this.bindDtoToQueryParams(unnestedParams, (ParameterObject)paramObj));
        return unnestedParams.values().stream().filter(x -> x.getLocation() != null).collect(Collectors.toList());
    }

    private static boolean parameterObjectBindableToQueryParams(ParameterObject paramObj) {
        List<Field> fields = ReflectionsUtils.getAllNonStaticFields(new ArrayList<Field>(), paramObj.getJavaClass());
        for (Field field : fields) {
            if (field.isAnnotationPresent(JsonIgnore.class) || BeanUtils.isSimpleProperty(field.getType()) || Collection.class.isAssignableFrom(field.getType()) || field.getType().isArray()) continue;
            return false;
        }
        return true;
    }

    private void bindDtoToQueryParams(Map<String, ParameterObject> parameters, ParameterObject paramObj) {
        List<Field> fields = ReflectionsUtils.getAllNonStaticFields(new ArrayList<Field>(), paramObj.getJavaClass());
        for (Field field : fields) {
            ParameterObject fieldObj = parameters.computeIfAbsent(field.getName(), name -> this.unwrapParameterObject(new ParameterObject((String)name, paramObj.getContextualType(field.getGenericType()))));
            fieldObj.setLocation(ParameterLocation.QUERY);
            fieldObj.setJavadocFieldClassName(paramObj.getJavaClass().getCanonicalName());
            if (fieldObj.getClassRequired() != null) {
                fieldObj.setRequired(paramObj.getClassRequired());
                continue;
            }
            if (NullableConfigurationHolder.hasNonNullAnnotation(Arrays.asList(field.getAnnotations()))) {
                fieldObj.setRequired(true);
                continue;
            }
            if (NullableConfigurationHolder.hasNullableAnnotation(Arrays.asList(field.getAnnotations()))) {
                fieldObj.setRequired(false);
                continue;
            }
            fieldObj.setRequired(NullableConfigurationHolder.isDefaultNonNullableFields());
        }
    }

    @Override
    protected List<String> readEndpointPaths(String basePath, MergedAnnotation<? extends Annotation> requestMappingMergedAnnotation) {
        String[] paths = requestMappingMergedAnnotation.getStringArray("path");
        ArrayList<String> resolvedPaths = new ArrayList<String>();
        if (paths.length == 0) {
            resolvedPaths.add(SpringMvcReader.concatenateBasePathAndMethodPath(basePath, "", this.apiConfiguration.getPathEnhancement()));
        }
        for (String path : paths) {
            resolvedPaths.add(SpringMvcReader.concatenateBasePathAndMethodPath(basePath, path, this.apiConfiguration.getPathEnhancement()));
        }
        return resolvedPaths;
    }

    @Override
    protected void setConsumeProduceProperties(Endpoint endpoint, MergedAnnotations mergedAnnotations) throws MojoFailureException {
        String[] produces;
        String[] consumes;
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(RequestMapping.class);
        Optional<ParameterObject> body = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).findAny();
        if (body.isPresent() && (consumes = requestMappingMergedAnnotation.getStringArray("consumes")).length > 0) {
            body.get().setFormats(Arrays.asList(consumes));
        }
        if (endpoint.getResponseObject() != null && (produces = requestMappingMergedAnnotation.getStringArray("produces")).length > 0) {
            endpoint.setResponseFormats(Arrays.asList(produces));
        }
    }

    @Override
    protected int readResponseCode(MergedAnnotations mergedAnnotations) {
        MergedAnnotation responseStatusMA = mergedAnnotations.get(ResponseStatus.class);
        if (!responseStatusMA.isPresent()) {
            return HttpStatus.OK.value();
        }
        return ((HttpStatus)responseStatusMA.getValue("value", HttpStatus.class).get()).value();
    }

    private static boolean isSpringSimpleProperty(Class<?> type) {
        return SpringMvcReader.isSimpleValueType(type) || type.isArray() && SpringMvcReader.isSimpleValueType(type.getComponentType());
    }

    private static boolean isSimpleValueType(Class<?> type) {
        return type != Void.TYPE && type != Void.class && (type.isPrimitive() || primitiveWrapperTypeMap.containsKey(type) || Enum.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type) || ZoneId.class.isAssignableFrom(type) || TimeZone.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || Path.class.isAssignableFrom(type) || Charset.class.isAssignableFrom(type) || Currency.class.isAssignableFrom(type) || InetAddress.class.isAssignableFrom(type) || URI.class == type || URL.class == type || UUID.class == type || Locale.class == type || Pattern.class == type || Class.class == type);
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Void.class, Void.TYPE);
    }
}

