/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.yaml.model.ContentType;
import io.github.kbuntrock.yaml.model.Property;
import io.github.kbuntrock.yaml.model.Schema;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Content {
    private Schema schema;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, ContentType> encoding;

    public static Content fromMultipartBodies(List<ParameterObject> parameterObjects) {
        Content content = new Content();
        content.schema = new Schema();
        content.schema.setType(OpenApiTypeResolver.OBJECT_TYPE);
        content.schema.setRequired(parameterObjects.stream().filter(ParameterObject::isRequired).map(ParameterObject::getName).collect(Collectors.toList()));
        content.schema.properties = parameterObjects.stream().collect(Collectors.toMap(ParameterObject::getName, po -> new Property(Content.fromDataObject((DataObject)po).schema)));
        return content;
    }

    public static Content fromMultipartFormData(List<ParameterObject> bodyParts, JavadocWrapper methodJavadoc) {
        Content content = new Content();
        content.schema = new Schema();
        content.schema.setType(OpenApiTypeResolver.OBJECT_TYPE);
        content.schema.setRequired(bodyParts.stream().filter(ParameterObject::isRequired).map(ParameterObject::getName).collect(Collectors.toList()));
        content.encoding = new LinkedHashMap<String, ContentType>();
        content.schema.properties = new LinkedHashMap<String, Property>();
        for (ParameterObject bodyPart : bodyParts) {
            String description;
            Optional<JavadocBlockTag> parameterDoc;
            Property property = new Property(Content.fromDataObject((DataObject)bodyPart).schema);
            content.schema.properties.put(bodyPart.getName(), property);
            if (bodyPart.getOpenApiResolvedType().getDefaultEncoding() != null) {
                content.encoding.put(bodyPart.getName(), new ContentType(bodyPart.getOpenApiResolvedType().getDefaultEncoding()));
            }
            if (methodJavadoc == null || !(parameterDoc = methodJavadoc.getParamBlockTagByName(bodyPart.getJavadocFieldName())).isPresent() || (description = parameterDoc.get().getContent().toText()).isEmpty()) continue;
            property.setDescription(parameterDoc.get().getContent().toText());
        }
        return content;
    }

    public static Content fromDataObject(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        HashSet<String> exploredSignatures = new HashSet<String>();
        Content content = new Content();
        content.schema = new Schema(dataObject, exploredSignatures);
        return content;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Map<String, ContentType> getEncoding() {
        return this.encoding;
    }
}

